/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.CopyOfFeed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.functions.DeepEqual40;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.BooleanValue;

public class DeepEqualStreamer
extends StreamingAdjunct
implements FeedMaker {
    private int consumingArg = -1;

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        this.consumingArg = DeepEqualStreamer.findConsumingArg(this.getExpression(), this.consumingArg);
        return super.getWatchMaker(forGrouping);
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        this.consumingArg = DeepEqualStreamer.findConsumingArg(this.getExpression(), this.consumingArg);
        if (this.consumingArg >= 2) {
            return this.getDefaultFeedMaker(this.consumingArg).makeItemFeed(watchManager, out, context);
        }
        SystemFunctionCall call = (SystemFunctionCall)this.getExpression();
        Posture posture = Streamability.getPosture(call.getArg(this.consumingArg));
        if (posture == Posture.GROUNDED || posture == Posture.CLIMBING) {
            return new GroundedDeepEqualFeed(watchManager, call, out, context, this.consumingArg);
        }
        GroundedDeepEqualFeed comparisonFeed = new GroundedDeepEqualFeed(watchManager, call, out, context, this.consumingArg);
        return new CopyOfFeed(watchManager, (ItemFeed)comparisonFeed, context);
    }

    private static class GroundedDeepEqualFeed
    extends ItemFeed {
        WatchManager watchManager;
        int consumingArg;
        SequenceIterator other;
        AtomicComparer comparer;
        boolean done;
        boolean closed;
        DeepEqual40.DeepEqualOptions options;

        public GroundedDeepEqualFeed(WatchManager watchManager, SystemFunctionCall exp, ItemFeed result, XPathContext context, int consumingArg) throws XPathException {
            super(exp, result, context);
            this.watchManager = watchManager;
            this.other = exp.getArg(1 - consumingArg).iterate(context);
            this.consumingArg = consumingArg;
            SystemFunctionCall call = (SystemFunctionCall)this.getExpression();
            Expression collationArg = exp.getArg(2);
            Item collationVal = collationArg.evaluateItem(context);
            String collationName = collationVal == null ? call.getRetainedStaticContext().getDefaultCollationName() : collationVal.getStringValue();
            Expression optionsArg = exp.getArg(3);
            MapItem suppliedOptions = (MapItem)optionsArg.evaluateItem(context);
            try {
                this.options = new DeepEqual40.DeepEqualOptions(suppliedOptions, collationName, context);
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }

        @Override
        public void append(Item item) throws XPathException {
            if (!this.done && !this.hasFailed()) {
                Item otherItem = this.other.next();
                try {
                    if (otherItem == null || !DeepEqual40.deepEqual(SingletonIterator.makeIterator(item), SingletonIterator.makeIterator(otherItem), this.getContext(), this.options)) {
                        this.getNextOutputter().append(BooleanValue.FALSE);
                        this.done = true;
                        if (this.watchManager.allowsEarlyExit()) {
                            this.closed = true;
                            this.getNextOutputter().close();
                            this.getTerminator().terminate();
                        }
                    }
                }
                catch (XPathException e) {
                    this.dynamicError(e);
                }
            }
        }

        @Override
        public void close() throws XPathException {
            if (!this.done) {
                boolean more = this.other.next() != null;
                this.getNextOutputter().append(BooleanValue.get(!more));
            }
            if (!this.closed) {
                this.getNextOutputter().close();
            }
        }
    }
}

