/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.feed.DecomposingFeed;
import com.saxonica.ee.stream.feed.SnapshotFeed;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.PatternWatch;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.Stack;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceCollector;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRule;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.functions.AccumulatorFn;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.tree.util.IndexedStack;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.AnyExternalObject;
import net.sf.saxon.value.ObjectValue;

public class AccumulatorWatch
extends PatternWatch {
    private final Accumulator accumulator;
    private final SimpleMode preDescentMode;
    private final SimpleMode postDescentMode;
    private final IndexedStack<Sequence> preDescentStack = new IndexedStack();
    private final Stack<ComplexContentOutputter> captureStack = new Stack();
    private Sequence currentValue;
    private FleetingNode lastPredescentNode = null;
    private FleetingNode lastPostdescentNode = null;
    private AccumulatorFn.Phase beingComputed = AccumulatorFn.Phase.UNSPECIFIED;
    private XPathContextMajor context;
    private WatchManager watchManager;
    private Stack<FleetingNode> nodeStack;

    public AccumulatorWatch(Accumulator accumulator) {
        this.accumulator = accumulator;
        this.preDescentMode = accumulator.getPreDescentRules();
        this.postDescentMode = accumulator.getPostDescentRules();
        this.setSelection(new NodeTestPattern(AnyNodeTest.getInstance()));
    }

    public Accumulator getAccumulator() {
        return this.accumulator;
    }

    public XPathContext getContext() {
        return this.context;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        this.context = this.watchManager.getXPathContext().newCleanContext();
        this.context.setCurrentComponent(this.accumulator.getDeclaringComponent());
        SlotManager slotManager = this.accumulator.getSlotManagerForInitialValueExpression();
        this.context.setStackFrame(slotManager, SequenceTool.makeSequenceArray(slotManager.getNumberOfVariables()));
        this.context.setCurrentIterator(new ManualIterator());
        try {
            this.currentValue = ExpressionTool.eagerEvaluate(this.accumulator.getInitialValueExpression(), this.getContext());
        }
        catch (XPathException err) {
            this.currentValue = new ObjectValue<XPathException>(err);
        }
    }

    public void setNodeStack(Stack<FleetingNode> stack) {
        this.nodeStack = stack;
    }

    public void setWatchManager(WatchManager watchManager) {
        this.watchManager = watchManager;
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        Rule capture;
        int nodeNr = node.getNodeNumber();
        if (this.lastPredescentNode != null && nodeNr == this.lastPredescentNode.getNodeNumber()) {
            return null;
        }
        this.lastPredescentNode = node;
        ManualIterator iter = (ManualIterator)this.context.getCurrentIterator();
        iter.setContextItem(node);
        iter.incrementPosition();
        Rule rule = this.preDescentMode.getRule(node, this.context);
        Sequence value = this.currentValue;
        if (rule != null) {
            this.beingComputed = AccumulatorFn.Phase.BEFORE;
            value = this.applyRule(node, rule);
            this.beingComputed = AccumulatorFn.Phase.UNSPECIFIED;
            this.currentValue = value;
            if (this.accumulator.isTracing()) {
                this.context.getConfiguration().getLogger().info(this.accumulator.getAccumulatorName().getDisplayName() + " BEFORE " + Navigator.getPath(node) + ": " + Err.depictSequence(value));
            }
        }
        if ((capture = this.postDescentMode.getRule(node, this.context)) != null && ((AccumulatorRule)capture.getAction()).isCapturing()) {
            SequenceCollector so = new SequenceCollector(this.getPipelineConfiguration());
            ComplexContentOutputter cco = new ComplexContentOutputter(so);
            DecomposingFeed feed = new DecomposingFeed(cco, (XPathContext)this.context);
            Trigger snapshotWatch = SnapshotFeed.getWatch(feed, AnchorPattern.getInstance(), this.watchManager, this.context);
            this.watchManager.addWatch(snapshotWatch, true);
            this.captureStack.push(cco);
        }
        int depth = this.nodeStack.size();
        AccumulatorWatch.setAtDepth(this.preDescentStack, depth - 1, value);
        return null;
    }

    private static boolean valueIsException(Sequence value) {
        return value instanceof AnyExternalObject && ((AnyExternalObject)value).getWrappedObject() instanceof XPathException;
    }

    private static void detectErrorValue(Sequence value) throws XPathException {
        if (AccumulatorWatch.valueIsException(value)) {
            throw (XPathException)((AnyExternalObject)value).getWrappedObject();
        }
    }

    private Sequence applyRule(FleetingNode node, Rule rule) throws XPathException {
        if (AccumulatorWatch.valueIsException(this.currentValue)) {
            return this.currentValue;
        }
        AccumulatorRule target = (AccumulatorRule)rule.getAction();
        Expression delta = target.getNewValueExpression();
        XPathContextMajor c2 = this.context.newCleanContext();
        Controller controller = c2.getController();
        assert (controller != null);
        NodeInfo targetNode = node;
        if (target.isPostDescent() && target.isCapturing()) {
            ComplexContentOutputter cco = this.captureStack.pop();
            SequenceCollector so = (SequenceCollector)cco.getReceiver();
            targetNode = (NodeInfo)so.getFirstItem();
        }
        ManualIterator initialNode = new ManualIterator(targetNode);
        c2.setCurrentIterator(initialNode);
        c2.openStackFrame(target.getStackFrameMap());
        c2.setLocalVariable(0, this.currentValue);
        c2.setCurrentComponent(this.accumulator.getDeclaringComponent());
        c2.setTemporaryOutputState(130);
        try {
            return ExpressionTool.eagerEvaluate(delta, c2);
        }
        catch (XPathException e) {
            return new ObjectValue<XPathException>(e);
        }
    }

    private static void setAtDepth(IndexedStack<Sequence> stack, int depth, Sequence value) {
        if (depth >= stack.size()) {
            stack.push(value);
        } else {
            stack.set(depth, value);
        }
    }

    public boolean isBeingComputed(AccumulatorFn.Phase phase) {
        return this.beingComputed == phase;
    }

    @Override
    public void processItem(Item item) throws XPathException {
        FleetingNode node = (FleetingNode)item;
        if (node.getNodeKind() == 2) {
            return;
        }
        ManualIterator iter = (ManualIterator)this.context.getCurrentIterator();
        iter.setContextItem(item);
        iter.incrementPosition();
        int nodeNr = node.getNodeNumber();
        if (this.lastPredescentNode != null && nodeNr == this.lastPredescentNode.getNodeNumber()) {
            return;
        }
        this.lastPredescentNode = node;
        Rule rule = this.preDescentMode.getRule(item, this.context);
        if (rule != null) {
            this.beingComputed = AccumulatorFn.Phase.BEFORE;
            this.currentValue = this.applyRule(node, rule);
            this.beingComputed = AccumulatorFn.Phase.UNSPECIFIED;
            if (this.accumulator.isTracing()) {
                this.context.getConfiguration().getLogger().info(this.accumulator.getAccumulatorName().getDisplayName() + " BEFORE " + Navigator.getPath(node) + ": " + Err.depictSequence(this.currentValue));
            }
        }
        int depth = this.nodeStack.size();
        AccumulatorWatch.setAtDepth(this.preDescentStack, depth, this.currentValue);
        rule = this.postDescentMode.getRule(item, this.context);
        if (rule != null) {
            this.beingComputed = AccumulatorFn.Phase.AFTER;
            this.currentValue = this.applyRule(node, rule);
            this.beingComputed = AccumulatorFn.Phase.UNSPECIFIED;
            if (this.accumulator.isTracing()) {
                this.context.getConfiguration().getLogger().info(this.accumulator.getAccumulatorName().getDisplayName() + " AFTER " + Navigator.getPath(node) + ": " + Err.depictSequence(this.currentValue));
            }
        }
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        FleetingNode node = this.nodeStack.peek();
        int nodeNr = node.getNodeNumber();
        if (this.lastPostdescentNode != null && nodeNr == this.lastPostdescentNode.getNodeNumber()) {
            return;
        }
        this.lastPostdescentNode = node;
        Rule rule = this.postDescentMode.getRule(node, this.context);
        if (rule != null) {
            this.beingComputed = AccumulatorFn.Phase.AFTER;
            this.currentValue = this.applyRule(node, rule);
            this.beingComputed = AccumulatorFn.Phase.UNSPECIFIED;
            if (this.accumulator.isTracing()) {
                this.context.getConfiguration().getLogger().info(this.accumulator.getAccumulatorName().getDisplayName() + " AFTER " + Navigator.getPath(node) + ": " + Err.depictSequence(this.currentValue));
            }
        }
    }

    @Override
    public void close() throws XPathException {
    }

    public Sequence getPreDescentValue(FleetingNode node) throws XPathException {
        if (this.lastPredescentNode == null || node.getNodeNumber() > this.lastPredescentNode.getNodeNumber()) {
            if (node instanceof FleetingParentNode) {
                this.startSelectedParentNode((FleetingParentNode)node, Loc.NONE);
            } else {
                this.processItem(node);
            }
        }
        AccumulatorWatch.detectErrorValue(this.currentValue);
        Sequence value = this.preDescentStack.get(node.getDepth());
        AccumulatorWatch.detectErrorValue(value);
        return value;
    }

    public Sequence getPreDescentValueAtDepth(int depth) throws XPathException {
        Sequence value = this.preDescentStack.get(depth);
        AccumulatorWatch.detectErrorValue(value);
        return value;
    }

    public Sequence getPostDescentValue(FleetingNode node) throws XPathException {
        if (node == null) {
            node = this.nodeStack.peek();
        }
        if (this.lastPostdescentNode == null || node.getNodeNumber() > this.lastPostdescentNode.getNodeNumber()) {
            if (node instanceof FleetingParentNode) {
                this.endSelectedParentNode(Loc.NONE);
            } else {
                this.processItem(node);
            }
        }
        Sequence value = this.currentValue;
        AccumulatorWatch.detectErrorValue(value);
        return value;
    }
}

