/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.hof;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.hof.CurriedFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.SequenceType;

public class PartialApply
extends Expression {
    private final Operand baseOp;
    private final Operand[] boundArgumentsOp;

    public PartialApply(Expression base, Expression[] boundArguments) {
        this.baseOp = new Operand(this, base, OperandRole.INSPECT);
        this.adoptChildExpression(base);
        this.boundArgumentsOp = new Operand[boundArguments.length];
        for (int i = 0; i < boundArguments.length; ++i) {
            if (boundArguments[i] == null) continue;
            this.boundArgumentsOp[i] = new Operand(this, boundArguments[i], OperandRole.NAVIGATE);
            this.adoptChildExpression(boundArguments[i]);
        }
    }

    public Expression getBaseExpression() {
        return this.baseOp.getChildExpression();
    }

    public void setBaseExpression(Expression base) {
        this.baseOp.setChildExpression(base);
    }

    public int getNumberOfPlaceHolders() {
        int n = 0;
        for (Operand o : this.boundArgumentsOp) {
            if (o != null) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        ItemType baseType = this.getBaseExpression().getItemType();
        Object[] argTypes = new SequenceType[this.boundArgumentsOp.length];
        Arrays.fill(argTypes, SequenceType.ANY_SEQUENCE);
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(false);
        for (int i = 0; i < this.boundArgumentsOp.length; ++i) {
            Operand op = this.boundArgumentsOp[i];
            if (op == null) continue;
            Expression arg = op.getChildExpression();
            if (!(baseType instanceof SpecificFunctionType) || i >= ((SpecificFunctionType)baseType).getArity()) continue;
            int pos = i;
            Supplier<RoleDiagnostic> argRole = () -> new RoleDiagnostic(0, "saxon:call", pos);
            SequenceType requiredArgType = ((SpecificFunctionType)baseType).getArgumentTypes()[i];
            argTypes[i] = requiredArgType;
            Expression a3 = tc.staticTypeCheck(arg, requiredArgType, argRole, visitor);
            if (a3 == arg) continue;
            op.setChildExpression(a3);
        }
        Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(21, this.getBaseExpression().toShortString(), 0);
        this.setBaseExpression(tc.staticTypeCheck(this.getBaseExpression(), SequenceType.SINGLE_FUNCTION, role, visitor));
        return this;
    }

    @Override
    public ItemType getItemType() {
        ItemType baseItemType = this.getBaseExpression().getItemType();
        SequenceType resultType = SequenceType.ANY_SEQUENCE;
        if (baseItemType instanceof SpecificFunctionType) {
            resultType = ((SpecificFunctionType)baseItemType).getResultType();
        }
        int placeholders = this.getNumberOfPlaceHolders();
        Object[] argTypes = new SequenceType[placeholders];
        if (baseItemType instanceof SpecificFunctionType) {
            int j = 0;
            for (int i = 0; i < this.boundArgumentsOp.length; ++i) {
                if (this.boundArgumentsOp[i] != null) continue;
                argTypes[j++] = ((SpecificFunctionType)baseItemType).getArgumentTypes()[i];
            }
        } else {
            Arrays.fill(argTypes, SequenceType.ANY_SEQUENCE);
        }
        return new SpecificFunctionType((SequenceType[])argTypes, resultType);
    }

    @Override
    protected int computeSpecialProperties() {
        return 0x10000000;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> operanda = new ArrayList<Operand>(this.boundArgumentsOp.length + 1);
        operanda.add(this.baseOp);
        for (Operand o : this.boundArgumentsOp) {
            if (o == null) continue;
            operanda.add(o);
        }
        return operanda;
    }

    public int getNumberOfArguments() {
        return this.boundArgumentsOp.length;
    }

    public Expression getArgument(int n) {
        Operand o = this.boundArgumentsOp[n];
        return o == null ? null : o.getChildExpression();
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof PartialApply)) {
            return false;
        }
        PartialApply pa2 = (PartialApply)other;
        if (!this.getBaseExpression().isEqual(pa2.getBaseExpression())) {
            return false;
        }
        if (this.boundArgumentsOp.length != pa2.boundArgumentsOp.length) {
            return false;
        }
        for (int i = 0; i < this.boundArgumentsOp.length; ++i) {
            if (this.boundArgumentsOp[i] == null != (pa2.boundArgumentsOp[i] == null)) {
                return false;
            }
            if (this.boundArgumentsOp[i] == null || this.boundArgumentsOp[i].equals(pa2.boundArgumentsOp[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int computeHashCode() {
        int h = 594252448;
        int i = 0;
        for (Operand o : this.operands()) {
            h ^= o == null ? i++ : o.getChildExpression().hashCode();
        }
        return h;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("partialApply", this);
        this.getBaseExpression().export(out);
        for (Operand o : this.boundArgumentsOp) {
            if (o == null) {
                out.startElement("null", this);
                out.endElement();
                continue;
            }
            o.getChildExpression().export(out);
        }
        out.endElement();
    }

    @Override
    protected int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        Expression[] boundArgumentsCopy = new Expression[this.boundArgumentsOp.length];
        for (int i = 0; i < this.boundArgumentsOp.length; ++i) {
            boundArgumentsCopy[i] = this.boundArgumentsOp[i] == null ? null : this.boundArgumentsOp[i].getChildExpression().copy(rebindings);
        }
        PartialApply exp = new PartialApply(this.getBaseExpression().copy(rebindings), boundArgumentsCopy);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder(64);
        boolean par = this.getBaseExpression().operands().iterator().hasNext();
        if (par) {
            buff.append("(" + this.getBaseExpression().toString() + ")");
        } else {
            buff.append(this.getBaseExpression().toString());
        }
        buff.append("(");
        for (int i = 0; i < this.boundArgumentsOp.length; ++i) {
            if (this.boundArgumentsOp[i] == null) {
                buff.append("?");
            } else {
                buff.append(this.boundArgumentsOp[i].getChildExpression().toString());
            }
            if (i == this.boundArgumentsOp.length - 1) continue;
            buff.append(", ");
        }
        buff.append(")");
        return buff.toString();
    }

    @Override
    public FunctionItem evaluateItem(XPathContext context) throws XPathException {
        return (FunctionItem)this.makeElaborator().elaborateForItem().eval(context);
    }

    @Override
    public String getExpressionName() {
        return "partialApply";
    }

    @Override
    public Elaborator getElaborator() {
        return new PartialApplyElaborator();
    }

    private static class PartialApplyElaborator
    extends ItemElaborator {
        private PartialApplyElaborator() {
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            PartialApply expr = (PartialApply)this.getExpression();
            ItemEvaluator functionEval = expr.getBaseExpression().makeElaborator().elaborateForItem();
            int len = expr.boundArgumentsOp.length;
            SequenceEvaluator[] boundArgumentsEvaluators = new SequenceEvaluator[len];
            for (int i = 0; i < len; ++i) {
                boundArgumentsEvaluators[i] = expr.boundArgumentsOp[i] == null ? null : expr.boundArgumentsOp[i].getChildExpression().makeElaborator().eagerly();
            }
            return context -> {
                FunctionItem f = (FunctionItem)functionEval.eval(context);
                assert (f != null);
                if (f.getArity() != len) {
                    throw new XPathException("The number of arguments supplied in the partial function application is " + len + ", but the arity of the function item is " + f.getArity(), "XPTY0004");
                }
                Sequence[] values = new Sequence[len];
                for (int i = 0; i < boundArgumentsEvaluators.length; ++i) {
                    if (boundArgumentsEvaluators[i] == null) continue;
                    values[i] = boundArgumentsEvaluators[i].evaluate(context);
                }
                return new CurriedFunction(f, values);
            };
        }
    }
}

