/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.IntegratedFunctionCall;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;

public class JavaExtensionFunctionCall
extends FunctionCall
implements Callable {
    private Configuration config;
    private StructuredQName name;
    private AccessibleObject theMethod;
    private Class<?>[] theParameterTypes;
    private Type[] theGenericParameterTypes;
    private PJConverter[] argumentConverters;
    private JPConverter resultConverter;
    private boolean checkForNodes;
    private Class<?> theClass;
    private JavaExternalObjectType declaredType;
    private boolean returnVoidAsThis = false;
    private SequenceEvaluator[] argumentEvaluators = null;

    public void init(StructuredQName functionName, Class<?> theClass, AccessibleObject object, Configuration config) {
        this.config = config;
        this.name = functionName;
        this.theClass = theClass;
        this.theMethod = object;
        this.theParameterTypes = this.theMethod instanceof Constructor ? ((Constructor)this.theMethod).getParameterTypes() : (this.theMethod instanceof Method ? ((Method)this.theMethod).getParameterTypes() : null);
        this.returnVoidAsThis = functionName.getNamespaceUri().toString().endsWith("?void=this");
    }

    @Override
    public String getExpressionName() {
        return "javaCall";
    }

    @Override
    public StructuredQName getFunctionName() {
        return this.name;
    }

    @Override
    public FunctionItem getTargetFunction(XPathContext context) throws XPathException {
        return null;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        ItemType resultType;
        Object st;
        boolean isStatic;
        Expression e2 = super.typeCheck(visitor, contextInfo);
        if (e2 != this) {
            return e2;
        }
        Configuration config = visitor.getConfiguration();
        int firstParam = 0;
        int firstArg = 0;
        if (this.theMethod instanceof Constructor) {
            if (this.theParameterTypes == null) {
                this.theParameterTypes = ((Constructor)this.theMethod).getParameterTypes();
            }
        } else if (this.theMethod instanceof Method) {
            if (this.theParameterTypes == null) {
                this.theParameterTypes = ((Method)this.theMethod).getParameterTypes();
            }
            if (this.theGenericParameterTypes == null) {
                this.theGenericParameterTypes = ((Method)this.theMethod).getGenericParameterTypes();
            }
            firstArg = (isStatic = Modifier.isStatic(((Method)this.theMethod).getModifiers())) ? 0 : 1;
            boolean usesContext = this.theParameterTypes.length > 0 && this.theParameterTypes[0] == XPathContext.class;
            firstParam = usesContext ? 1 : 0;
        } else if (this.theMethod instanceof Field) {
            isStatic = Modifier.isStatic(((Field)this.theMethod).getModifiers());
            firstArg = isStatic ? 0 : 1;
        }
        this.argumentConverters = new PJConverter[this.getArity()];
        TypeChecker tc = config.getTypeChecker(false);
        if (firstArg != 0) {
            Supplier<RoleDiagnostic> role;
            JavaExternalObjectType result;
            Configuration configuration = config;
            synchronized (configuration) {
                result = JavaExternalObjectType.of(this.theClass);
            }
            SequenceType st2 = SequenceType.makeSequenceType(result, 16384);
            ItemType at = this.getArg(0).getItemType();
            if (at instanceof JavaExternalObjectType) {
                role = () -> new RoleDiagnostic(0, this.getFunctionName().getDisplayName(), 0);
                this.setArg(0, tc.staticTypeCheck(this.getArg(0), st2, role, visitor));
                this.argumentConverters[0] = PJConverter.UnwrapExternalObject.INSTANCE;
            } else if (this.theClass.equals(Object.class)) {
                this.argumentConverters[0] = PJConverter.ConditionalUnwrapExternalObject.INSTANCE;
            } else {
                st2 = PJConverter.getEquivalentSequenceType(this.theClass);
                this.argumentConverters[0] = PJConverter.allocate(config, at, this.getArg(0).getCardinality(), this.theClass);
                if (st2 != null) {
                    role = () -> new RoleDiagnostic(0, this.getFunctionName().getDisplayName(), 0);
                    try {
                        this.setArg(0, tc.staticTypeCheck(this.getArg(0), st2, role, visitor));
                    }
                    catch (XPathException err) {
                        if (err.hasErrorCode("XPTY0004") && visitor.getStaticContext().getPackageData().isXSLT()) {
                            err.setErrorCode("XTDE1420");
                        }
                        throw err;
                    }
                }
            }
        }
        int j = firstParam;
        for (int i = firstArg; i < this.getArity(); ++i) {
            st = null;
            if (this.theGenericParameterTypes != null) {
                st = PJConverter.getParameterizedSequenceType(this.theGenericParameterTypes[j]);
            }
            if (st == null) {
                st = this.getArg(i).getItemType() instanceof JavaExternalObjectType && ((JavaExternalObjectType)this.getArg(i).getItemType()).getJavaClass().equals(this.theParameterTypes[j]) ? SequenceType.makeSequenceType(this.getArg(i).getItemType(), this.getArg(i).getCardinality()) : PJConverter.getEquivalentSequenceType(this.theParameterTypes[j]);
            }
            if (st != null) {
                int pos = i;
                Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(0, this.getFunctionName().getDisplayName(), pos);
                try {
                    this.setArg(i, tc.staticTypeCheck(this.getArg(i), (SequenceType)st, role, visitor));
                }
                catch (XPathException err) {
                    if (err.hasErrorCode("XPTY0004") && visitor.getStaticContext().getPackageData().isXSLT()) {
                        err.setErrorCode("XTDE1420");
                    }
                    this.theParameterTypes[j] = Object.class;
                    throw err;
                }
            }
            this.argumentConverters[i] = PJConverter.allocate(config, this.getArg(i).getItemType(), this.getArg(i).getCardinality(), this.theParameterTypes[j]);
            ++j;
        }
        if (this.declaredType == null) {
            Type genericResultType;
            if (this.theMethod instanceof Constructor) {
                JavaExternalObjectType result;
                st = config;
                synchronized (st) {
                    result = JavaExternalObjectType.of(this.theClass);
                }
                JavaExternalObjectType resultType2 = result;
                this.resultConverter = new JPConverter.ExternalObjectWrapper(resultType2);
            } else if (this.theMethod instanceof Method) {
                Class<?> resultClass = ((Method)this.theMethod).getReturnType();
                genericResultType = ((Method)this.theMethod).getGenericReturnType();
                if (genericResultType == Void.TYPE && this.isReturnVoidAsThis()) {
                    JavaExternalObjectType result;
                    Configuration configuration = config;
                    synchronized (configuration) {
                        result = JavaExternalObjectType.of(this.theClass);
                    }
                    this.resultConverter = new JPConverter.ExternalObjectWrapper(result);
                } else {
                    this.resultConverter = JPConverter.allocate(resultClass, genericResultType, config);
                }
            } else if (this.theMethod instanceof Field) {
                Class<?> resultClass = ((Field)this.theMethod).getType();
                genericResultType = ((Field)this.theMethod).getGenericType();
                this.resultConverter = JPConverter.allocate(resultClass, genericResultType, config);
            } else {
                throw new AssertionError((Object)"Unknown component type");
            }
        }
        this.checkForNodes = (resultType = this.resultConverter.getItemType()) == AnyItemType.getInstance() || resultType instanceof NodeTest;
        this.resetLocalStaticProperties();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForDynamicCall(Configuration config) throws XPathException {
        Class<?> resultClass;
        this.argumentConverters = new PJConverter[this.getArity()];
        int firstParam = 0;
        int firstArg = 0;
        if (this.theMethod instanceof Method) {
            boolean isStatic;
            if (this.theParameterTypes == null) {
                this.theParameterTypes = ((Method)this.theMethod).getParameterTypes();
            }
            if (this.theGenericParameterTypes == null) {
                this.theGenericParameterTypes = ((Method)this.theMethod).getGenericParameterTypes();
            }
            firstArg = (isStatic = Modifier.isStatic(((Method)this.theMethod).getModifiers())) ? 0 : 1;
            boolean usesContext = this.theParameterTypes.length > 0 && this.theParameterTypes[0] == XPathContext.class;
            int n = firstParam = usesContext ? 1 : 0;
        }
        if (firstArg != 0) {
            this.argumentConverters[0] = PJConverter.UnwrapExternalObject.INSTANCE;
        }
        int j = firstParam;
        for (int i = firstArg; i < this.getArity(); ++i) {
            this.argumentConverters[i] = PJConverter.allocate(config, AnyItemType.getInstance(), 32768, this.theParameterTypes[j]);
            ++j;
        }
        if (this.theMethod instanceof Constructor) {
            JavaExternalObjectType result;
            Configuration configuration = config;
            synchronized (configuration) {
                result = JavaExternalObjectType.of(this.theClass);
            }
            JavaExternalObjectType resultType = result;
            this.resultConverter = new JPConverter.ExternalObjectWrapper(resultType);
        } else if (this.theMethod instanceof Method) {
            resultClass = ((Method)this.theMethod).getReturnType();
            Type resultType = ((Method)this.theMethod).getGenericReturnType();
            if (resultType == Void.TYPE && this.isReturnVoidAsThis()) {
                JavaExternalObjectType result;
                Configuration configuration = config;
                synchronized (configuration) {
                    result = JavaExternalObjectType.of(this.theClass);
                }
                this.resultConverter = new JPConverter.ExternalObjectWrapper(result);
            } else {
                this.resultConverter = JPConverter.allocate(resultClass, resultType, config);
            }
        } else if (this.theMethod instanceof Field) {
            resultClass = ((Field)this.theMethod).getType();
            Type resultType = ((Field)this.theMethod).getGenericType();
            this.resultConverter = JPConverter.allocate(resultClass, resultType, config);
        } else {
            throw new AssertionError((Object)"Unknown component type");
        }
        ItemType resultType = this.resultConverter.getItemType();
        this.checkForNodes = resultType == AnyItemType.getInstance() || resultType instanceof NodeTest;
    }

    @Override
    public boolean adjustRequiredType(JavaExternalObjectType requiredType) throws XPathException {
        Class<?> unconvertedResult = this.getReturnClass();
        if (requiredType.getJavaClass().isAssignableFrom(unconvertedResult)) {
            this.resultConverter = new JPConverter.ExternalObjectWrapper(requiredType);
        } else if (unconvertedResult.isAssignableFrom(requiredType.getJavaClass())) {
            this.resultConverter = new JPConverter.ExternalObjectWrapper(requiredType);
        } else {
            throw new XPathException("Cannot convert result of extension function to required type " + requiredType, "XPTY0004", this.getLocation());
        }
        this.declaredType = requiredType;
        return true;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        JavaExtensionFunctionCall j = new JavaExtensionFunctionCall();
        j.name = this.getFunctionName();
        j.returnVoidAsThis = this.returnVoidAsThis;
        Expression[] newArgs = new Expression[this.getArity()];
        int i = 0;
        for (Operand o : this.operands()) {
            newArgs[i++] = o.getChildExpression().copy(rebindings);
        }
        j.setArguments(newArgs);
        j.theMethod = this.theMethod;
        j.theParameterTypes = this.theParameterTypes;
        j.theGenericParameterTypes = this.theGenericParameterTypes;
        j.argumentConverters = this.argumentConverters;
        j.resultConverter = this.resultConverter;
        j.checkForNodes = this.checkForNodes;
        j.theClass = this.theClass;
        ExpressionTool.copyLocationInfo(this, j);
        return j;
    }

    @Override
    public int getIntrinsicDependencies() {
        Class<?>[] theParameterTypes;
        int depend = 0x2000000;
        if (this.theMethod instanceof Method && (theParameterTypes = ((Method)this.theMethod).getParameterTypes()).length > 0 && theParameterTypes[0] == XPathContext.class) {
            depend |= 0xE;
        }
        return depend;
    }

    @Override
    public boolean isSubtreeExpression() {
        return false;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addExternalFunctionCallToPathMap(pathMap, pathMapNodeSet);
    }

    public boolean isNodeCheckRequired() {
        return this.checkForNodes;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.iterate(context).next();
    }

    public Class<?> getTargetClass() {
        return this.theClass;
    }

    public AccessibleObject getTargetMethod() {
        return this.theMethod;
    }

    public Class<?>[] getParameterTypes() {
        return this.theParameterTypes;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] argValues) throws XPathException {
        if (this.theMethod instanceof Constructor) {
            Constructor constructor = (Constructor)this.theMethod;
            if (this.theParameterTypes == null) {
                this.theParameterTypes = constructor.getParameterTypes();
            }
            Object[] params = new Object[this.theParameterTypes.length];
            this.setupParams(argValues, params, this.theParameterTypes, 0, 0, context);
            try {
                Object result = this.invokeConstructor(constructor, params);
                return this.asSequence(result, context);
            }
            catch (InstantiationException err0) {
                throw new XPathException("Cannot instantiate class", err0);
            }
            catch (IllegalAccessException err1) {
                throw new XPathException("Constructor access is illegal", err1);
            }
            catch (IllegalArgumentException err2) {
                throw new XPathException("Argument is of wrong type", err2);
            }
            catch (NullPointerException err2) {
                throw new XPathException("Object is null");
            }
            catch (InvocationTargetException err3) {
                Throwable ex = err3.getTargetException();
                if (ex instanceof XPathException) {
                    throw ((XPathException)ex).maybeWithLocation(this.getLocation());
                }
                if (context.getController().isTracing() || context.getConfiguration().getBooleanProperty(Feature.TRACE_EXTERNAL_FUNCTIONS)) {
                    err3.getTargetException().printStackTrace();
                }
                XPathException xe = new XPathException("Exception thrown by extension function {" + this.theMethod + "}: " + err3.getTargetException(), ex).withLocation(this.getLocation()).withErrorCode(JavaExternalObjectType.classNameToQName(ex.getClass().getName()));
                xe.setErrorObject(new ObjectValue(this.theClass));
                throw xe;
            }
        }
        if (this.theMethod instanceof Method) {
            Class<?> theInstance;
            boolean usesContext;
            Method method = (Method)this.theMethod;
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            if (this.theParameterTypes == null) {
                this.theParameterTypes = method.getParameterTypes();
            }
            boolean bl = usesContext = this.theParameterTypes.length > 0 && this.theParameterTypes[0] == XPathContext.class;
            if (isStatic) {
                theInstance = null;
            } else {
                if (argValues.length == 0) {
                    throw new XPathException("Must supply an argument for a non-static extension function", "SXJE0001", this.getLocation());
                }
                try {
                    argValues[0] = argValues[0].materialize();
                    theInstance = this.getTargetInstance(argValues[0], context);
                    if (theInstance == null) {
                        throw new XPathException("First argument to instance method must not be an empty sequence", "SXJE0001", this.getLocation());
                    }
                }
                catch (XPathException err) {
                    throw err.maybeWithLocation(this.getLocation());
                }
            }
            Object[] params = new Object[this.theParameterTypes.length];
            if (usesContext) {
                params[0] = context;
            }
            this.setupParams(argValues, params, this.theParameterTypes, usesContext ? 1 : 0, isStatic ? 0 : 1, context);
            try {
                Object result = this.invokeMethod(method, theInstance, params);
                if (method.getReturnType() == Void.TYPE) {
                    if (this.returnVoidAsThis) {
                        return argValues[0];
                    }
                    return EmptySequence.getInstance();
                }
                return this.asSequence(result, context);
            }
            catch (XPathException xpe) {
                xpe.maybeSetLocation(this.getLocation());
                throw xpe;
            }
            catch (IllegalAccessException err1) {
                throw new XPathException("Method access is illegal", err1).withLocation(this.getLocation());
            }
            catch (IllegalArgumentException err2) {
                throw new XPathException("Argument is of wrong type", err2).withLocation(this.getLocation());
            }
            catch (NullPointerException err2) {
                err2.printStackTrace();
                throw new XPathException("Object is null", err2).withLocation(this.getLocation());
            }
            catch (InvocationTargetException err3) {
                Throwable ex = err3.getTargetException();
                if (ex instanceof XPathException) {
                    throw ((XPathException)ex).maybeWithLocation(this.getLocation());
                }
                if (context.getController().isTracing() || context.getConfiguration().getBooleanProperty(Feature.TRACE_EXTERNAL_FUNCTIONS)) {
                    err3.getTargetException().printStackTrace();
                }
                XPathException xe = new XPathException("Exception thrown by extension function {" + this.theMethod + "}: " + err3.getTargetException(), ex);
                xe.setErrorCodeQName(JavaExternalObjectType.classNameToQName(ex.getClass().getName()));
                Class<?> value = isStatic ? this.theClass : theInstance;
                xe.setErrorObject(new ObjectValue(value));
                throw xe.withLocation(this.getLocation());
            }
        }
        if (this.theMethod instanceof Field) {
            Object theInstance;
            Field field = (Field)this.theMethod;
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            if (isStatic) {
                theInstance = null;
            } else {
                if (argValues.length == 0) {
                    throw new XPathException("Must supply an argument for a non-static extension function");
                }
                try {
                    theInstance = this.getTargetInstance(argValues[0], context);
                }
                catch (XPathException err) {
                    throw err.maybeWithLocation(this.getLocation());
                }
            }
            try {
                Object result = this.getField(field, theInstance);
                return this.asSequence(result, context);
            }
            catch (IllegalAccessException err1) {
                throw new XPathException("Field access is illegal", err1);
            }
            catch (IllegalArgumentException err2) {
                throw new XPathException("Argument is of wrong type", err2);
            }
        }
        throw new AssertionError((Object)("property " + this.theMethod + " is neither constructor, method, nor field"));
    }

    private Object getTargetInstance(Sequence arg0, XPathContext context) throws XPathException {
        PJConverter converter = this.argumentConverters[0];
        return converter.convert(arg0, this.theClass, context);
    }

    private Sequence asSequence(Object result, XPathContext context) throws XPathException {
        SequenceIterator resultIterator;
        if (result == null) {
            return EmptySequence.getInstance();
        }
        if (result instanceof SequenceIterator) {
            resultIterator = (SequenceIterator)result;
        } else {
            GroundedValue resultSeq = this.resultConverter.convert(result, context);
            if (!this.checkForNodes) {
                return resultSeq;
            }
            resultIterator = resultSeq.iterate();
        }
        if (this.checkForNodes) {
            return SequenceTool.toLazySequence(new ItemMappingIterator(resultIterator, new IntegratedFunctionCall.ConfigurationCheckingFunction(context.getConfiguration()), true));
        }
        return SequenceTool.toLazySequence(resultIterator);
    }

    private void setupParams(Sequence[] argValues, Object[] params, Class<?>[] paramTypes, int firstParam, int firstArg, XPathContext context) throws XPathException {
        int j = firstParam;
        try {
            for (int i = firstArg; i < argValues.length; ++i) {
                params[j] = this.argumentConverters[i].convert(argValues[i], paramTypes[j], context);
                ++j;
            }
        }
        catch (XPathException e) {
            throw e.withErrorCode("XPTY0004").maybeWithLocation(this.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemType getItemType() {
        if (this.resultConverter == null) {
            return AnyItemType.getInstance();
        }
        if (this.resultConverter instanceof JPConverter.VoidConverter) {
            if (this.returnVoidAsThis) {
                Configuration configuration = this.config;
                synchronized (configuration) {
                    return JavaExternalObjectType.of(this.theClass);
                }
            }
            return AnyItemType.getInstance();
        }
        return this.resultConverter.getItemType();
    }

    @Override
    protected int computeCardinality() {
        Class<?> resultClass = this.getReturnClass();
        if (resultClass.equals(Void.TYPE)) {
            return 24576;
        }
        if (this.resultConverter == null) {
            return 57344;
        }
        return this.resultConverter.getCardinality() | 0x2000;
    }

    public Class<?> getReturnClass() {
        if (this.theMethod instanceof Method) {
            Class<?> returnClass = ((Method)this.theMethod).getReturnType();
            if (returnClass == Void.TYPE && this.returnVoidAsThis) {
                return this.theClass;
            }
            return returnClass;
        }
        if (this.theMethod instanceof Field) {
            return ((Field)this.theMethod).getType();
        }
        if (this.theMethod instanceof Constructor) {
            return this.theClass;
        }
        return null;
    }

    public PJConverter[] getArgumentConverters() {
        return this.argumentConverters;
    }

    public JPConverter getResultConverter() {
        return this.resultConverter;
    }

    protected Object invokeConstructor(Constructor<?> constructor, Object[] params) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return constructor.newInstance(params);
    }

    protected Object invokeMethod(Method method, Object instance, Object[] params) throws IllegalAccessException, InvocationTargetException {
        return method.invoke(instance, params);
    }

    protected Object getField(Field field, Object instance) throws IllegalAccessException {
        return field.get(instance);
    }

    public static Sequence applyFunctionConversionRules(Sequence suppliedValue, SequenceType requiredType, StructuredQName functionName, int argPosition, XPathContext context) throws XPathException {
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(0, functionName.getDisplayName(), argPosition);
        return th.applyFunctionConversionRules(suppliedValue.materialize(), requiredType, role, Loc.NONE);
    }

    public static String toCamelCase(String name, boolean debug, Logger diag) {
        if (name.indexOf(45) >= 0) {
            StringBuilder buff = new StringBuilder(name.length());
            boolean afterHyphen = false;
            for (int n = 0; n < name.length(); ++n) {
                char c = name.charAt(n);
                if (c == '-') {
                    afterHyphen = true;
                    continue;
                }
                if (afterHyphen) {
                    buff.append(Character.toUpperCase(c));
                } else {
                    buff.append(c);
                }
                afterHyphen = false;
            }
            name = buff.toString();
            if (debug) {
                diag.info("Seeking a method with adjusted name " + name);
            }
        }
        return name;
    }

    public boolean isReturnVoidAsThis() {
        return this.returnVoidAsThis;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("javaCall", this);
        out.emitAttribute("name", this.getFunctionName());
        if (this.declaredType != null) {
            out.emitAttribute("declType", this.declaredType.toExportString());
        }
        int i = 0;
        for (Operand o : this.operands()) {
            Expression child = o.getChildExpression();
            SequenceType st = SequenceType.makeSequenceType(child.getItemType(), child.getCardinality());
            out.emitAttribute("arg" + i++ + "type", st.toAlphaCode());
        }
        for (Operand o : this.operands()) {
            o.getChildExpression().export(out);
        }
        out.endElement();
    }

    protected void allocateArgumentEvaluators() {
        int arity = this.getArity();
        this.argumentEvaluators = new SequenceEvaluator[arity];
        for (int i = 0; i < arity; ++i) {
            this.argumentEvaluators[i] = this.getArg(i).makeElaborator().eagerly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence[] evaluateArguments(XPathContext c) throws XPathException {
        int numArgs = this.getArity();
        Sequence[] actualArgs = SequenceTool.makeSequenceArray(numArgs);
        JavaExtensionFunctionCall javaExtensionFunctionCall = this;
        synchronized (javaExtensionFunctionCall) {
            if (this.argumentEvaluators == null) {
                this.allocateArgumentEvaluators();
            }
        }
        for (int i = 0; i < numArgs; ++i) {
            actualArgs[i] = this.argumentEvaluators[i].evaluate(c);
        }
        return actualArgs;
    }

    @Override
    public Elaborator getElaborator() {
        return new JavaExtensionFunctionCallElaborator();
    }

    private static class JavaExtensionFunctionCallElaborator
    extends PullElaborator {
        private JavaExtensionFunctionCallElaborator() {
        }

        @Override
        public PullEvaluator elaborateForPull() {
            JavaExtensionFunctionCall expr = (JavaExtensionFunctionCall)this.getExpression();
            expr.allocateArgumentEvaluators();
            return context -> {
                Sequence[] actualArgs = expr.evaluateArguments(context);
                return expr.call(context, actualArgs).iterate();
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            JavaExtensionFunctionCall expr = (JavaExtensionFunctionCall)this.getExpression();
            expr.allocateArgumentEvaluators();
            return context -> {
                Sequence[] actualArgs = expr.evaluateArguments(context);
                return expr.call(context, actualArgs).head();
            };
        }
    }
}

