/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.functions.extfn.AnalyzeUri;
import com.saxonica.functions.extfn.CharactersFn;
import com.saxonica.functions.extfn.CompileQuery;
import com.saxonica.functions.extfn.CompileStylesheet;
import com.saxonica.functions.extfn.DecimalDivide;
import com.saxonica.functions.extfn.EQName;
import com.saxonica.functions.extfn.EscapeNCName;
import com.saxonica.functions.extfn.Eval;
import com.saxonica.functions.extfn.Evaluate;
import com.saxonica.functions.extfn.ExpressionFn;
import com.saxonica.functions.extfn.FunctionAnnotations;
import com.saxonica.functions.extfn.GroupStarting;
import com.saxonica.functions.extfn.HighestOrLowest;
import com.saxonica.functions.extfn.Index;
import com.saxonica.functions.extfn.KeyMap;
import com.saxonica.functions.extfn.LastModified;
import com.saxonica.functions.extfn.Leading;
import com.saxonica.functions.extfn.MapSearch;
import com.saxonica.functions.extfn.MessageCount;
import com.saxonica.functions.extfn.NewAttribute;
import com.saxonica.functions.extfn.NewComment;
import com.saxonica.functions.extfn.NewDocument;
import com.saxonica.functions.extfn.NewElement;
import com.saxonica.functions.extfn.NewNamespace;
import com.saxonica.functions.extfn.NewProcessingInstruction;
import com.saxonica.functions.extfn.NewText;
import com.saxonica.functions.extfn.ObjectMap;
import com.saxonica.functions.extfn.Parse;
import com.saxonica.functions.extfn.ParseXPath;
import com.saxonica.functions.extfn.PedigreeFn;
import com.saxonica.functions.extfn.QueryFn;
import com.saxonica.functions.extfn.ReadBinaryResource;
import com.saxonica.functions.extfn.ReplaceWith;
import com.saxonica.functions.extfn.SaxonDeepEqual;
import com.saxonica.functions.extfn.SaxonSlice;
import com.saxonica.functions.extfn.SendMail;
import com.saxonica.functions.extfn.Serialize;
import com.saxonica.functions.extfn.TimestampFn;
import com.saxonica.functions.extfn.TransformFn;
import com.saxonica.functions.extfn.UnescapeNCName;
import com.saxonica.functions.extfn.Unindexed;
import com.saxonica.functions.extfn.WithPedigree;
import com.saxonica.functions.extfn.XQueryFn;
import com.saxonica.functions.qt4.InScopeNamespacesFn;
import com.saxonica.functions.qt4.IndexWhere;
import com.saxonica.functions.qt4.IsNaN;
import com.saxonica.functions.qt4.ItemsEnding;
import com.saxonica.functions.qt4.ItemsStarting;
import com.saxonica.functions.qt4.ParcelFn;
import com.saxonica.functions.qt4.ParseHtml;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.number.NamedTimeZone;
import net.sf.saxon.functions.ContextItemAccessorFunction;
import net.sf.saxon.functions.Doc_2;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.functions.registry.VendorFunctionSetHE;
import net.sf.saxon.lib.StandardDiagnostics;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.ma.Parcel;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.RecordTest;
import net.sf.saxon.om.DocumentKey;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.tiny.TinyAttributeImpl;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.tree.util.ProcInstParser;
import net.sf.saxon.type.AnyExternalObjectType;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.LocalUnionType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AnyExternalObject;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.z.IntPredicateProxy;

public class VendorFunctionSetPE
extends BuiltInFunctionSet {
    private static final VendorFunctionSetPE INSTANCE = new VendorFunctionSetPE();
    private static final List<String> analyzeUriKeys = Arrays.asList("isValid", "isAbsolute", "isOpaque", "port", "queryParams", "authority", "rawAuthority", "userInfo", "rawUserInfo", "scheme", "host", "schemeSpecificPart", "rawSchemeSpecificPart", "path", "rawPath", "query", "rawQuery", "fragment", "rawFragment", "asciiString", "error");
    private static final List<SequenceType> analyzeUriValues = Arrays.asList(SequenceType.SINGLE_BOOLEAN, SequenceType.SINGLE_BOOLEAN, SequenceType.SINGLE_BOOLEAN, SequenceType.OPTIONAL_INTEGER, SequenceType.makeSequenceType(new MapType(BuiltInAtomicType.STRING, SequenceType.SINGLE_STRING), 24576), SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING);
    private static final RecordTest analyzeUriResult = new RecordTest(analyzeUriKeys, analyzeUriValues, new ArrayList<String>(), false);
    private static final SpecificFunctionType predicate = new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_ITEM}, SequenceType.SINGLE_BOOLEAN);

    public static VendorFunctionSetPE getInstance() {
        return INSTANCE;
    }

    public VendorFunctionSetPE() {
        this.init();
    }

    private void init() {
        this.importFunctionSet(VendorFunctionSetHE.getInstance());
        SpecificFunctionType orderKey = new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_ITEM}, SequenceType.OPTIONAL_ATOMIC);
        this.register("adjust-to-civil-time", 2, e -> e.populate(AdjustToCivilTime::new, BuiltInAtomicType.DATE_TIME, 24576, 512).arg(0, BuiltInAtomicType.DATE_TIME, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("analyze-uri", 1, e -> e.populate(AnalyzeUri::new, analyzeUriResult, 16384, 0).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("array-member", 1, e -> e.populate(ParcelFn::new, Parcel.TYPE, 16384, 0).arg(0, AnyItemType.getInstance(), 57344, null));
        this.register("base64Binary-to-octets", 1, e -> e.populate(Base64BinaryToOctets::new, BuiltInAtomicType.INTEGER, 57344, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 16384, null));
        this.register("base64Binary-to-string", 2, e -> e.populate(Base64BinaryToString::new, BuiltInAtomicType.STRING, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EMPTY).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("characters", 1, e -> e.populate(CharactersFn::new, BuiltInAtomicType.STRING, 57344, 0).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("column-number", 0, e -> e.populate(ContextItemAccessorFunction::new, BuiltInAtomicType.INTEGER, 16384, 516));
        this.register("column-number", 1, e -> e.populate(ColumnNumber::new, BuiltInAtomicType.INTEGER, 24576, 0).arg(0, AnyNodeTest.getInstance(), 24576, EMPTY));
        this.register("compile-query", 1, e -> e.populate(CompileQuery::new, JavaExternalObjectType.of(XQueryExpression.class), 16384, 0).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("compile-stylesheet", 1, e -> e.populate(CompileStylesheet::new, JavaExternalObjectType.of(PreparedStylesheet.class), 16384, 0).arg(0, NodeKindTest.DOCUMENT, 16384, null));
        this.register("configuration", 0, e -> e.populate(ConfigurationFn::new, JavaExternalObjectType.of(Configuration.class), 16384, 512));
        this.register("context", 0, e -> e.populate(ContextFn::new, JavaExternalObjectType.of(XPathContext.class), 16384, 516));
        this.register("controller", 0, e -> e.populate(ControllerFn::new, JavaExternalObjectType.of(Controller.class), 16384, 512));
        this.register("current-mode-name", 0, e -> e.populate(CurrentModeName::new, BuiltInAtomicType.QNAME, 24576, 516));
        this.register("deep-equal", 4, e -> e.populate(SaxonDeepEqual::new, BuiltInAtomicType.BOOLEAN, 16384, 0).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, AnyItemType.getInstance(), 57344, null).arg(2, BuiltInAtomicType.STRING, 24576, null).arg(3, BuiltInAtomicType.STRING, 16384, null));
        this.register("decimal-divide", 3, e -> e.populate(DecimalDivide::new, BuiltInAtomicType.DECIMAL, 24576, 0).arg(0, BuiltInAtomicType.DECIMAL, 24576, EMPTY).arg(1, BuiltInAtomicType.DECIMAL, 24576, EMPTY).arg(2, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("discard-document", 1, e -> e.populate(DiscardDocument::new, NodeKindTest.DOCUMENT, 24576, 0).arg(0, NodeKindTest.DOCUMENT, 24576, null));
        this.register("EQName", 1, e -> e.populate(EQName::new, BuiltInAtomicType.QNAME, 24576, 0).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY));
        this.register("escape-NCName", 1, e -> e.populate(EscapeNCName::new, BuiltInAtomicType.NCNAME, 16384, 0).arg(0, BuiltInAtomicType.STRING, 16384, EMPTY));
        this.register("eval", 1, 10, e -> e.populate(Eval::new, AnyItemType.getInstance(), 57344, 4).arg(0, JavaExternalObjectType.of(Evaluate.PreparedExpression.class), 16384, null).arg(1, AnyItemType.getInstance(), 57344, null).arg(2, AnyItemType.getInstance(), 57344, null).arg(3, AnyItemType.getInstance(), 57344, null).arg(4, AnyItemType.getInstance(), 57344, null).arg(5, AnyItemType.getInstance(), 57344, null).arg(6, AnyItemType.getInstance(), 57344, null).arg(7, AnyItemType.getInstance(), 57344, null).arg(8, AnyItemType.getInstance(), 57344, null).arg(9, AnyItemType.getInstance(), 57344, null));
        this.register("evaluate", 1, 10, e -> e.populate(Evaluate::new, AnyItemType.getInstance(), 57344, 4).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, AnyItemType.getInstance(), 57344, null).arg(2, AnyItemType.getInstance(), 57344, null).arg(3, AnyItemType.getInstance(), 57344, null).arg(4, AnyItemType.getInstance(), 57344, null).arg(5, AnyItemType.getInstance(), 57344, null).arg(6, AnyItemType.getInstance(), 57344, null).arg(7, AnyItemType.getInstance(), 57344, null).arg(8, AnyItemType.getInstance(), 57344, null).arg(9, AnyItemType.getInstance(), 57344, null));
        this.register("expression", 1, e -> e.populate(ExpressionFn::new, JavaExternalObjectType.of(Evaluate.PreparedExpression.class), 16384, 0).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("expression", 2, e -> e.populate(ExpressionFn::new, JavaExternalObjectType.of(Evaluate.PreparedExpression.class), 16384, 0).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, NodeKindTest.ELEMENT, 16384, null));
        this.register("function-annotations", 1, e -> e.populate(FunctionAnnotations::new, FunctionAnnotations.RETURN_TYPE, 57344, 0).arg(0, AnyFunctionType.getInstance(), 16384, null));
        this.register("get-context", 0, e -> e.populate(GetContext::new, JavaExternalObjectType.of(XPathContext.class), 16384, 516));
        this.register("get-pseudo-attribute", 1, e -> e.populate(GetPseudoAttribute::new, BuiltInAtomicType.STRING, 24576, 516).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY));
        this.register("group-starting", 2, e -> e.populate(GroupStarting::new, ArrayItemType.ANY_ARRAY_TYPE, 57344, 0).arg(0, AnyItemType.getInstance(), 57344, EMPTY).arg(1, predicate, 16384, EMPTY));
        this.register("has-same-nodes", 2, e -> e.populate(HasSameNodes::new, BuiltInAtomicType.BOOLEAN, 16384, 0).arg(0, AnyNodeTest.getInstance(), 57344, null).arg(1, AnyNodeTest.getInstance(), 57344, null));
        this.register("hexBinary-to-octets", 1, e -> e.populate(HexBinaryToOctets::new, BuiltInAtomicType.INTEGER, 57344, 0).arg(0, BuiltInAtomicType.HEX_BINARY, 16384, null));
        this.register("hexBinary-to-string", 2, e -> e.populate(HexBinaryToString::new, BuiltInAtomicType.STRING, 24576, 0).arg(0, BuiltInAtomicType.HEX_BINARY, 24576, EMPTY).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("highest", 1, e -> e.populate(HighestOrLowest::new, AnyItemType.getInstance(), 57344, 0).arg(0, AnyItemType.getInstance(), 57344, EMPTY));
        this.register("highest", 2, e -> e.populate(HighestOrLowest::new, AnyItemType.getInstance(), 57344, 0).arg(0, AnyItemType.getInstance(), 57344, EMPTY).arg(1, orderKey, 16384, null));
        this.register("index", 2, e -> e.populate(Index::new, MapType.getInstance(), 16384, 0).arg(0, AnyItemType.getInstance(), 57344, EMPTY).arg(1, AnyItemType.getInstance(), 16384, EMPTY));
        this.register("index-where", 2, e -> e.populate(IndexWhere::new, BuiltInAtomicType.INTEGER, 57344, 0).arg(0, AnyItemType.getInstance(), 57344, EMPTY).arg(1, predicate, 16384, EMPTY));
        this.register("in-scope-namespaces", 1, e -> e.populate(InScopeNamespacesFn::new, MapType.getInstance(), 16384, 0).arg(0, NodeKindTest.ELEMENT, 0x1004000, null));
        this.register("in-summer-time", 2, e -> e.populate(InSummerTime::new, BuiltInAtomicType.DATE_TIME, 24576, 512).arg(0, BuiltInAtomicType.DATE_TIME, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("is-defaulted", 1, e -> e.populate(IsDefaulted::new, BuiltInAtomicType.BOOLEAN, 16384, 0).arg(0, AnyNodeTest.getInstance(), 16384, null));
        this.register("is-NaN", 1, e -> e.populate(IsNaN::new, BuiltInAtomicType.BOOLEAN, 16384, 0).arg(0, BuiltInAtomicType.ANY_ATOMIC, 16384, null));
        this.register("items-after", 2, e -> e.populate(ItemsStarting.ItemsAfter::new, AnyItemType.getInstance(), 57344, 0).arg(0, AnyItemType.getInstance(), 0x400E000, EMPTY).arg(1, predicate, 16384, EMPTY));
        this.register("items-from", 2, e -> e.populate(ItemsStarting.ItemsFrom::new, AnyItemType.getInstance(), 57344, 0).arg(0, AnyItemType.getInstance(), 0x400E000, EMPTY).arg(1, predicate, 16384, EMPTY));
        this.register("items-before", 2, e -> e.populate(ItemsEnding.ItemsBefore::new, AnyItemType.getInstance(), 57344, 0).arg(0, AnyItemType.getInstance(), 0x400E000, EMPTY).arg(1, predicate, 16384, EMPTY));
        this.register("items-until", 2, e -> e.populate(ItemsEnding.ItemsUntil::new, AnyItemType.getInstance(), 57344, 0).arg(0, AnyItemType.getInstance(), 0x400E000, EMPTY).arg(1, predicate, 16384, EMPTY));
        this.register("key-map", 4, e -> e.populate(KeyMap::new, new MapType(BuiltInAtomicType.STRING, SequenceType.NODE_SEQUENCE), 16384, 0).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, AnyNodeTest.getInstance(), 16384, null).arg(2, BuiltInAtomicType.STRING, 24576, null).arg(3, BuiltInAtomicType.STRING, 24576, null));
        this.register("last-modified", 1, e -> e.populate(LastModified::new, BuiltInAtomicType.DATE_TIME, 24576, 8).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY));
        this.register("leading", 1, e -> e.populate(Leading::new, AnyItemType.getInstance(), 57344, 0).arg(0, AnyItemType.getInstance(), 57344, EMPTY));
        this.register("leading", 2, e -> e.populate(Leading::new, AnyItemType.getInstance(), 57344, 0).arg(0, AnyItemType.getInstance(), 57344, EMPTY).arg(1, predicate, 16384, null));
        this.register("line-number", 0, e -> e.populate(ContextItemAccessorFunction::new, BuiltInAtomicType.INTEGER, 16384, 516));
        this.register("line-number", 1, e -> e.populate(LineNumber::new, BuiltInAtomicType.INTEGER, 24576, 0).arg(0, AnyNodeTest.getInstance(), 24576, EMPTY));
        this.register("lowest", 1, e -> e.populate(HighestOrLowest::new, AnyItemType.getInstance(), 57344, 0).arg(0, AnyItemType.getInstance(), 57344, EMPTY));
        this.register("lowest", 2, e -> e.populate(HighestOrLowest::new, AnyItemType.getInstance(), 57344, 0).arg(0, AnyItemType.getInstance(), 57344, EMPTY).arg(1, orderKey, 16384, null));
        SpecificFunctionType tester = new SpecificFunctionType(new SequenceType[]{SequenceType.ANY_SEQUENCE}, SequenceType.SINGLE_BOOLEAN);
        this.register("map-search", 2, e -> e.populate(MapSearch::new, MapType.ANY_MAP_TYPE, 57344, 0).arg(0, AnyItemType.getInstance(), 0x100E000, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 0x2004000, null));
        this.register("map-search", 3, e -> e.populate(MapSearch::new, MapType.ANY_MAP_TYPE, 57344, 0).arg(0, AnyItemType.getInstance(), 0x100E000, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 0x2004000, null).arg(2, tester, 0x1004000, null));
        this.register("message-count", 1, e -> e.populate(MessageCount::new, BuiltInAtomicType.INTEGER, 16384, 8704).arg(0, BuiltInAtomicType.QNAME, 24576, null));
        this.register("namespace-node", 2, e -> e.populate(NamespaceNodeFn::new, NodeKindTest.NAMESPACE, 16384, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        LocalUnionType stringOrQName = new LocalUnionType(BuiltInAtomicType.STRING, BuiltInAtomicType.QNAME);
        this.register("new-attribute", 2, e -> e.populate(NewAttribute::new, NodeKindTest.ATTRIBUTE, 16384, 74240).arg(0, stringOrQName, 16384, null).arg(1, BuiltInAtomicType.STRING, 24576, null));
        this.register("new-comment", 1, e -> e.populate(NewComment::new, NodeKindTest.COMMENT, 16384, 74240).arg(0, BuiltInAtomicType.STRING, 24576, null));
        this.register("new-document", 1, e -> e.populate(NewDocument::new, NodeKindTest.DOCUMENT, 16384, 74240).arg(0, AnyItemType.getInstance(), 57344, null));
        this.register("new-element", 2, e -> e.populate(NewElement::new, NodeKindTest.ELEMENT, 16384, 74240).arg(0, stringOrQName, 16384, null).arg(1, AnyItemType.getInstance(), 57344, null));
        this.register("new-namespace", 2, e -> e.populate(NewNamespace::new, NodeKindTest.NAMESPACE, 16384, 74240).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("new-processing-instruction", 2, e -> e.populate(NewProcessingInstruction::new, NodeKindTest.PROCESSING_INSTRUCTION, 16384, 74240).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 57344, null));
        this.register("new-text", 1, e -> e.populate(NewText::new, NodeKindTest.TEXT, 16384, 74240).arg(0, BuiltInAtomicType.STRING, 24576, null));
        this.register("object-map", 1, e -> e.populate(ObjectMap::new, new MapType(BuiltInAtomicType.STRING, SequenceType.ANY_SEQUENCE), 16384, 0).arg(0, AnyExternalObjectType.THE_INSTANCE, 16384, null));
        this.register("octets-to-base64Binary", 1, e -> e.populate(OctetsToBase64Binary::new, BuiltInAtomicType.BASE64_BINARY, 16384, 0).arg(0, BuiltInAtomicType.INTEGER, 57344, null));
        this.register("octets-to-hexBinary", 1, e -> e.populate(OctetsToHexBinary::new, BuiltInAtomicType.HEX_BINARY, 16384, 0).arg(0, BuiltInAtomicType.INTEGER, 57344, null));
        this.register("parse", 1, e -> e.populate(Parse::new, NodeKindTest.DOCUMENT, 16384, 66048).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY));
        this.register("parse", 2, e -> e.populate(Parse::new, NodeKindTest.DOCUMENT, 16384, 66048).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY).arg(1, MapType.ANY_MAP_TYPE, 16384, EMPTY).setOptionDetails(Doc_2.makeOptionsParameter()));
        this.register("parse-dateTime", 2, e -> e.populate(ParseDateTime::new, BuiltInAtomicType.ANY_ATOMIC, 16384, 0).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY).arg(1, BuiltInAtomicType.STRING, 16384, EMPTY));
        this.register("parse-html", 1, e -> e.populate(ParseHtml::new, NodeKindTest.DOCUMENT, 16384, 66048).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY));
        this.register("parse-html", 2, e -> e.populate(ParseHtml::new, NodeKindTest.DOCUMENT, 16384, 66048).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY).arg(1, MapType.ANY_MAP_TYPE, 16384, EMPTY).setOptionDetails(Doc_2.makeOptionsParameter()));
        this.register("parse-XPath", 3, e -> e.populate(ParseXPath::new, NodeKindTest.DOCUMENT, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, EMPTY).arg(1, BuiltInAtomicType.STRING, 24576, null).arg(2, AnyItemType.getInstance(), 24576, null));
        this.register("pedigree", 1, e -> e.populate(PedigreeFn::new, MapType.getInstance(), 24576, 0).arg(0, AnyFunctionType.getInstance(), 16384, null));
        this.register("print-stack", 0, e -> e.populate(PrintStack::new, BuiltInAtomicType.STRING, 16384, 516));
        this.register("query", 1, e -> e.populate(QueryFn::new, AnyItemType.getInstance(), 57344, 516).arg(0, JavaExternalObjectType.of(XQueryExpression.class), 24576, EMPTY));
        this.register("query", 2, e -> e.populate(QueryFn::new, AnyItemType.getInstance(), 57344, 512).arg(0, JavaExternalObjectType.of(XQueryExpression.class), 24576, EMPTY).arg(1, AnyItemType.getInstance(), 16384, null));
        this.register("query", 3, e -> e.populate(QueryFn::new, AnyItemType.getInstance(), 57344, 512).arg(0, JavaExternalObjectType.of(XQueryExpression.class), 24576, EMPTY).arg(1, AnyItemType.getInstance(), 16384, null).arg(2, AnyNodeTest.getInstance(), 57344, null));
        this.register("read-binary-resource", 1, e -> e.populate(ReadBinaryResource::new, BuiltInAtomicType.BASE64_BINARY, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        SpecificFunctionType stringReplacer = new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_STRING}, SequenceType.SINGLE_STRING);
        this.register("replace-with", 3, e -> e.populate(ReplaceWith::new, BuiltInAtomicType.STRING, 16384, 0).arg(0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, stringReplacer, 16384, null));
        this.register("replace-with", 4, e -> e.populate(ReplaceWith::new, BuiltInAtomicType.STRING, 16384, 0).arg(0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, stringReplacer, 16384, null).arg(3, BuiltInAtomicType.STRING, 16384, null));
        this.register("send-mail", 3, e -> e.populate(SendMail::new, BuiltInAtomicType.BOOLEAN, 16384, 0).arg(0, MapType.getInstance(), 16384, EMPTY).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, AnyItemType.getInstance(), 16384, null));
        this.register("send-mail", 4, e -> e.populate(SendMail::new, BuiltInAtomicType.BOOLEAN, 16384, 0).arg(0, MapType.getInstance(), 16384, EMPTY).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, AnyItemType.getInstance(), 16384, null).arg(3, AnyItemType.getInstance(), 57344, null));
        this.register("serialize", 2, e -> e.populate(Serialize::new, BuiltInAtomicType.STRING, 16384, 0).arg(0, AnyNodeTest.getInstance(), 16384, null).arg(1, AnyItemType.getInstance(), 16384, null));
        this.register("slice", 2, e -> e.populate(SaxonSlice::new, AnyItemType.getInstance(), 57344, 0).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, BuiltInAtomicType.INTEGER, 57344, null));
        this.register("string-to-hexBinary", 2, e -> e.populate(StringToHexBinaryFn::new, BuiltInAtomicType.HEX_BINARY, 24576, 0).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("string-to-base64Binary", 2, e -> e.populate(StringToBase64BinaryFn::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("string-to-utf8", 1, e -> e.populate(StringToUTF8::new, BuiltInAtomicType.INTEGER, 57344, 0).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("system-id", 0, e -> e.populate(SystemId::new, BuiltInAtomicType.STRING, 24576, 516));
        this.register("system-id", 1, e -> e.populate(SystemId::new, BuiltInAtomicType.STRING, 24576, 0).arg(0, AnyNodeTest.getInstance(), 24576, EMPTY));
        this.register("timestamp", 0, e -> e.populate(TimestampFn::new, BuiltInAtomicType.DATE_TIME_STAMP, 16384, 8704));
        this.register("transform", 2, e -> e.populate(TransformFn::new, NodeKindTest.DOCUMENT, 24576, 0).arg(0, JavaExternalObjectType.of(PreparedStylesheet.class), 16384, null).arg(1, AnyNodeTest.getInstance(), 16384, null));
        this.register("transform", 3, e -> e.populate(TransformFn::new, NodeKindTest.DOCUMENT, 24576, 0).arg(0, JavaExternalObjectType.of(PreparedStylesheet.class), 16384, null).arg(1, AnyNodeTest.getInstance(), 16384, null).arg(2, AnyItemType.getInstance(), 57344, null));
        MapType parameterMapType = new MapType(BuiltInAtomicType.QNAME, SequenceType.ANY_SEQUENCE);
        this.register("tunnel-params", 0, e -> e.populate(TunnelParamsFn::new, parameterMapType, 16384, 512));
        this.register("type-annotation", 1, e -> e.populate(TypeAnnotationFn::new, BuiltInAtomicType.QNAME, 24576, 0).arg(0, AnyItemType.getInstance(), 24576, null));
        this.register("unescape-NCName", 1, e -> e.populate(UnescapeNCName::new, BuiltInAtomicType.STRING, 16384, 0).arg(0, BuiltInAtomicType.NCNAME, 16384, EMPTY));
        this.register("unindexed", 1, e -> e.populate(Unindexed::new, AnyItemType.getInstance(), 57344, 131072).arg(0, AnyItemType.getInstance(), 57344, EmptySequence.getInstance()));
        this.register("unparsed-entities", 1, e -> e.populate(UnparsedEntities::new, BuiltInAtomicType.STRING, 57344, 131072).arg(0, NodeKindTest.DOCUMENT, 16384, null));
        this.register("valid-character", 1, e -> e.populate(ValidCharacter::new, BuiltInAtomicType.BOOLEAN, 16384, 0).arg(0, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("with-pedigree", 1, e -> e.populate(WithPedigree::new, AnyFunctionType.getInstance(), 16384, 0).arg(0, AnyFunctionType.getInstance(), 16384, null));
        this.register("xquery", 1, e -> e.populate(XQueryFn::new, XQueryFn.functionType, 16384, 0).arg(0, BuiltInAtomicType.STRING, 16384, null));
    }

    @Override
    public NamespaceUri getNamespace() {
        return NamespaceUri.SAXON;
    }

    @Override
    public String getConventionalPrefix() {
        return "saxon";
    }

    private static String normalizeEncodingName(String encoding) {
        return encoding;
    }

    private static StringValue decodeString(XPathContext context, byte[] bytes, String encoding) throws IOException, XPathException {
        encoding = VendorFunctionSetPE.normalizeEncodingName(encoding);
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        InputStreamReader reader = new InputStreamReader((InputStream)stream, encoding);
        char[] array = new char[bytes.length];
        int used = reader.read(array, 0, array.length);
        VendorFunctionSetPE.checkBytes(array, 0, used, context.getConfiguration().getValidCharacterChecker());
        return new StringValue(new String(array, 0, used));
    }

    private static byte[] toByteArray(Sequence arg) throws XPathException {
        GroundedValue input = arg.materialize();
        byte[] octets = new byte[input.getLength()];
        for (int i = 0; i < octets.length; ++i) {
            long l = ((IntegerValue)input.itemAt(i)).longValue();
            if (l < 0L || l > 255L) {
                throw new XPathException("Integers in input sequence must be in range 0-255", "SXJX0001");
            }
            octets[i] = (byte)l;
        }
        return octets;
    }

    private static void checkBytes(char[] array, int start, int end, IntPredicateProxy checker) throws XPathException {
        int ch32 = UTF16CharacterSet.firstInvalidChar(StringTool.codePoints(new String(array, start, end - start)), checker);
        if (ch32 != -1) {
            throw new XPathException("The byte sequence contains a character not allowed by XML (hex " + Integer.toHexString(ch32) + ')').withErrorCode("XTDE1180");
        }
    }

    public static class ValidCharacter
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            long charCode = ((IntegerValue)arguments[0].head()).longValue();
            boolean valid = charCode > 0L && charCode < 0x10FFFFL && context.getConfiguration().getValidCharacterChecker().test((int)charCode);
            return BooleanValue.get(valid);
        }
    }

    public static class UnparsedEntities
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Iterator<String> names = ((NodeInfo)arguments[0].head()).getTreeInfo().getUnparsedEntityNames();
            ArrayList<StringValue> result = new ArrayList<StringValue>();
            while (names.hasNext()) {
                result.add(new StringValue(names.next()));
            }
            return SequenceExtent.makeSequenceExtent(result);
        }
    }

    public static class TypeAnnotationFn
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Item item = arguments[0].head();
            if (item == null) {
                return EmptySequence.getInstance();
            }
            if (item instanceof NodeInfo) {
                NodeInfo node = (NodeInfo)item;
                SchemaType type = node.getSchemaType();
                if (type == null) {
                    return EmptySequence.getInstance();
                }
                return new QNameValue(type.getStructuredQName(), BuiltInAtomicType.QNAME);
            }
            if (item instanceof AtomicValue) {
                AtomicType type = ((AtomicValue)item).getItemType();
                return new QNameValue(type.getStructuredQName(), BuiltInAtomicType.QNAME);
            }
            if (item.getGenre() == Genre.EXTERNAL) {
                return new QNameValue(JavaExternalObjectType.classNameToQName(((AnyExternalObject)item).getWrappedObject().getClass().getName()), BuiltInAtomicType.QNAME);
            }
            return EmptySequence.getInstance();
        }
    }

    public static class TunnelParamsFn
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ParameterSet params = context.getTunnelParameters();
            params.materializeValues();
            StructuredQName[] names = params.getParameterNames();
            HashTrieMap map = new HashTrieMap();
            for (int i = 0; i < params.size(); ++i) {
                map.initialPut(new QNameValue(names[i], BuiltInAtomicType.QNAME), params.getValue(i).materialize());
            }
            return map;
        }
    }

    public static class SystemId
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            NodeInfo node;
            if (arguments.length == 0) {
                Item item = context.getContextItem();
                if (!(item instanceof NodeInfo)) {
                    throw new XPathException("Context item for saxon:system-id is not a node", "XPDY0002");
                }
                node = (NodeInfo)item;
            } else {
                node = (NodeInfo)arguments[0].head();
            }
            return new StringValue(node.getSystemId());
        }
    }

    public static class StringToUTF8
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String s = arguments[0].head().getStringValue();
            ArrayList<Int64Value> list = new ArrayList<Int64Value>(s.length() * 2);
            byte[] octets = new byte[4];
            for (int i = 0; i < s.length(); ++i) {
                int used = UTF8CharacterSet.getUTF8Encoding(s.charAt(i), i + 1 < s.length() ? s.charAt(i + 1) : (char)'\u0000', octets);
                for (int j = 0; j < used; ++j) {
                    list.add(new Int64Value(0xFF & octets[j]));
                }
            }
            return SequenceExtent.makeSequenceExtent(list);
        }
    }

    public static class StringToHexBinaryFn
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            try {
                StringValue s = (StringValue)arguments[0].head();
                if (s == null) {
                    return EmptySequence.getInstance();
                }
                StringValue encoding = (StringValue)arguments[1].head();
                byte[] bytes = s.getStringValue().getBytes(encoding.getStringValue());
                return new HexBinaryValue(bytes);
            }
            catch (IOException e) {
                throw new XPathException(e);
            }
        }
    }

    public static class StringToBase64BinaryFn
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            try {
                StringValue s = (StringValue)arguments[0].head();
                if (s == null) {
                    return EmptySequence.getInstance();
                }
                StringValue encoding = (StringValue)arguments[1].head();
                byte[] bytes = s.getStringValue().getBytes(encoding.getStringValue());
                return new Base64BinaryValue(bytes);
            }
            catch (IOException e) {
                throw new XPathException(e);
            }
        }
    }

    public static class PrintStack
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
            StandardLogger logger = new StandardLogger();
            logger.setPrintStream(new PrintStream(baos));
            new StandardDiagnostics().logStackTrace(context, logger, 2);
            return new StringValue(baos.toString().replace("\r", ""));
        }
    }

    public static class ParseDateTime
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            int nano;
            TemporalAccessor ta;
            DateTimeFormatter formatter;
            StringValue input = (StringValue)arguments[0].head();
            if (input == null) {
                return EmptySequence.getInstance();
            }
            StringValue format = (StringValue)arguments[1].head();
            try {
                formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(format.getStringValue()).toFormatter().withResolverStyle(ResolverStyle.SMART);
            }
            catch (IllegalArgumentException e) {
                throw new XPathException("Invalid date/time pattern " + format.getUnicodeStringValue() + ": " + e.getMessage());
            }
            try {
                ta = formatter.parse(input.getStringValue());
            }
            catch (DateTimeParseException e) {
                throw new XPathException("Supplied date/time value " + input.getUnicodeStringValue() + " cannot be parsed using pattern " + format.getUnicodeStringValue() + ": " + e.getMessage());
            }
            boolean hasYear = ta.isSupported(ChronoField.YEAR);
            boolean hasMonth = ta.isSupported(ChronoField.MONTH_OF_YEAR);
            boolean hasDay = ta.isSupported(ChronoField.DAY_OF_MONTH);
            boolean hasHour = ta.isSupported(ChronoField.HOUR_OF_DAY);
            boolean hasMinute = ta.isSupported(ChronoField.MINUTE_OF_HOUR);
            boolean hasSecond = ta.isSupported(ChronoField.SECOND_OF_MINUTE);
            boolean hasNano = ta.isSupported(ChronoField.NANO_OF_SECOND);
            boolean hasTZ = ta.isSupported(ChronoField.OFFSET_SECONDS);
            int tz = hasTZ ? ta.get(ChronoField.OFFSET_SECONDS) / 60 : Integer.MIN_VALUE;
            int year = hasYear ? ta.get(ChronoField.YEAR) : 0;
            byte month = hasMonth ? (byte)ta.get(ChronoField.MONTH_OF_YEAR) : (byte)0;
            byte day = hasDay ? (byte)ta.get(ChronoField.DAY_OF_MONTH) : (byte)0;
            byte hour = hasHour ? (byte)ta.get(ChronoField.HOUR_OF_DAY) : (byte)0;
            byte minute = hasMinute ? (byte)ta.get(ChronoField.MINUTE_OF_HOUR) : (byte)0;
            byte second = hasSecond ? (byte)ta.get(ChronoField.SECOND_OF_MINUTE) : (byte)0;
            int n = nano = hasNano ? ta.get(ChronoField.NANO_OF_SECOND) : 0;
            if (hasYear && hasMonth && hasDay) {
                if (hasHour && hasMinute) {
                    return new DateTimeValue(year, month, day, hour, minute, second, nano, tz);
                }
                return new DateValue(year, month, day, tz, false);
            }
            if (hasHour && hasMinute) {
                return new TimeValue(hour, minute, second, nano, tz, BuiltInAtomicType.TIME);
            }
            if (hasYear && hasMonth) {
                return new GYearMonthValue(year, month, tz, false);
            }
            if (hasYear) {
                return new GYearValue(year, tz, false);
            }
            if (hasMonth && hasDay) {
                return new GMonthDayValue(month, day, tz);
            }
            if (hasMonth) {
                return new GMonthValue(month, tz);
            }
            if (hasDay) {
                return new GDayValue(day, tz);
            }
            return EmptySequence.getInstance();
        }
    }

    public static class OctetsToHexBinary
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            byte[] bytes = VendorFunctionSetPE.toByteArray(arguments[0]);
            return new HexBinaryValue(bytes);
        }
    }

    public static class OctetsToBase64Binary
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            byte[] bytes = VendorFunctionSetPE.toByteArray(arguments[0]);
            return new Base64BinaryValue(bytes);
        }
    }

    public static class NamespaceNodeFn
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String prefix0 = arguments[0].head().getStringValue();
            UnicodeString uri0 = arguments[1].head().getUnicodeStringValue();
            if (!prefix0.isEmpty() && !NameChecker.isValidNCName(StringTool.codePoints(prefix0))) {
                throw new XPathException("Namespace prefix " + Err.wrap(prefix0) + " is not a valid NCName");
            }
            if (uri0.isEmpty()) {
                throw new XPathException("URI of namespace node must not be empty");
            }
            Orphan node = new Orphan(context.getConfiguration());
            node.setNodeKind((short)13);
            node.setNodeName(new NoNamespaceName(prefix0));
            node.setStringValue(uri0);
            return node;
        }
    }

    public static class LineNumber
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            NodeInfo node = (NodeInfo)arguments[0].head();
            return Int64Value.makeIntegerValue(node.getLineNumber());
        }
    }

    public static class IsDefaulted
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            NodeInfo node = (NodeInfo)arguments[0].head();
            boolean result = node instanceof TinyAttributeImpl && ((TinyAttributeImpl)node).isDefaultedAttribute();
            return BooleanValue.get(result);
        }
    }

    public static class InSummerTime
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Optional<Boolean> b;
            DateTimeValue dt = (DateTimeValue)arguments[0].head();
            if (!dt.hasTimezone()) {
                dt = dt.adjustTimezone(context.getImplicitTimezone());
            }
            if ((b = NamedTimeZone.inSummerTime(dt, arguments[1].head().getStringValue())).isPresent()) {
                return BooleanValue.get(b.get());
            }
            return EmptySequence.getInstance();
        }
    }

    public static class HexBinaryToString
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            try {
                HexBinaryValue in = (HexBinaryValue)arguments[0].head();
                if (in == null) {
                    return EmptySequence.getInstance();
                }
                byte[] bytes = in.getBinaryValue();
                String encoding = arguments[1].head().getStringValue();
                return VendorFunctionSetPE.decodeString(context, bytes, VendorFunctionSetPE.normalizeEncodingName(encoding));
            }
            catch (IOException e) {
                throw new XPathException(e);
            }
        }
    }

    public static class HexBinaryToOctets
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            HexBinaryValue in = (HexBinaryValue)arguments[0].head();
            byte[] bytes = in.getBinaryValue();
            Item[] array = new Item[bytes.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Int64Value.makeDerived(0xFF & bytes[i], BuiltInAtomicType.UNSIGNED_BYTE);
            }
            return new SequenceExtent.Of(array);
        }
    }

    public static class HasSameNodes
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            NodeInfo n2;
            NodeInfo n1;
            SequenceIterator e1 = arguments[0].iterate();
            SequenceIterator e2 = arguments[1].iterate();
            if (e1 == null) {
                e1 = EmptyIterator.getInstance();
            }
            if (e2 == null) {
                e2 = EmptyIterator.getInstance();
            }
            do {
                n1 = (NodeInfo)e1.next();
                n2 = (NodeInfo)e2.next();
                if (n1 != null && n2 != null) continue;
                return BooleanValue.get(n1 == n2);
            } while (n1.equals(n2));
            return BooleanValue.FALSE;
        }
    }

    public static class GetPseudoAttribute
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Item pi = context.getContextItem();
            if (pi == null) {
                throw new XPathException("The context item for saxon:get-pseudo-attribute() is not set").withXPathContext(context);
            }
            String value = ProcInstParser.getPseudoAttribute(pi.getStringValue(), arguments[0].head().getStringValue());
            return value == null ? EmptySequence.getInstance() : new StringValue(value);
        }
    }

    public static class GetContext
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            return new ObjectValue<XPathContext>(context);
        }
    }

    public static class DiscardDocument
    extends SystemFunction {
        @Override
        public synchronized Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            NodeInfo doc = (NodeInfo)arguments[0].head();
            if (doc == null) {
                return EmptySequence.getInstance();
            }
            Controller c = context.getController();
            String uri = c.getDocumentPool().getDocumentURI(doc);
            if (uri != null && c instanceof XsltController) {
                ((XsltController)c).removeUnavailableOutputDestination(new DocumentKey(uri));
            }
            c.getDocumentPool().discard(doc.getTreeInfo());
            return doc;
        }
    }

    public static class CurrentModeName
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Component.M mode = context.getCurrentMode();
            if (mode == null) {
                return EmptySequence.getInstance();
            }
            StructuredQName name = mode.getActor().getModeName();
            if (name == null || name.equals(Mode.UNNAMED_MODE_NAME)) {
                return EmptySequence.getInstance();
            }
            return new QNameValue(name, BuiltInAtomicType.QNAME);
        }
    }

    public static class ConfigurationFn
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            return new ObjectValue<Configuration>(context.getConfiguration());
        }
    }

    public static class ControllerFn
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            return new ObjectValue<Controller>(context.getController());
        }
    }

    public static class ContextFn
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            return new ObjectValue<XPathContext>(context);
        }
    }

    public static class ColumnNumber
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            NodeInfo node = (NodeInfo)arguments[0].head();
            return Int64Value.makeIntegerValue(node.getColumnNumber());
        }
    }

    public static class Base64BinaryToString
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            try {
                Base64BinaryValue in = (Base64BinaryValue)arguments[0].head();
                if (in == null) {
                    return EmptySequence.getInstance();
                }
                byte[] bytes = in.getBinaryValue();
                String encoding = arguments[1].head().getStringValue();
                return VendorFunctionSetPE.decodeString(context, bytes, VendorFunctionSetPE.normalizeEncodingName(encoding));
            }
            catch (IOException e) {
                throw new XPathException(e);
            }
        }
    }

    public static class Base64BinaryToOctets
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue in = (Base64BinaryValue)arguments[0].head();
            byte[] bytes = in.getBinaryValue();
            Item[] array = new Item[bytes.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Int64Value.makeDerived(0xFF & bytes[i], BuiltInAtomicType.UNSIGNED_BYTE);
            }
            return new SequenceExtent.Of(array);
        }
    }

    public static class AdjustToCivilTime
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            DateTimeValue dt = (DateTimeValue)arguments[0].head();
            if (dt == null) {
                return EmptySequence.getInstance();
            }
            if (!dt.hasTimezone()) {
                dt = dt.adjustTimezone(context.getImplicitTimezone());
            }
            int seconds = NamedTimeZone.civilTimeOffsetInSeconds(dt, arguments[1].head().getStringValue());
            return dt.adjustTimezone(seconds / 60);
        }
    }
}

