/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korapxmltools;

import de.ids_mannheim.korapxmltools.AnnotationToolBridgeFactory;
import de.ids_mannheim.korapxmltools.AnnotationWorkerPool;
import de.ids_mannheim.korapxmltools.ColoredFormatter;
import de.ids_mannheim.korapxmltools.NonBmpString;
import de.ids_mannheim.korapxmltools.ParserToolBridge;
import de.ids_mannheim.korapxmltools.TaggerToolBridge;
import de.ids_mannheim.korapxmltools.XMLCommentFilterReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import picocli.CommandLine;

@CommandLine.Command(name="KorapXml2Conllu", version={"KorapXml2Conllu 2.0-alpha-03"}, mixinStandardHelpOptions=true, description={"Converts KorAP-XML <https://github.com/KorAP/KorAP-XML-Krill#about-korap-xml> base or morpho zips to (annotated) CoNLL(-U) format with all information necessary for reconstruction in comment lines."})
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b&\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u009e\u0001\u009f\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0002H\u0007J\u0010\u0010H\u001a\u00020A2\u0006\u0010I\u001a\u00020\u0011H\u0007J\u0010\u0010L\u001a\u00020A2\u0006\u0010M\u001a\u00020\u0011H\u0007J\r\u0010N\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010OJ\n\u0010r\u001a\u00020\u0006*\u00020\u0011J\f\u0010s\u001a\u0004\u0018\u00010\u0011*\u00020\u0011J\u0019\u0010t\u001a\u00020A2\f\u0010u\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0015J'\u0010v\u001a\b\u0012\u0004\u0012\u00020Z0\u00102\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020`0_H\u0002\u00a2\u0006\u0002\u0010wJ\u0010\u0010x\u001a\u00020\u00112\u0006\u0010y\u001a\u00020\u0011H\u0002J\u001b\u0010z\u001a\u00020\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0002\u0010{J\u001a\u0010|\u001a\u00020A2\u0006\u0010}\u001a\u00020\u00112\b\b\u0002\u0010~\u001a\u00020\u0011H\u0002J\u001a\u0010\u007f\u001a\u00020A2\u0006\u0010}\u001a\u00020\u00112\b\b\u0002\u0010~\u001a\u00020\u0011H\u0002J-\u0010\u0080\u0001\u001a\u00020A2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0007\u0010\u0083\u0001\u001a\u00020\u00112\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u0086\u0001\u001a\u00020\u0006J\u001a\u0010\u0087\u0001\u001a\u00020A2\u0007\u0010\u0088\u0001\u001a\u00020\u00112\u0006\u0010~\u001a\u00020\u0011H\u0002J}\u0010\u0089\u0001\u001a\u00020\u00112\u0007\u0010\u008a\u0001\u001a\u00020\u00022\u0007\u0010\u008b\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u008c\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u008d\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u008e\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u008f\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u0090\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u0091\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u0092\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u0093\u0001\u001a\u00020\u00112\b\b\u0002\u0010&\u001a\u00020\u0002H\u0002JX\u0010\u0094\u0001\u001a\u00020\u00112\u0018\u0010Y\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020Z0\u00100U2\u0007\u0010\u0088\u0001\u001a\u00020\u00112\u0007\u0010\u0095\u0001\u001a\u00020\u00022\u0007\u0010\u008a\u0001\u001a\u00020\u00022\u0018\u0010\\\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020Z0\u00100UH\u0002J\u001f\u0010\u0096\u0001\u001a\b\u0012\u0004\u0012\u00020Z0\u00102\b\u0010\u0097\u0001\u001a\u00030\u0098\u0001H\u0002\u00a2\u0006\u0003\u0010\u0099\u0001J\u001f\u0010\u009a\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020`0_2\b\u0010\u009b\u0001\u001a\u00030\u0098\u0001H\u0002J\u001f\u0010\u009c\u0001\u001a\b\u0012\u0004\u0012\u00020Z0\u00102\b\u0010\u0097\u0001\u001a\u00030\u0098\u0001H\u0002\u00a2\u0006\u0003\u0010\u0099\u0001J\u001f\u0010\u009d\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110_2\b\u0010\u0097\u0001\u001a\u00030\u0098\u0001H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR(\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R \u0010\u0017\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001e\u0010\u001f\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\b\"\u0004\b!\u0010\"R\u001e\u0010#\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0019\"\u0004\b%\u0010\u001bR\u001e\u0010&\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001e\u0010+\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\b\"\u0004\b-\u0010\"R\u001e\u0010.\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0019\"\u0004\b0\u0010\u001bR\u001e\u00101\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\b\"\u0004\b3\u0010\"R\u001e\u00104\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\b\"\u0004\b6\u0010\"R$\u00107\u001a\b\u0012\u0004\u0012\u00020\u0011088\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001e\u0010=\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0019\"\u0004\b?\u0010\u001bR\u001a\u0010C\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010(\"\u0004\bE\u0010*R\u0010\u0010F\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010J\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010K\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020QX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010R\u001a\u0004\u0018\u00010SX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010T\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020V0U\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010XR#\u0010Y\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020Z0\u00100U\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010XR#\u0010\\\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020Z0\u00100U\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010XR)\u0010^\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020`0_0U\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010XR\u001d\u0010b\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110U\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010XR#\u0010d\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100U\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010XR)\u0010f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110_0U\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010XR(\u0010h\u001a\u0010\u0012\u0004\u0012\u00020i\u0012\u0006\u0012\u0004\u0018\u00010j0UX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bk\u0010X\"\u0004\bl\u0010mR(\u0010n\u001a\u0010\u0012\u0004\u0012\u00020i\u0012\u0006\u0012\u0004\u0018\u00010o0UX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010X\"\u0004\bq\u0010m\u00a8\u0006\u00a0\u0001"}, d2={"Lde/ids_mannheim/korapxmltools/KorapXml2Conllu;", "Ljava/util/concurrent/Callable;", "", "<init>", "()V", "COMPATIBILITY_MODE", "", "getCOMPATIBILITY_MODE", "()Z", "spec", "Lpicocli/CommandLine$Model$CommandSpec;", "getSpec", "()Lpicocli/CommandLine$Model$CommandSpec;", "setSpec", "(Lpicocli/CommandLine$Model$CommandSpec;)V", "zipFileNames", "", "", "getZipFileNames", "()[Ljava/lang/String;", "setZipFileNames", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "siglePattern", "getSiglePattern", "()Ljava/lang/String;", "setSiglePattern", "(Ljava/lang/String;)V", "extractAttributesRegex", "getExtractAttributesRegex", "setExtractAttributesRegex", "sBoundsFromMorpho", "getSBoundsFromMorpho", "setSBoundsFromMorpho", "(Z)V", "logLevel", "getLogLevel", "setLogLevel", "columns", "getColumns", "()I", "setColumns", "(I)V", "lmTrainingData", "getLmTrainingData", "setLmTrainingData", "tokenSeparator", "getTokenSeparator", "setTokenSeparator", "offsets", "getOffsets", "setOffsets", "comments", "getComments", "setComments", "extractMetadataRegex", "", "getExtractMetadataRegex", "()Ljava/util/List;", "setExtractMetadataRegex", "(Ljava/util/List;)V", "annotateWith", "getAnnotateWith", "setAnnotateWith", "setThreads", "", "threads", "maxThreads", "getMaxThreads", "setMaxThreads", "taggerName", "taggerModel", "setTagWith", "tagWith", "parserName", "parserModel", "setParseWith", "parseWith", "call", "()Ljava/lang/Integer;", "LOGGER", "Ljava/util/logging/Logger;", "annotationWorkerPool", "Lde/ids_mannheim/korapxmltools/AnnotationWorkerPool;", "texts", "Ljava/util/concurrent/ConcurrentHashMap;", "Lde/ids_mannheim/korapxmltools/NonBmpString;", "getTexts", "()Ljava/util/concurrent/ConcurrentHashMap;", "sentences", "Lde/ids_mannheim/korapxmltools/KorapXml2Conllu$Span;", "getSentences", "tokens", "getTokens", "morpho", "", "Lde/ids_mannheim/korapxmltools/KorapXml2Conllu$MorphoSpan;", "getMorpho", "fnames", "getFnames", "metadata", "getMetadata", "extraFeatures", "getExtraFeatures", "taggerToolBridges", "", "Lde/ids_mannheim/korapxmltools/TaggerToolBridge;", "getTaggerToolBridges", "setTaggerToolBridges", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "parserToolBridges", "Lde/ids_mannheim/korapxmltools/ParserToolBridge;", "getParserToolBridges", "setParserToolBridges", "hasCorrespondingBaseZip", "correspondingBaseZip", "korapxml2conllu", "args", "getTokenSpansFromMorho", "(Ljava/util/Map;)[Lde/ids_mannheim/korapxmltools/KorapXml2Conllu$Span;", "getFoundryFromZipFileName", "zipFileName", "getFoundryFromZipFileNames", "([Ljava/lang/String;)Ljava/lang/String;", "processZipFile", "zipFilePath", "foundry", "processZipFileSequentially", "processZipEntry", "zipFile", "Ljava/util/zip/ZipFile;", "_foundry", "zipEntry", "Ljava/util/zip/ZipEntry;", "passedWaitForMorpho", "processText", "docId", "printConlluToken", "token_index", "token", "lemma", "upos", "xpos", "feats", "head", "deprel", "deps", "misc", "tokenOffsetsInSentence", "sentence_index", "extractSpans", "spans", "Lorg/w3c/dom/NodeList;", "(Lorg/w3c/dom/NodeList;)[Lde/ids_mannheim/korapxmltools/KorapXml2Conllu$Span;", "extractMorphoSpans", "fsSpans", "extractSentenceSpans", "extractMiscSpans", "Span", "MorphoSpan", "app"})
@SourceDebugExtension(value={"SMAP\nKorapXml2Conllu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KorapXml2Conllu.kt\nde/ids_mannheim/korapxmltools/KorapXml2Conllu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,719:1\n1557#2:720\n1628#2,3:721\n1053#2:724\n1863#2,2:728\n37#3,2:725\n37#3,2:730\n1#4:727\n13346#5,2:732\n13346#5,2:734\n13346#5,2:736\n*S KotlinDebug\n*F\n+ 1 KorapXml2Conllu.kt\nde/ids_mannheim/korapxmltools/KorapXml2Conllu\n*L\n260#1:720\n260#1:721,3\n263#1:724\n417#1:728,2\n265#1:725,2\n424#1:730,2\n450#1:732,2\n486#1:734,2\n547#1:736,2\n*E\n"})
public final class KorapXml2Conllu
implements Callable<Integer> {
    private final boolean COMPATIBILITY_MODE = System.getenv("COMPATIBILITY_MODE") != null;
    @CommandLine.Spec
    public CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(description={"At least one zip file name"}, arity="1..*")
    @Nullable
    private String[] zipFileNames;
    @CommandLine.Option(names={"--sigle-pattern", "-p"}, description={"Extract only documents with sigle matching the pattern (regex)"}, paramLabel="PATTERN")
    @Nullable
    private String siglePattern;
    @CommandLine.Option(names={"--extract-attributes-regex", "-e"}, description={"Extract additional attribute values from structure.xml and writes them as comment line in front of the first covered token.", "Example: -e '(posting/id|div/id)'"}, paramLabel="REGEX")
    @NotNull
    private String extractAttributesRegex = "";
    @CommandLine.Option(names={"--s-bounds-from-morpho"}, description={"Not yet implemented: s bounds from morpho"})
    private boolean sBoundsFromMorpho;
    @CommandLine.Option(names={"--log", "-l"}, description={"Log level: one of SEVERE, WARNING, INFO, FINE, FINER, FINEST. Default: ${DEFAULT-VALUE}])"}, paramLabel="LEVEL")
    @NotNull
    private String logLevel = "WARNING";
    @CommandLine.Option(names={"--columns", "-c"}, description={"Number of columns. 1 means just the token. Default: ${DEFAULT-VALUE}", "Possible values: 1-10"}, paramLabel="NUMBER")
    private int columns = 10;
    @CommandLine.Option(names={"--word2vec", "-w"}, description={"Print text in LM training format: tokens separated by space, sentences separated by newline"})
    private boolean lmTrainingData;
    @CommandLine.Option(names={"--token-separator", "-s"}, description={"Token separator. Default: new-line for CoNLL-U, space for word2vec format."}, paramLabel="STRING", defaultValue="\n")
    @NotNull
    private String tokenSeparator = this.lmTrainingData ? " " : "\n";
    @CommandLine.Option(names={"--offsets"}, description={"Not yet implemented: offsets"})
    private boolean offsets;
    @CommandLine.Option(names={"--comments", "-C"}, description={"Not yet implemented: comments"})
    private boolean comments;
    @CommandLine.Option(names={"--extract-metadata-regex", "-m"}, description={"Extract metadata regexes.\nExample: -m '<textSigle>([^<]+)' -m '<creatDate>([^<]+)'"}, paramLabel="REGEX")
    @NotNull
    private List<String> extractMetadataRegex = new ArrayList();
    @CommandLine.Option(names={"--annotate-with", "-A"}, description={"Pipe output through command"}, paramLabel="COMMAND")
    @NotNull
    private String annotateWith = "";
    private int maxThreads = Runtime.getRuntime().availableProcessors() / 2;
    @Nullable
    private String taggerName;
    @Nullable
    private String taggerModel;
    @Nullable
    private String parserName;
    @Nullable
    private String parserModel;
    @NotNull
    private final Logger LOGGER;
    @Nullable
    private AnnotationWorkerPool annotationWorkerPool;
    @NotNull
    private final ConcurrentHashMap<String, NonBmpString> texts;
    @NotNull
    private final ConcurrentHashMap<String, Span[]> sentences;
    @NotNull
    private final ConcurrentHashMap<String, Span[]> tokens;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, MorphoSpan>> morpho;
    @NotNull
    private final ConcurrentHashMap<String, String> fnames;
    @NotNull
    private final ConcurrentHashMap<String, String[]> metadata;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, String>> extraFeatures;
    @NotNull
    private ConcurrentHashMap<Long, TaggerToolBridge> taggerToolBridges;
    @NotNull
    private ConcurrentHashMap<Long, ParserToolBridge> parserToolBridges;

    public KorapXml2Conllu() {
        Logger logger = Logger.getLogger(KorapXml2Conllu.class.getName());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.LOGGER = logger;
        this.texts = new ConcurrentHashMap();
        this.sentences = new ConcurrentHashMap();
        this.tokens = new ConcurrentHashMap();
        this.morpho = new ConcurrentHashMap();
        this.fnames = new ConcurrentHashMap();
        this.metadata = new ConcurrentHashMap();
        this.extraFeatures = new ConcurrentHashMap();
        this.taggerToolBridges = new ConcurrentHashMap();
        this.parserToolBridges = new ConcurrentHashMap();
    }

    public final boolean getCOMPATIBILITY_MODE() {
        return this.COMPATIBILITY_MODE;
    }

    @NotNull
    public final CommandLine.Model.CommandSpec getSpec() {
        CommandLine.Model.CommandSpec commandSpec = this.spec;
        if (commandSpec != null) {
            return commandSpec;
        }
        Intrinsics.throwUninitializedPropertyAccessException("spec");
        return null;
    }

    public final void setSpec(@NotNull CommandLine.Model.CommandSpec commandSpec) {
        Intrinsics.checkNotNullParameter(commandSpec, "<set-?>");
        this.spec = commandSpec;
    }

    @Nullable
    public final String[] getZipFileNames() {
        return this.zipFileNames;
    }

    public final void setZipFileNames(@Nullable String[] stringArray) {
        this.zipFileNames = stringArray;
    }

    @Nullable
    public final String getSiglePattern() {
        return this.siglePattern;
    }

    public final void setSiglePattern(@Nullable String string) {
        this.siglePattern = string;
    }

    @NotNull
    public final String getExtractAttributesRegex() {
        return this.extractAttributesRegex;
    }

    public final void setExtractAttributesRegex(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.extractAttributesRegex = string;
    }

    public final boolean getSBoundsFromMorpho() {
        return this.sBoundsFromMorpho;
    }

    public final void setSBoundsFromMorpho(boolean bl) {
        this.sBoundsFromMorpho = bl;
    }

    @NotNull
    public final String getLogLevel() {
        return this.logLevel;
    }

    public final void setLogLevel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.logLevel = string;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final void setColumns(int n) {
        this.columns = n;
    }

    public final boolean getLmTrainingData() {
        return this.lmTrainingData;
    }

    public final void setLmTrainingData(boolean bl) {
        this.lmTrainingData = bl;
    }

    @NotNull
    public final String getTokenSeparator() {
        return this.tokenSeparator;
    }

    public final void setTokenSeparator(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.tokenSeparator = string;
    }

    public final boolean getOffsets() {
        return this.offsets;
    }

    public final void setOffsets(boolean bl) {
        this.offsets = bl;
    }

    public final boolean getComments() {
        return this.comments;
    }

    public final void setComments(boolean bl) {
        this.comments = bl;
    }

    @NotNull
    public final List<String> getExtractMetadataRegex() {
        return this.extractMetadataRegex;
    }

    public final void setExtractMetadataRegex(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.extractMetadataRegex = list;
    }

    @NotNull
    public final String getAnnotateWith() {
        return this.annotateWith;
    }

    public final void setAnnotateWith(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.annotateWith = string;
    }

    @CommandLine.Option(names={"--threads", "-T"}, description={"Maximum number of threads to use. Default: ${DEFAULT-VALUE}"}, paramLabel="THREADS")
    public final void setThreads(int threads) {
        if (threads < 1) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string = "Invalid value `%d' for option '--threads': must be at least 1";
            Object[] objectArray = new Object[]{threads};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string2);
        }
        this.maxThreads = threads;
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", String.valueOf(threads));
    }

    public final int getMaxThreads() {
        return this.maxThreads;
    }

    public final void setMaxThreads(int n) {
        this.maxThreads = n;
    }

    @CommandLine.Option(names={"--tag-with", "-t"}, description={"Specify a tagger and a model: marmot|opennlp:<path/to/model>."}, paramLabel="TAGGER:MODEL")
    public final void setTagWith(@NotNull String tagWith) {
        Intrinsics.checkNotNullParameter(tagWith, "tagWith");
        Pattern pattern = Pattern.compile("(marmot|opennlp):(.+)");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        Pattern pattern2 = pattern;
        Matcher matcher = pattern2.matcher(tagWith);
        Intrinsics.checkNotNullExpressionValue(matcher, "matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string = "Invalid value `%s' for option '--tag-with': value does not match the expected pattern marmot|opennlp:<path/to/model>";
            Object[] objectArray = new Object[]{tagWith};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string2);
        }
        this.taggerName = matcher2.group(1);
        this.taggerModel = matcher2.group(2);
        if (!new File(this.taggerModel).exists()) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string = "Invalid value for option '--tag-with':model file '%s' does not exist";
            Object[] objectArray = new Object[]{this.taggerModel, this.taggerModel};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string3);
        }
    }

    @CommandLine.Option(names={"--parse-with", "-P"}, description={"Specify a parser and a model: malt:<path/to/model>."}, paramLabel="parser:MODEL")
    public final void setParseWith(@NotNull String parseWith) {
        Intrinsics.checkNotNullParameter(parseWith, "parseWith");
        Pattern pattern = Pattern.compile("(malt):(.+)");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        Pattern pattern2 = pattern;
        Matcher matcher = pattern2.matcher(parseWith);
        Intrinsics.checkNotNullExpressionValue(matcher, "matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string = "Invalid value `%s' for option '--parse-with': value does not match the expected pattern (malt):<path/to/model>";
            Object[] objectArray = new Object[]{parseWith};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string2);
        }
        this.parserName = matcher2.group(1);
        this.parserModel = matcher2.group(2);
        if (!new File(this.parserModel).exists()) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string = "Invalid value for option '--parse-with':model file '%s' does not exist";
            Object[] objectArray = new Object[]{this.parserModel, this.parserModel};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string3);
        }
    }

    @Override
    @NotNull
    public Integer call() {
        Logger logger;
        ConsoleHandler handler = new ConsoleHandler();
        LogManager.getLogManager().reset();
        handler.setFormatter(new ColoredFormatter());
        Object object = ArrayIteratorKt.iterator(this.LOGGER.getHandlers());
        while (object.hasNext()) {
            Handler handler2 = object.next();
            this.LOGGER.removeHandler(handler2);
        }
        this.LOGGER.addHandler(handler);
        Logger logger2 = this.LOGGER;
        try {
            logger = logger2;
            object = this.logLevel;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string = ((String)object).toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            object = Level.parse(string);
        }
        catch (IllegalArgumentException handler2) {
            logger = logger2;
            this.LOGGER.warning("Invalid log level: " + this.logLevel + ". Defaulting to WARNING.");
            object = Level.WARNING;
        }
        logger.setLevel((Level)object);
        Intrinsics.checkNotNull(this.zipFileNames);
        this.LOGGER.info("Processing zip files: " + ArraysKt.joinToString$default(this.zipFileNames, (CharSequence)", ", null, null, 0, null, null, 62, null));
        Intrinsics.checkNotNull(this.zipFileNames);
        this.korapxml2conllu(this.zipFileNames);
        return 0;
    }

    @NotNull
    public final ConcurrentHashMap<String, NonBmpString> getTexts() {
        return this.texts;
    }

    @NotNull
    public final ConcurrentHashMap<String, Span[]> getSentences() {
        return this.sentences;
    }

    @NotNull
    public final ConcurrentHashMap<String, Span[]> getTokens() {
        return this.tokens;
    }

    @NotNull
    public final ConcurrentHashMap<String, Map<String, MorphoSpan>> getMorpho() {
        return this.morpho;
    }

    @NotNull
    public final ConcurrentHashMap<String, String> getFnames() {
        return this.fnames;
    }

    @NotNull
    public final ConcurrentHashMap<String, String[]> getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final ConcurrentHashMap<String, Map<String, String>> getExtraFeatures() {
        return this.extraFeatures;
    }

    @NotNull
    public final ConcurrentHashMap<Long, TaggerToolBridge> getTaggerToolBridges() {
        return this.taggerToolBridges;
    }

    public final void setTaggerToolBridges(@NotNull ConcurrentHashMap<Long, TaggerToolBridge> concurrentHashMap) {
        Intrinsics.checkNotNullParameter(concurrentHashMap, "<set-?>");
        this.taggerToolBridges = concurrentHashMap;
    }

    @NotNull
    public final ConcurrentHashMap<Long, ParserToolBridge> getParserToolBridges() {
        return this.parserToolBridges;
    }

    public final void setParserToolBridges(@NotNull ConcurrentHashMap<Long, ParserToolBridge> concurrentHashMap) {
        Intrinsics.checkNotNullParameter(concurrentHashMap, "<set-?>");
        this.parserToolBridges = concurrentHashMap;
    }

    public final boolean hasCorrespondingBaseZip(@NotNull String $this$hasCorrespondingBaseZip) {
        Intrinsics.checkNotNullParameter($this$hasCorrespondingBaseZip, "<this>");
        CharSequence charSequence = $this$hasCorrespondingBaseZip;
        if (!new Regex(".*\\.([^/.]+)\\.zip$").matches(charSequence)) {
            return false;
        }
        CharSequence charSequence2 = $this$hasCorrespondingBaseZip;
        Regex regex = new Regex("\\.([^/.]+)\\.zip$");
        String string = ".zip";
        String baseZip = regex.replace(charSequence2, string);
        return new File(baseZip).exists();
    }

    @Nullable
    public final String correspondingBaseZip(@NotNull String $this$correspondingBaseZip) {
        Intrinsics.checkNotNullParameter($this$correspondingBaseZip, "<this>");
        CharSequence charSequence = $this$correspondingBaseZip;
        if (!new Regex(".*\\.([^/.]+)\\.zip$").matches(charSequence)) {
            return null;
        }
        Regex regex = new Regex("\\.([^/.]+)\\.zip$");
        CharSequence charSequence2 = $this$correspondingBaseZip;
        String string = ".zip";
        String baseZip = regex.replace(charSequence2, string);
        return new File(baseZip).exists() ? baseZip : null;
    }

    public final void korapxml2conllu(@NotNull String[] args2) {
        block4: {
            Intrinsics.checkNotNullParameter(args2, "args");
            Executors.newFixedThreadPool(this.maxThreads);
            if (((CharSequence)this.annotateWith).length() > 0) {
                this.annotationWorkerPool = new AnnotationWorkerPool(this.annotateWith, this.maxThreads, this.LOGGER);
            }
            Ref.ObjectRef zips = new Ref.ObjectRef();
            zips.element = args2;
            if (this.maxThreads > 1) {
                this.LOGGER.info("Processing zip files in parallel with " + this.maxThreads + " threads");
                ((Stream)Arrays.stream((Object[])zips.element).parallel()).forEach(arg_0 -> KorapXml2Conllu.korapxml2conllu$lambda$1(arg_0 -> KorapXml2Conllu.korapxml2conllu$lambda$0(this, zips, arg_0), arg_0));
            } else {
                this.LOGGER.info("Processing zip files sequentially");
                Arrays.stream((Object[])zips.element).forEachOrdered(arg_0 -> KorapXml2Conllu.korapxml2conllu$lambda$3(arg_0 -> KorapXml2Conllu.korapxml2conllu$lambda$2(this, zips, arg_0), arg_0));
            }
            if (this.annotationWorkerPool == null) break block4;
            this.LOGGER.info("closing worker pool");
            AnnotationWorkerPool annotationWorkerPool = this.annotationWorkerPool;
            if (annotationWorkerPool != null) {
                annotationWorkerPool.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Span[] getTokenSpansFromMorho(Map<String, MorphoSpan> morpho) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = morpho.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void key;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"-"};
            List fromTo = StringsKt.split$default((CharSequence)key, stringArray, false, 0, 6, null);
            collection.add(new Span(Integer.parseInt((String)fromTo.get(0)), Integer.parseInt((String)fromTo.get(1))));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Collection $this$toTypedArray$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Span it = (Span)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getFrom());
                it = (Span)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getFrom());
            }
        });
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Span[0]);
    }

    private final String getFoundryFromZipFileName(String zipFileName) {
        CharSequence charSequence = zipFileName;
        if (!new Regex(".*\\.([^/.]+)\\.zip$").matches(charSequence)) {
            return "base";
        }
        charSequence = zipFileName;
        Regex regex = new Regex(".*\\.([^/.]+)\\.zip$");
        String string = "$1";
        return regex.replace(charSequence, string);
    }

    private final String getFoundryFromZipFileNames(String[] zipFileNames) {
        for (String zipFileName : zipFileNames) {
            String foundry = this.getFoundryFromZipFileName(zipFileName);
            if (Intrinsics.areEqual(foundry, "base")) continue;
            return foundry;
        }
        return "base";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processZipFile(String zipFilePath, String foundry) {
        this.LOGGER.info("Processing " + zipFilePath + " in thread " + Thread.currentThread().getId());
        if (this.hasCorrespondingBaseZip(zipFilePath)) {
            String[] stringArray = new String[2];
            stringArray[0] = zipFilePath;
            Intrinsics.checkNotNull(this.correspondingBaseZip(zipFilePath));
            String[] zips = stringArray;
            ((Stream)Arrays.stream(zips).parallel()).forEach(arg_0 -> KorapXml2Conllu.processZipFile$lambda$10(arg_0 -> KorapXml2Conllu.processZipFile$lambda$9(this, foundry, arg_0), arg_0));
        } else {
            Closeable closeable = new ZipFile(zipFilePath);
            Throwable throwable = null;
            try {
                ZipFile zipFile = (ZipFile)closeable;
                boolean bl = false;
                ((Stream)zipFile.stream().filter(arg_0 -> KorapXml2Conllu.processZipFile$lambda$13$lambda$11(new Function1(this){
                    final /* synthetic */ KorapXml2Conllu this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final Boolean invoke(ZipEntry it) {
                        boolean bl;
                        if (!(!((Collection)this.this$0.getExtractMetadataRegex()).isEmpty())) {
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                            if (StringsKt.contains$default((CharSequence)string, "header.xml", false, 2, null)) {
                                bl = false;
                                return bl;
                            }
                        }
                        bl = true;
                        return bl;
                    }
                }, arg_0)).parallel()).forEach(arg_0 -> KorapXml2Conllu.processZipFile$lambda$13$lambda$12(new Function1(this, zipFile, foundry){
                    final /* synthetic */ KorapXml2Conllu this$0;
                    final /* synthetic */ ZipFile $zipFile;
                    final /* synthetic */ String $foundry;
                    {
                        this.this$0 = $receiver;
                        this.$zipFile = $zipFile;
                        this.$foundry = $foundry;
                    }

                    public final void invoke(ZipEntry zipEntry) {
                        Intrinsics.checkNotNull(zipEntry);
                        this.this$0.processZipEntry(this.$zipFile, this.$foundry, zipEntry, false);
                    }
                }, arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
    }

    static /* synthetic */ void processZipFile$default(KorapXml2Conllu korapXml2Conllu, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "base";
        }
        korapXml2Conllu.processZipFile(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processZipFileSequentially(String zipFilePath, String foundry) {
        this.LOGGER.info("Processing " + zipFilePath + " in thread " + Thread.currentThread().getId());
        if (this.hasCorrespondingBaseZip(zipFilePath)) {
            String[] stringArray = new String[2];
            stringArray[0] = zipFilePath;
            Intrinsics.checkNotNull(this.correspondingBaseZip(zipFilePath));
            String[] zips = stringArray;
            ((Stream)Arrays.stream(zips).parallel()).forEach(arg_0 -> KorapXml2Conllu.processZipFileSequentially$lambda$18(arg_0 -> KorapXml2Conllu.processZipFileSequentially$lambda$17(this, foundry, arg_0), arg_0));
        } else {
            Closeable closeable = new ZipFile(zipFilePath);
            Throwable throwable = null;
            try {
                ZipFile zipFile = (ZipFile)closeable;
                boolean bl = false;
                zipFile.stream().filter(arg_0 -> KorapXml2Conllu.processZipFileSequentially$lambda$21$lambda$19(new Function1(this){
                    final /* synthetic */ KorapXml2Conllu this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final Boolean invoke(ZipEntry it) {
                        boolean bl;
                        if (!(!((Collection)this.this$0.getExtractMetadataRegex()).isEmpty())) {
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                            if (StringsKt.contains$default((CharSequence)string, "header.xml", false, 2, null)) {
                                bl = false;
                                return bl;
                            }
                        }
                        bl = true;
                        return bl;
                    }
                }, arg_0)).forEachOrdered(arg_0 -> KorapXml2Conllu.processZipFileSequentially$lambda$21$lambda$20(new Function1(this, zipFile, foundry){
                    final /* synthetic */ KorapXml2Conllu this$0;
                    final /* synthetic */ ZipFile $zipFile;
                    final /* synthetic */ String $foundry;
                    {
                        this.this$0 = $receiver;
                        this.$zipFile = $zipFile;
                        this.$foundry = $foundry;
                    }

                    public final void invoke(ZipEntry zipEntry) {
                        Intrinsics.checkNotNull(zipEntry);
                        this.this$0.processZipEntry(this.$zipFile, this.$foundry, zipEntry, false);
                    }
                }, arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
    }

    static /* synthetic */ void processZipFileSequentially$default(KorapXml2Conllu korapXml2Conllu, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "base";
        }
        korapXml2Conllu.processZipFileSequentially(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processZipEntry(@NotNull ZipFile zipFile, @NotNull String _foundry, @NotNull ZipEntry zipEntry, boolean passedWaitForMorpho) {
        block39: {
            Object parser;
            Intrinsics.checkNotNullParameter(zipFile, "zipFile");
            Intrinsics.checkNotNullParameter(_foundry, "_foundry");
            Intrinsics.checkNotNullParameter(zipEntry, "zipEntry");
            Object foundry = _foundry;
            boolean waitForMorpho = passedWaitForMorpho;
            this.LOGGER.finer("Processing " + zipEntry.getName() + " in thread " + Thread.currentThread().getId());
            if (this.taggerName != null && !this.taggerToolBridges.containsKey(Thread.currentThread().getId())) {
                String string = this.taggerName;
                Intrinsics.checkNotNull(string);
                String string2 = this.taggerModel;
                Intrinsics.checkNotNull(string2);
                TaggerToolBridge tagger = (TaggerToolBridge)AnnotationToolBridgeFactory.Companion.getAnnotationToolBridge(string, string2, this.LOGGER);
                ((Map)this.taggerToolBridges).put(Thread.currentThread().getId(), tagger);
                if (tagger != null) {
                    foundry = tagger.getFoundry();
                }
            }
            if (this.parserName != null && !this.parserToolBridges.containsKey(Thread.currentThread().getId())) {
                String string = this.parserName;
                Intrinsics.checkNotNull(string);
                String string3 = this.parserModel;
                Intrinsics.checkNotNull(string3);
                parser = (ParserToolBridge)AnnotationToolBridgeFactory.Companion.getAnnotationToolBridge(string, string3, this.LOGGER);
                ((Map)this.parserToolBridges).put(Thread.currentThread().getId(), parser);
                if (parser != null) {
                    foundry = (String)foundry + " dependency:" + parser.getFoundry();
                }
            }
            try {
                String string;
                String string42;
                Object inputStream;
                block41: {
                    Document document;
                    String string5 = zipEntry.getName();
                    Intrinsics.checkNotNullExpressionValue(string5, "getName(...)");
                    parser = string5;
                    if (!new Regex(".*(data|tokens|structure|morpho)\\.xml$").matches((CharSequence)parser)) break block41;
                    InputStream inputStream2 = zipFile.getInputStream(zipEntry);
                    Intrinsics.checkNotNullExpressionValue(inputStream2, "getInputStream(...)");
                    inputStream = inputStream2;
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    Intrinsics.checkNotNullExpressionValue(documentBuilderFactory, "newInstance(...)");
                    DocumentBuilderFactory dbFactory = documentBuilderFactory;
                    DocumentBuilder documentBuilder = dbFactory.newDocumentBuilder();
                    Intrinsics.checkNotNullExpressionValue(documentBuilder, "newDocumentBuilder(...)");
                    DocumentBuilder dBuilder = documentBuilder;
                    try {
                        document = dBuilder.parse(new InputSource(new XMLCommentFilterReader((InputStream)inputStream, "UTF-8")));
                    }
                    catch (SAXParseException e) {
                        this.LOGGER.warning("Error parsing file: " + zipEntry.getName() + " " + e.getMessage());
                        return;
                    }
                    Document doc = document;
                    doc.getDocumentElement().normalize();
                    String string6 = doc.getDocumentElement().getAttribute("docid");
                    Intrinsics.checkNotNullExpressionValue(string6, "getAttribute(...)");
                    String docId = string6;
                    if (this.siglePattern != null) {
                        String string7 = this.siglePattern;
                        Intrinsics.checkNotNull(string7);
                        if (!new Regex(string7).containsMatchIn(docId)) {
                            return;
                        }
                    }
                    String string8 = zipEntry.getName();
                    Intrinsics.checkNotNullExpressionValue(string8, "getName(...)");
                    CharSequence charSequence = string8;
                    Regex regex = new Regex(".*?/([^/]+\\.xml)$");
                    Object object = "$1";
                    String fileName = regex.replace(charSequence, (String)object);
                    switch (fileName) {
                        case "data.xml": {
                            NodeList nodeList = doc.getElementsByTagName("text");
                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                            NodeList textsList = nodeList;
                            if (textsList.getLength() <= 0) break;
                            object = this.texts;
                            String string9 = textsList.item(0).getTextContent();
                            Intrinsics.checkNotNullExpressionValue(string9, "getTextContent(...)");
                            NonBmpString nonBmpString = new NonBmpString(string9);
                            object.put(docId, nonBmpString);
                            break;
                        }
                        case "structure.xml": {
                            NodeList nodeList = doc.getElementsByTagName("span");
                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                            NodeList spans = nodeList;
                            if (((CharSequence)this.extractAttributesRegex).length() > 0) {
                                ((Map)this.extraFeatures).put(docId, this.extractMiscSpans(spans));
                            }
                            ((Map)this.sentences).put(docId, this.extractSentenceSpans(spans));
                            break;
                        }
                        case "tokens.xml": {
                            if (!this.fnames.contains(docId)) {
                                ((Map)this.fnames).put(docId, zipEntry.getName());
                            }
                            NodeList nodeList = doc.getElementsByTagName("span");
                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                            NodeList tokenSpans = nodeList;
                            ((Map)this.tokens).put(docId, this.extractSpans(tokenSpans));
                            break;
                        }
                        case "morpho.xml": {
                            waitForMorpho = true;
                            ((Map)this.fnames).put(docId, zipEntry.getName());
                            NodeList nodeList = doc.getElementsByTagName("span");
                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                            NodeList fsSpans = nodeList;
                            ((Map)this.morpho).put(docId, this.extractMorphoSpans(fsSpans));
                            ((Map)this.tokens).put(docId, this.extractSpans(fsSpans));
                        }
                    }
                    if (!(this.texts.get(docId) == null || this.sentences.get(docId) == null || this.tokens.get(docId) == null || waitForMorpho && this.morpho.get(docId) == null || !this.extractMetadataRegex.isEmpty() && this.metadata.get(docId) == null)) {
                        this.processText(docId, (String)foundry);
                    }
                    break block39;
                }
                if (!(!((Collection)this.extractMetadataRegex).isEmpty())) break block39;
                String string10 = zipEntry.getName();
                Intrinsics.checkNotNullExpressionValue(string10, "getName(...)");
                inputStream = string10;
                if (!new Regex(".*/header\\.xml$").matches((CharSequence)inputStream)) break block39;
                InputStream inputStream3 = zipFile.getInputStream(zipEntry);
                Intrinsics.checkNotNullExpressionValue(inputStream3, "getInputStream(...)");
                Closeable dbFactory = inputStream3;
                Object dBuilder = Charsets.UTF_8;
                Reader doc = new InputStreamReader((InputStream)dbFactory, (Charset)dBuilder);
                int docId = 8192;
                dbFactory = doc instanceof BufferedReader ? (BufferedReader)doc : new BufferedReader(doc, docId);
                dBuilder = null;
                try {
                    Object it = (BufferedReader)dbFactory;
                    boolean string42 = false;
                    it = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable it) {
                    dBuilder = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally(dbFactory, (Throwable)dBuilder);
                }
                Object text = it;
                dBuilder = Regex.find$default(new Regex("<textSigle>([^<]+)</textSigle>"), (CharSequence)text, 0, 2, null);
                if (dBuilder != null && (it = dBuilder.getDestructured()) != null && (string42 = ((MatchResult.Destructured)it).getMatch().getGroupValues().get(1)) != null) {
                    CharSequence fileName = string42;
                    Regex regex = new Regex("/");
                    String fsSpans = "_";
                    string = regex.replace(fileName, fsSpans);
                } else {
                    string = null;
                }
                String docId2 = string;
                this.LOGGER.info("Processing header file: " + zipEntry.getName() + " docId: " + docId2);
                ArrayList<String> meta = new ArrayList<String>();
                Iterable $this$forEach$iv = this.extractMetadataRegex;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String regex = (String)element$iv;
                    boolean bl = false;
                    MatchResult match = Regex.find$default(new Regex(regex), (CharSequence)text, 0, 2, null);
                    if (match == null) continue;
                    meta.add(match.getDestructured().getMatch().getGroupValues().get(1));
                }
                if (!((Collection)meta).isEmpty() && docId2 != null) {
                    Map map2 = this.metadata;
                    Collection $this$toTypedArray$iv = meta;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    map2.put(docId2, stringArray);
                    if (!(this.texts.get(docId2) == null || this.sentences.get(docId2) == null || this.tokens.get(docId2) == null || waitForMorpho && this.morpho.get(docId2) == null)) {
                        this.processText(docId2, (String)foundry);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processText(String docId, String foundry) {
        int n;
        Object $this$forEach$iv;
        StringBuilder output;
        block42: {
            int n2;
            int sentence_index;
            int real_token_index;
            int token_index;
            block38: {
                block39: {
                    token_index = 0;
                    real_token_index = 0;
                    sentence_index = 0;
                    output = null;
                    if (!this.lmTrainingData) break block38;
                    output = new StringBuilder();
                    if (!((Collection)this.extractMetadataRegex).isEmpty()) {
                        Object object = this.metadata.get(docId);
                        if (object == null || (object = ArraysKt.joinToString$default(object, (CharSequence)"\t", null, (CharSequence)"\t", 0, null, null, 58, null)) == null) {
                            object = "";
                        }
                        output.append((String)object);
                    }
                    Span[] spanArray = this.tokens.get(docId);
                    if (spanArray == null) break block39;
                    $this$forEach$iv = spanArray;
                    boolean $i$f$forEach = false;
                    n2 = ((Span[])$this$forEach$iv).length;
                    for (n = 0; n < n2; ++n) {
                        Span span;
                        block41: {
                            block40: {
                                Span element$iv;
                                span = element$iv = $this$forEach$iv[n];
                                boolean bl = false;
                                ++token_index;
                                Span[] spanArray2 = this.sentences.get(docId);
                                Intrinsics.checkNotNull(spanArray2);
                                if (sentence_index >= ((Object[])spanArray2).length) break block40;
                                int n3 = span.getFrom();
                                Span[] spanArray3 = this.sentences.get(docId);
                                Intrinsics.checkNotNull(spanArray3);
                                if (n3 < spanArray3[sentence_index].getTo()) break block41;
                            }
                            if (((CharSequence)output).length() > 0) {
                                output.setCharAt(output.length() - 1, '\n');
                            } else {
                                output.append("\n");
                            }
                            if (!((Collection)this.extractMetadataRegex).isEmpty()) {
                                Span[] spanArray4 = this.tokens.get(docId);
                                Intrinsics.checkNotNull(spanArray4);
                                if (real_token_index < ((Object[])spanArray4).length - 1) {
                                    Object object = this.metadata.get(docId);
                                    if (object == null || (object = ArraysKt.joinToString$default(object, (CharSequence)"\t", null, (CharSequence)"\t", 0, null, null, 58, null)) == null) {
                                        object = "";
                                    }
                                    output.append((String)object);
                                }
                            }
                            ++sentence_index;
                        }
                        String[] stringArray = new String[2];
                        NonBmpString nonBmpString = this.texts.get(docId);
                        Intrinsics.checkNotNull(nonBmpString);
                        stringArray[0] = ((Object)((CharSequence)nonBmpString).subSequence(span.getFrom(), span.getTo())).toString();
                        stringArray[1] = " ";
                        StringsKt.append(output, stringArray);
                        ++real_token_index;
                    }
                }
                if (((CharSequence)output).length() > 0) {
                    output.deleteCharAt(output.length() - 1);
                }
                break block42;
            }
            output = new StringBuilder("# foundry = " + foundry + "\n# filename = " + this.fnames.get(docId) + "\n# text_id = " + docId + "\n").append(this.tokenOffsetsInSentence(this.sentences, docId, sentence_index, real_token_index, this.tokens));
            if (!((Collection)this.extractMetadataRegex).isEmpty()) {
                Object object = this.metadata.get(docId);
                if (object == null || (object = ArraysKt.joinToString$default(object, (CharSequence)"\t", (CharSequence)"# metadata=", (CharSequence)"\n", 0, null, null, 56, null)) == null) {
                    object = "";
                }
                output.append((String)object);
            }
            int previousSpanStart = 0;
            if (this.taggerToolBridges.get(Thread.currentThread().getId()) != null) {
                Map map2 = this.morpho;
                TaggerToolBridge taggerToolBridge = this.taggerToolBridges.get(Thread.currentThread().getId());
                Intrinsics.checkNotNull(taggerToolBridge);
                Span[] spanArray = this.tokens.get(docId);
                Intrinsics.checkNotNull(spanArray);
                NonBmpString nonBmpString = this.texts.get(docId);
                Intrinsics.checkNotNull(nonBmpString);
                map2.put(docId, taggerToolBridge.tagText(spanArray, this.sentences.get(docId), nonBmpString));
                if (this.parserToolBridges.get(Thread.currentThread().getId()) != null) {
                    Map map3 = this.morpho;
                    ParserToolBridge parserToolBridge = this.parserToolBridges.get(Thread.currentThread().getId());
                    Intrinsics.checkNotNull(parserToolBridge);
                    Span[] spanArray5 = this.tokens.get(docId);
                    Intrinsics.checkNotNull(spanArray5);
                    NonBmpString nonBmpString2 = this.texts.get(docId);
                    Intrinsics.checkNotNull(nonBmpString2);
                    map3.put(docId, parserToolBridge.parseText(spanArray5, this.morpho.get(docId), this.sentences.get(docId), nonBmpString2));
                }
            }
            Span[] spanArray = this.tokens.get(docId);
            if (spanArray == null) break block42;
            Span[] $this$forEach$iv2 = spanArray;
            boolean $i$f$forEach = false;
            int element$iv = $this$forEach$iv2.length;
            for (n2 = 0; n2 < element$iv; ++n2) {
                Span span;
                block44: {
                    block43: {
                        Span element$iv2;
                        span = element$iv2 = $this$forEach$iv2[n2];
                        boolean bl = false;
                        ++token_index;
                        Span[] spanArray6 = this.sentences.get(docId);
                        Intrinsics.checkNotNull(spanArray6);
                        if (sentence_index >= ((Object[])spanArray6).length) break block43;
                        int n4 = span.getFrom();
                        Span[] spanArray7 = this.sentences.get(docId);
                        Intrinsics.checkNotNull(spanArray7);
                        if (n4 < spanArray7[sentence_index].getTo()) break block44;
                    }
                    output.append("\n");
                    token_index = 1;
                    output.append(this.tokenOffsetsInSentence(this.sentences, docId, ++sentence_index, real_token_index, this.tokens));
                }
                if (((CharSequence)this.extractAttributesRegex).length() > 0 && this.extraFeatures.get(docId) != null) {
                    int n5 = span.getFrom() + 1;
                    for (int i = previousSpanStart; i < n5; ++i) {
                        Map<String, String> map4 = this.extraFeatures.get(docId);
                        boolean bl = map4 != null ? map4.containsKey(String.valueOf(i)) : false;
                        if (!bl) continue;
                        Map<String, String> map5 = this.extraFeatures.get(docId);
                        Intrinsics.checkNotNull(map5);
                        output.append(map5.get(String.valueOf(i)));
                        Map<String, String> map6 = this.extraFeatures.get(docId);
                        Intrinsics.checkNotNull(map6);
                        map6.remove(String.valueOf(i));
                    }
                    previousSpanStart = span.getFrom() + 1;
                }
                Map<String, MorphoSpan> map7 = this.morpho.get(docId);
                boolean bl = map7 != null ? map7.containsKey(span.getFrom() + "-" + span.getTo()) : false;
                if (bl) {
                    Map<String, MorphoSpan> map8 = this.morpho.get(docId);
                    Intrinsics.checkNotNull(map8);
                    MorphoSpan mfs = map8.get(span.getFrom() + "-" + span.getTo());
                    int n6 = span.getTo();
                    NonBmpString nonBmpString = this.texts.get(docId);
                    Intrinsics.checkNotNull(nonBmpString);
                    if (n6 > nonBmpString.length()) {
                        NonBmpString nonBmpString3 = this.texts.get(docId);
                        Intrinsics.checkNotNull(nonBmpString3);
                        span.setTo(nonBmpString3.length());
                        int n7 = span.getFrom();
                        int n8 = span.getTo();
                        NonBmpString nonBmpString4 = this.texts.get(docId);
                        Intrinsics.checkNotNull(nonBmpString4);
                        this.LOGGER.warning("Offset error: could not retrieve token at " + n7 + "-" + n8 + " \u2013 ending with: " + ((Object)((CharSequence)nonBmpString4).subSequence(span.getFrom(), span.getTo())).toString());
                    }
                    NonBmpString nonBmpString5 = this.texts.get(docId);
                    Intrinsics.checkNotNull(nonBmpString5);
                    String string = ((Object)((CharSequence)nonBmpString5).subSequence(span.getFrom(), span.getTo())).toString();
                    MorphoSpan morphoSpan = mfs;
                    Intrinsics.checkNotNull(morphoSpan);
                    String string2 = morphoSpan.getLemma();
                    Intrinsics.checkNotNull(string2);
                    String string3 = mfs.getUpos();
                    Intrinsics.checkNotNull(string3);
                    String string4 = mfs.getXpos();
                    Intrinsics.checkNotNull(string4);
                    String string5 = mfs.getFeats();
                    Intrinsics.checkNotNull(string5);
                    String string6 = mfs.getHead();
                    Intrinsics.checkNotNull(string6);
                    String string7 = mfs.getDeprel();
                    Intrinsics.checkNotNull(string7);
                    String string8 = mfs.getDeps();
                    Intrinsics.checkNotNull(string8);
                    String string9 = mfs.getMisc();
                    Intrinsics.checkNotNull(string9);
                    v45 = output.append(this.printConlluToken(token_index, string, string2, string3, string4, string5, string6, string7, string8, string9, this.columns));
                } else {
                    NonBmpString nonBmpString = this.texts.get(docId);
                    Intrinsics.checkNotNull(nonBmpString);
                    v45 = output.append(KorapXml2Conllu.printConlluToken$default(this, token_index, ((Object)((CharSequence)nonBmpString).subSequence(span.getFrom(), span.getTo())).toString(), null, null, null, null, null, null, null, null, this.columns, 1020, null));
                }
                ++real_token_index;
            }
        }
        if (this.annotationWorkerPool != null) {
            AnnotationWorkerPool annotationWorkerPool = this.annotationWorkerPool;
            if (annotationWorkerPool != null) {
                String string = output.append("\n# eot\n").toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                annotationWorkerPool.pushToQueue(string);
            }
        } else {
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            $this$forEach$iv = printStream;
            synchronized ($this$forEach$iv) {
                boolean bl = false;
                System.out.println((Object)output.toString());
                Unit unit = Unit.INSTANCE;
            }
        }
        ConcurrentHashMap[] previousSpanStart = new ConcurrentHashMap[]{this.tokens, this.texts, this.sentences, this.morpho, this.fnames, this.metadata, this.extraFeatures};
        ConcurrentHashMap[] $this$forEach$iv3 = previousSpanStart;
        boolean $i$f$forEach = false;
        n = $this$forEach$iv3.length;
        for (int i = 0; i < n; ++i) {
            ConcurrentHashMap element$iv;
            ConcurrentHashMap map9 = element$iv = $this$forEach$iv3[i];
            boolean bl = false;
            map9.remove(docId);
        }
    }

    private final String printConlluToken(int token_index, String token2, String lemma, String upos, String xpos, String feats, String head, String deprel, String deps, String misc, int columns) {
        String myUpos = this.COMPATIBILITY_MODE && Intrinsics.areEqual(upos, "_") ? xpos : upos;
        return switch (columns) {
            case 1 -> token2 + "\n";
            case 10 -> token_index + "\t" + token2 + "\t" + lemma + "\t" + myUpos + "\t" + xpos + "\t" + feats + "\t" + head + "\t" + deprel + "\t" + deps + "\t" + misc + this.tokenSeparator;
            default -> {
                Object[] var13_13 = new Object[]{token_index, token2, lemma, myUpos, xpos, feats, head, deprel, deps, misc};
                yield CollectionsKt.joinToString$default(ArraysKt.slice(var13_13, RangesKt.until(0, Math.min(columns, 10))), "\t", null, this.tokenSeparator, 0, null, null, 58, null);
            }
        };
    }

    static /* synthetic */ String printConlluToken$default(KorapXml2Conllu korapXml2Conllu, int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            string2 = "_";
        }
        if ((n3 & 8) != 0) {
            string3 = "_";
        }
        if ((n3 & 0x10) != 0) {
            string4 = "_";
        }
        if ((n3 & 0x20) != 0) {
            string5 = "_";
        }
        if ((n3 & 0x40) != 0) {
            string6 = "_";
        }
        if ((n3 & 0x80) != 0) {
            string7 = "_";
        }
        if ((n3 & 0x100) != 0) {
            string8 = "_";
        }
        if ((n3 & 0x200) != 0) {
            string9 = "_";
        }
        if ((n3 & 0x400) != 0) {
            n2 = 10;
        }
        return korapXml2Conllu.printConlluToken(n, string, string2, string3, string4, string5, string6, string7, string8, string9, n2);
    }

    private final String tokenOffsetsInSentence(ConcurrentHashMap<String, Span[]> sentences, String docId, int sentence_index, int token_index, ConcurrentHashMap<String, Span[]> tokens) {
        block4: {
            block3: {
                if (sentences.get(docId) == null) break block3;
                Span[] spanArray = sentences.get(docId);
                Intrinsics.checkNotNull(spanArray);
                if (((Object[])spanArray).length > sentence_index) break block4;
            }
            return "";
        }
        Span[] spanArray = sentences.get(docId);
        Intrinsics.checkNotNull(spanArray);
        int sentenceEndOffset = spanArray[sentence_index].getTo();
        int i = token_index;
        StringBuilder start_offsets_string = new StringBuilder();
        StringBuilder end_offsets_string = new StringBuilder();
        while (tokens.get(docId) != null) {
            Span[] spanArray2 = tokens.get(docId);
            Intrinsics.checkNotNull(spanArray2);
            if (i >= ((Object[])spanArray2).length) break;
            Span[] spanArray3 = tokens.get(docId);
            Intrinsics.checkNotNull(spanArray3);
            if (spanArray3[i].getTo() > sentenceEndOffset) break;
            Object[] objectArray = new Object[2];
            objectArray[0] = " ";
            Span[] spanArray4 = tokens.get(docId);
            Intrinsics.checkNotNull(spanArray4);
            objectArray[1] = spanArray4[i].getFrom();
            StringsKt.append(start_offsets_string, objectArray);
            objectArray = new Object[2];
            objectArray[0] = " ";
            Span[] spanArray5 = tokens.get(docId);
            Intrinsics.checkNotNull(spanArray5);
            objectArray[1] = spanArray5[i].getTo();
            StringsKt.append(end_offsets_string, objectArray);
            ++i;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = new Object[8];
        objectArray[0] = "# start_offsets = ";
        Span[] spanArray6 = tokens.get(docId);
        Intrinsics.checkNotNull(spanArray6);
        objectArray[1] = spanArray6[token_index].getFrom();
        objectArray[2] = start_offsets_string;
        objectArray[3] = "\n";
        objectArray[4] = "# end_offsets = ";
        objectArray[5] = sentenceEndOffset;
        objectArray[6] = end_offsets_string;
        objectArray[7] = "\n";
        String string = StringsKt.append(stringBuilder, objectArray).toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final Span[] extractSpans(NodeList spans) {
        A[] AArray = IntStream.range(0, spans.getLength()).mapToObj(spans::item).filter(arg_0 -> KorapXml2Conllu.extractSpans$lambda$29(KorapXml2Conllu::extractSpans$lambda$28, arg_0)).map(arg_0 -> KorapXml2Conllu.extractSpans$lambda$31(KorapXml2Conllu::extractSpans$lambda$30, arg_0)).toArray(KorapXml2Conllu::extractSpans$lambda$32);
        Intrinsics.checkNotNullExpressionValue(AArray, "toArray(...)");
        return (Span[])AArray;
    }

    private final Map<String, MorphoSpan> extractMorphoSpans(NodeList fsSpans) {
        Regex UNKNOWN = new Regex("(UNKNOWN|<unknown>)");
        Map res = new HashMap();
        IntStream.range(0, fsSpans.getLength()).mapToObj(fsSpans::item).filter(arg_0 -> KorapXml2Conllu.extractMorphoSpans$lambda$34(KorapXml2Conllu::extractMorphoSpans$lambda$33, arg_0)).forEach(arg_0 -> KorapXml2Conllu.extractMorphoSpans$lambda$38(arg_0 -> KorapXml2Conllu.extractMorphoSpans$lambda$37(res, UNKNOWN, arg_0), arg_0));
        return res;
    }

    private final Span[] extractSentenceSpans(NodeList spans) {
        A[] AArray = IntStream.range(0, spans.getLength()).mapToObj(spans::item).filter(arg_0 -> KorapXml2Conllu.extractSentenceSpans$lambda$40(KorapXml2Conllu::extractSentenceSpans$lambda$39, arg_0)).map(arg_0 -> KorapXml2Conllu.extractSentenceSpans$lambda$42(KorapXml2Conllu::extractSentenceSpans$lambda$41, arg_0)).toArray(KorapXml2Conllu::extractSentenceSpans$lambda$43);
        Intrinsics.checkNotNullExpressionValue(AArray, "toArray(...)");
        return (Span[])AArray;
    }

    private final Map<String, String> extractMiscSpans(NodeList spans) {
        Map miscLocal = new HashMap();
        IntStream.range(0, spans.getLength()).mapToObj(spans::item).filter(arg_0 -> KorapXml2Conllu.extractMiscSpans$lambda$45(KorapXml2Conllu::extractMiscSpans$lambda$44, arg_0)).forEach(arg_0 -> KorapXml2Conllu.extractMiscSpans$lambda$49(arg_0 -> KorapXml2Conllu.extractMiscSpans$lambda$48(miscLocal, this, arg_0), arg_0));
        return miscLocal;
    }

    private static final Unit korapxml2conllu$lambda$0(KorapXml2Conllu this$0, Ref.ObjectRef $zips, String zipFilePath) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($zips, "$zips");
        String string = zipFilePath;
        if (string == null) {
            string = "";
        }
        this$0.processZipFile(string.toString(), this$0.getFoundryFromZipFileNames((String[])$zips.element));
        return Unit.INSTANCE;
    }

    private static final void korapxml2conllu$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit korapxml2conllu$lambda$2(KorapXml2Conllu this$0, Ref.ObjectRef $zips, String zipFilePath) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($zips, "$zips");
        String string = zipFilePath;
        if (string == null) {
            string = "";
        }
        this$0.processZipFileSequentially(string.toString(), this$0.getFoundryFromZipFileNames((String[])$zips.element));
        return Unit.INSTANCE;
    }

    private static final void korapxml2conllu$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean processZipFile$lambda$9$lambda$8$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void processZipFile$lambda$9$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit processZipFile$lambda$9(KorapXml2Conllu this$0, String $foundry, String zip2) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($foundry, "$foundry");
        Closeable closeable = new ZipFile(zip2);
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            ((Stream)zipFile.stream().filter(arg_0 -> KorapXml2Conllu.processZipFile$lambda$9$lambda$8$lambda$6(new Function1(this$0){
                final /* synthetic */ KorapXml2Conllu this$0;
                {
                    this.this$0 = $receiver;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final Boolean invoke(ZipEntry it) {
                    boolean bl;
                    if (!(!((Collection)this.this$0.getExtractMetadataRegex()).isEmpty())) {
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                        if (StringsKt.contains$default((CharSequence)string, "header.xml", false, 2, null)) {
                            bl = false;
                            return bl;
                        }
                    }
                    bl = true;
                    return bl;
                }
            }, arg_0)).parallel()).forEach(arg_0 -> KorapXml2Conllu.processZipFile$lambda$9$lambda$8$lambda$7(new Function1(this$0, zipFile, $foundry){
                final /* synthetic */ KorapXml2Conllu this$0;
                final /* synthetic */ ZipFile $zipFile;
                final /* synthetic */ String $foundry;
                {
                    this.this$0 = $receiver;
                    this.$zipFile = $zipFile;
                    this.$foundry = $foundry;
                }

                public final void invoke(ZipEntry zipEntry) {
                    Intrinsics.checkNotNull(zipEntry);
                    this.this$0.processZipEntry(this.$zipFile, this.$foundry, zipEntry, true);
                }
            }, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return Unit.INSTANCE;
    }

    private static final void processZipFile$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean processZipFile$lambda$13$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void processZipFile$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean processZipFileSequentially$lambda$17$lambda$16$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void processZipFileSequentially$lambda$17$lambda$16$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit processZipFileSequentially$lambda$17(KorapXml2Conllu this$0, String $foundry, String zip2) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($foundry, "$foundry");
        Closeable closeable = new ZipFile(zip2);
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            ((Stream)zipFile.stream().filter(arg_0 -> KorapXml2Conllu.processZipFileSequentially$lambda$17$lambda$16$lambda$14(new Function1(this$0){
                final /* synthetic */ KorapXml2Conllu this$0;
                {
                    this.this$0 = $receiver;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final Boolean invoke(ZipEntry it) {
                    boolean bl;
                    if (!(!((Collection)this.this$0.getExtractMetadataRegex()).isEmpty())) {
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                        if (StringsKt.contains$default((CharSequence)string, "header.xml", false, 2, null)) {
                            bl = false;
                            return bl;
                        }
                    }
                    bl = true;
                    return bl;
                }
            }, arg_0)).parallel()).forEach(arg_0 -> KorapXml2Conllu.processZipFileSequentially$lambda$17$lambda$16$lambda$15(new Function1(this$0, zipFile, $foundry){
                final /* synthetic */ KorapXml2Conllu this$0;
                final /* synthetic */ ZipFile $zipFile;
                final /* synthetic */ String $foundry;
                {
                    this.this$0 = $receiver;
                    this.$zipFile = $zipFile;
                    this.$foundry = $foundry;
                }

                public final void invoke(ZipEntry zipEntry) {
                    Intrinsics.checkNotNull(zipEntry);
                    this.this$0.processZipEntry(this.$zipFile, this.$foundry, zipEntry, true);
                }
            }, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return Unit.INSTANCE;
    }

    private static final void processZipFileSequentially$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean processZipFileSequentially$lambda$21$lambda$19(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void processZipFileSequentially$lambda$21$lambda$20(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean extractSpans$lambda$28(Node node) {
        return node instanceof Element;
    }

    private static final boolean extractSpans$lambda$29(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Span extractSpans$lambda$30(Node node) {
        Intrinsics.checkNotNull(node, "null cannot be cast to non-null type org.w3c.dom.Element");
        return new Span(Integer.parseInt(((Element)node).getAttribute("from")), Integer.parseInt(((Element)node).getAttribute("to")));
    }

    private static final Span extractSpans$lambda$31(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Span)$tmp0.invoke(p0);
    }

    private static final Span[] extractSpans$lambda$32(int size) {
        return new Span[size];
    }

    private static final boolean extractMorphoSpans$lambda$33(Node node) {
        return node instanceof Element && !Intrinsics.areEqual(((Element)node).getAttribute("type"), "alt");
    }

    private static final boolean extractMorphoSpans$lambda$34(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit extractMorphoSpans$lambda$37$lambda$35(MorphoSpan $fs, Regex $UNKNOWN, Node feature) {
        block29: {
            Intrinsics.checkNotNullParameter($fs, "$fs");
            Intrinsics.checkNotNullParameter($UNKNOWN, "$UNKNOWN");
            Intrinsics.checkNotNull(feature, "null cannot be cast to non-null type org.w3c.dom.Element");
            String attr = ((Element)feature).getAttribute("name");
            String string = ((Element)feature).getTextContent();
            Intrinsics.checkNotNullExpressionValue(string, "getTextContent(...)");
            String value = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)value).length() == 0) {
                return Unit.INSTANCE;
            }
            String string2 = attr;
            if (string2 == null) break block29;
            int n = -1;
            switch (string2.hashCode()) {
                case 3686108: {
                    if (string2.equals("xpos")) {
                        n = 1;
                    }
                    break;
                }
                case 111188: {
                    if (string2.equals("pos")) {
                        n = 1;
                    }
                    break;
                }
                case 102857384: {
                    if (string2.equals("lemma")) {
                        n = 2;
                    }
                    break;
                }
                case 3596735: {
                    if (string2.equals("upos")) {
                        n = 3;
                    }
                    break;
                }
                case 3063895: {
                    if (string2.equals("ctag")) {
                        n = 1;
                    }
                    break;
                }
                case -1404142937: {
                    if (string2.equals("certainty")) {
                        n = 4;
                    }
                    break;
                }
                case 3575610: {
                    if (string2.equals("type")) {
                        n = 5;
                    }
                    break;
                }
                case 97304961: {
                    if (string2.equals("feats")) {
                        n = 6;
                    }
                    break;
                }
                case 108414: {
                    if (string2.equals("msd")) {
                        n = 6;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    if (!Intrinsics.areEqual($fs.getLemma(), "_")) break;
                    CharSequence charSequence = value;
                    String string3 = "--";
                    $fs.setLemma($UNKNOWN.replace(charSequence, string3));
                    break;
                }
                case 3: {
                    $fs.setUpos(value);
                    break;
                }
                case 1: {
                    if (!Intrinsics.areEqual($fs.getXpos(), "_")) break;
                    CharSequence charSequence = value;
                    String string4 = "--";
                    $fs.setXpos($UNKNOWN.replace(charSequence, string4));
                    break;
                }
                case 6: {
                    if (!Intrinsics.areEqual($fs.getFeats(), "_")) break;
                    $fs.setFeats(value);
                    break;
                }
                case 5: {
                    if (!Intrinsics.areEqual($fs.getFeats(), "_")) break;
                    String string5 = ((Element)feature).getElementsByTagName("symbol").item(0).getAttributes().getNamedItem("value").getTextContent();
                    Intrinsics.checkNotNullExpressionValue(string5, "getTextContent(...)");
                    $fs.setFeats(((Object)StringsKt.trim((CharSequence)string5)).toString());
                    break;
                }
                case 4: {
                    if (!Intrinsics.areEqual($fs.getMisc(), "_")) break;
                    $fs.setMisc(value);
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final void extractMorphoSpans$lambda$37$lambda$36(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit extractMorphoSpans$lambda$37(Map $res, Regex $UNKNOWN, Node node) {
        Intrinsics.checkNotNullParameter($res, "$res");
        Intrinsics.checkNotNullParameter($UNKNOWN, "$UNKNOWN");
        Intrinsics.checkNotNull(node, "null cannot be cast to non-null type org.w3c.dom.Element");
        NodeList features = ((Element)node).getElementsByTagName("f");
        MorphoSpan fs = new MorphoSpan(null, null, null, null, null, null, null, null, 255, null);
        String fromTo = ((Element)node).getAttribute("from") + "-" + ((Element)node).getAttribute("to");
        IntStream.range(0, features.getLength()).mapToObj(features::item).forEach(arg_0 -> KorapXml2Conllu.extractMorphoSpans$lambda$37$lambda$36(arg_0 -> KorapXml2Conllu.extractMorphoSpans$lambda$37$lambda$35(fs, $UNKNOWN, arg_0), arg_0));
        $res.put(fromTo, fs);
        return Unit.INSTANCE;
    }

    private static final void extractMorphoSpans$lambda$38(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean extractSentenceSpans$lambda$39(Node node) {
        return node instanceof Element && ((Element)node).getElementsByTagName("f").item(0).getTextContent().equals("s");
    }

    private static final boolean extractSentenceSpans$lambda$40(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Span extractSentenceSpans$lambda$41(Node node) {
        Intrinsics.checkNotNull(node, "null cannot be cast to non-null type org.w3c.dom.Element");
        return new Span(Integer.parseInt(((Element)node).getAttribute("from")), Integer.parseInt(((Element)node).getAttribute("to")));
    }

    private static final Span extractSentenceSpans$lambda$42(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Span)$tmp0.invoke(p0);
    }

    private static final Span[] extractSentenceSpans$lambda$43(int size) {
        return new Span[size];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean extractMiscSpans$lambda$44(Node node) {
        if (!(node instanceof Element)) return false;
        if (((Element)node).getElementsByTagName("f").getLength() <= 1) return false;
        Node node2 = ((Element)node).getElementsByTagName("f").item(0);
        Intrinsics.checkNotNull(node2, "null cannot be cast to non-null type org.w3c.dom.Element");
        if (!((Element)node2).getAttribute("name").equals("name")) return false;
        Node node3 = ((Element)node).getElementsByTagName("f").item(1);
        Intrinsics.checkNotNull(node3, "null cannot be cast to non-null type org.w3c.dom.Element");
        if (!((Element)node3).getAttribute("name").equals("attr")) return false;
        return true;
    }

    private static final boolean extractMiscSpans$lambda$45(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit extractMiscSpans$lambda$48$lambda$46(String $elementName, KorapXml2Conllu this$0, StringBuilder $res, Node attr) {
        Intrinsics.checkNotNullParameter($elementName, "$elementName");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($res, "$res");
        Intrinsics.checkNotNull(attr, "null cannot be cast to non-null type org.w3c.dom.Element");
        String attrName = $elementName + "/" + ((Element)attr).getAttribute("name");
        CharSequence charSequence = attrName;
        if (new Regex(this$0.extractAttributesRegex).matches(charSequence)) {
            $res.append("# " + attrName + " = " + ((Element)attr).getTextContent() + "\n");
        }
        return Unit.INSTANCE;
    }

    private static final void extractMiscSpans$lambda$48$lambda$47(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit extractMiscSpans$lambda$48(Map $miscLocal, KorapXml2Conllu this$0, Node node) {
        Intrinsics.checkNotNullParameter($miscLocal, "$miscLocal");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (node == null) {
            return Unit.INSTANCE;
        }
        String string = ((Element)node).getElementsByTagName("f").item(0).getTextContent();
        Intrinsics.checkNotNullExpressionValue(string, "getTextContent(...)");
        String elementName = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String from = ((Element)node).getAttribute("from");
        Node node2 = ((Element)node).getElementsByTagName("f").item(1);
        Intrinsics.checkNotNull(node2, "null cannot be cast to non-null type org.w3c.dom.Element");
        NodeList attributes = ((Element)node2).getElementsByTagName("f");
        StringBuilder res = new StringBuilder();
        IntStream.range(0, attributes.getLength()).mapToObj(attributes::item).forEach(arg_0 -> KorapXml2Conllu.extractMiscSpans$lambda$48$lambda$47(arg_0 -> KorapXml2Conllu.extractMiscSpans$lambda$48$lambda$46(elementName, this$0, res, arg_0), arg_0));
        if (((CharSequence)res).length() > 0) {
            if ($miscLocal.containsKey(from)) {
                $miscLocal.put(from, "" + $miscLocal.get(from) + res);
            } else {
                $miscLocal.put(from, res.toString());
            }
        }
        return Unit.INSTANCE;
    }

    private static final void extractMiscSpans$lambda$49(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001c\u0018\u00002\u00020\u0001Bg\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000b\u0010\fR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lde/ids_mannheim/korapxmltools/KorapXml2Conllu$MorphoSpan;", "", "lemma", "", "upos", "xpos", "feats", "head", "deprel", "deps", "misc", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLemma", "()Ljava/lang/String;", "setLemma", "(Ljava/lang/String;)V", "getUpos", "setUpos", "getXpos", "setXpos", "getFeats", "setFeats", "getHead", "setHead", "getDeprel", "setDeprel", "getDeps", "setDeps", "getMisc", "setMisc", "app"})
    public static final class MorphoSpan {
        @Nullable
        private String lemma;
        @Nullable
        private String upos;
        @Nullable
        private String xpos;
        @Nullable
        private String feats;
        @Nullable
        private String head;
        @Nullable
        private String deprel;
        @Nullable
        private String deps;
        @Nullable
        private String misc;

        public MorphoSpan(@Nullable String lemma, @Nullable String upos, @Nullable String xpos, @Nullable String feats, @Nullable String head, @Nullable String deprel, @Nullable String deps, @Nullable String misc) {
            this.lemma = lemma;
            this.upos = upos;
            this.xpos = xpos;
            this.feats = feats;
            this.head = head;
            this.deprel = deprel;
            this.deps = deps;
            this.misc = misc;
        }

        public /* synthetic */ MorphoSpan(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "_";
            }
            if ((n & 2) != 0) {
                string2 = "_";
            }
            if ((n & 4) != 0) {
                string3 = "_";
            }
            if ((n & 8) != 0) {
                string4 = "_";
            }
            if ((n & 0x10) != 0) {
                string5 = "_";
            }
            if ((n & 0x20) != 0) {
                string6 = "_";
            }
            if ((n & 0x40) != 0) {
                string7 = "_";
            }
            if ((n & 0x80) != 0) {
                string8 = "_";
            }
            this(string, string2, string3, string4, string5, string6, string7, string8);
        }

        @Nullable
        public final String getLemma() {
            return this.lemma;
        }

        public final void setLemma(@Nullable String string) {
            this.lemma = string;
        }

        @Nullable
        public final String getUpos() {
            return this.upos;
        }

        public final void setUpos(@Nullable String string) {
            this.upos = string;
        }

        @Nullable
        public final String getXpos() {
            return this.xpos;
        }

        public final void setXpos(@Nullable String string) {
            this.xpos = string;
        }

        @Nullable
        public final String getFeats() {
            return this.feats;
        }

        public final void setFeats(@Nullable String string) {
            this.feats = string;
        }

        @Nullable
        public final String getHead() {
            return this.head;
        }

        public final void setHead(@Nullable String string) {
            this.head = string;
        }

        @Nullable
        public final String getDeprel() {
            return this.deprel;
        }

        public final void setDeprel(@Nullable String string) {
            this.deprel = string;
        }

        @Nullable
        public final String getDeps() {
            return this.deps;
        }

        public final void setDeps(@Nullable String string) {
            this.deps = string;
        }

        @Nullable
        public final String getMisc() {
            return this.misc;
        }

        public final void setMisc(@Nullable String string) {
            this.misc = string;
        }

        public MorphoSpan() {
            this(null, null, null, null, null, null, null, null, 255, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lde/ids_mannheim/korapxmltools/KorapXml2Conllu$Span;", "", "from", "", "to", "<init>", "(II)V", "getFrom", "()I", "setFrom", "(I)V", "getTo", "setTo", "app"})
    public static final class Span {
        private int from;
        private int to;

        public Span(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public final int getFrom() {
            return this.from;
        }

        public final void setFrom(int n) {
            this.from = n;
        }

        public final int getTo() {
            return this.to;
        }

        public final void setTo(int n) {
            this.to = n;
        }
    }
}

