/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.BooleanFnStreamer;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.feed.NoOpenFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.value.BooleanValue;

public class ChooseAdjunct
extends TransmissionAdjunct {
    int consumingCondition = -2;
    Inversion invertedCondition;
    Inversion[] actionInversions;

    @Override
    public void setExpression(Expression expression) {
        super.setExpression(expression);
        this.actionInversions = new Inversion[((Choose)this.getExpression()).size()];
    }

    private int getConsumingCondition() throws XPathException {
        if (this.consumingCondition == -2) {
            this.consumingCondition = -1;
            int cond = 0;
            for (Operand o : ((Choose)this.getExpression()).conditions()) {
                if (Streamability.getSweep(o.getChildExpression()) == Sweep.CONSUMING) {
                    this.consumingCondition = cond;
                    this.invertedCondition = Inversion.invertExpression(o.getChildExpression(), false);
                    break;
                }
                ++cond;
            }
        }
        return this.consumingCondition;
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Choose exp = (Choose)this.getExpression();
        if (this.getConsumingCondition() < 0) {
            return (watchManager, out, context) -> {
                out.open(new Terminator());
                out = new NoOpenFeed(out, context);
                for (int i = 0; i < exp.size(); ++i) {
                    if (!exp.getCondition(i).effectiveBooleanValue(context)) continue;
                    Expression action = exp.getAction(i);
                    if (Streamability.getSweep(action) == Sweep.CONSUMING) {
                        Inversion actionInversion = this.actionInversions[i];
                        if (actionInversion == null) {
                            this.actionInversions[i] = actionInversion = Inversion.invertExpression(action, forGrouping);
                        }
                        return actionInversion.getWatch(watchManager, out, context);
                    }
                    action.iterate(context).forEachOrFail(out::processItem);
                    break;
                }
                return new Trigger(new NodeTestPattern(ErrorType.getInstance()), new ItemFeed(out, context){

                    @Override
                    public void processItem(Item<?> item) {
                    }
                }, context);
            };
        }
        return null;
    }

    @Override
    public Trigger makeTransmissionFlow(WatchManager watchManager, Expression exp, Feed out, XPathContext context) throws XPathException {
        WatchMaker wm = this.getWatchMaker(false);
        if (wm != null) {
            return wm.makeWatch(watchManager, out, context);
        }
        throw new XPathException("Choose expression too complex for streaming", "XTSE3430");
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return this.getFeedMaker(-1).makeItemFeed(watchManager, out, context);
    }

    @Override
    public FeedMaker getFeedMaker(int arg) throws XPathException {
        if (this.getConsumingCondition() < 0) {
            throw new XPathException("Streaming xsl:choose: expecting a watch");
        }
        return new FeedMakerForConsumingCondition();
    }

    private class FeedMakerForConsumingCondition
    implements FeedMaker {
        final Choose exp;

        private FeedMakerForConsumingCondition() {
            this.exp = (Choose)ChooseAdjunct.this.getExpression();
        }

        @Override
        public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
            ItemFeed action = new ItemFeed(ChooseAdjunct.this.getExpression(), out, context){
                private boolean matched;
                {
                    this.matched = false;
                }

                @Override
                public void open(Terminator terminator) throws XPathException {
                    super.open(terminator);
                    for (int i = 0; i < ChooseAdjunct.this.consumingCondition; ++i) {
                        boolean truth = FeedMakerForConsumingCondition.this.exp.getCondition(i).effectiveBooleanValue(this.getContext());
                        if (!truth) continue;
                        SequenceIterator<?> iter = FeedMakerForConsumingCondition.this.exp.getAction(i).iterate(this.getContext());
                        1.processItems(iter, this.getResult());
                        this.matched = true;
                        break;
                    }
                }

                @Override
                public void processItem(Item<?> item) throws XPathException {
                    boolean truth = ((BooleanValue)item).getBooleanValue();
                    Expression selectedAction = null;
                    if (!this.matched) {
                        if (truth) {
                            selectedAction = FeedMakerForConsumingCondition.this.exp.getAction(ChooseAdjunct.this.consumingCondition);
                        } else {
                            for (int i = 1; i < FeedMakerForConsumingCondition.this.exp.size(); ++i) {
                                if (!FeedMakerForConsumingCondition.this.exp.getCondition(i).effectiveBooleanValue(this.getContext())) continue;
                                selectedAction = FeedMakerForConsumingCondition.this.exp.getAction(i);
                                break;
                            }
                        }
                    }
                    if (selectedAction != null) {
                        SequenceIterator<?> iter = selectedAction.iterate(this.getContext());
                        1.processItems(iter, this.getResult());
                    }
                }
            };
            return new BooleanFnStreamer.BooleanFnFeed(ChooseAdjunct.this.getExpression(), action, context);
        }
    }
}

