/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AllModelGroup;
import com.saxonica.ee.schema.MissingComponentExceptionImpl;
import com.saxonica.ee.schema.ModelGroup;
import com.saxonica.ee.schema.ModelGroupDefinition;
import com.saxonica.ee.schema.Particle;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.Term;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.z.IntHashSet;

public class ModelGroupParticle
extends Particle {
    public ModelGroupParticle(EnterpriseConfiguration config, SourceLocator locator) {
        this.setLocator(locator);
        this.setConfiguration(config);
    }

    @Override
    public boolean isResolved() {
        return this.target != null;
    }

    public ModelGroup getGroup() throws MissingComponentException {
        return (ModelGroup)this.getTarget();
    }

    @Override
    public int getSymbolSpace() {
        return 804;
    }

    @Override
    public boolean isEmptiable() throws MissingComponentException {
        return this.getMinOccurs() == 0 || this.getGroup().isEmptiable();
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        SchemaComponent decl = PreparedSchema.validateReference(this, compiler, false);
        if (decl == null) {
            this.setFixupStatus(SchemaComponent.ValidationStatus.INVALID);
            return false;
        }
        this.lookForCycles(new Stack(), compiler);
        this.setFixupStatus(SchemaComponent.ValidationStatus.VALIDATED);
        return true;
    }

    @Override
    public void lookForCycles(Stack references, SchemaCompiler compiler) throws SchemaException, MissingComponentException {
        if (references.contains(this)) {
            String err = "The definition of group " + Err.wrap(this.getTargetComponentName().getDisplayName()) + " is circular";
            throw new SchemaException(err);
        }
        this.tryToResolve(compiler);
        if (this.isResolved()) {
            this.getGroup().lookForCycles(references, compiler);
        }
    }

    @Override
    public SchemaComponent getTarget() throws MissingComponentException {
        if (this.target == null) {
            throw new MissingComponentExceptionImpl(this);
        }
        return this.target;
    }

    @Override
    public void tryToResolve(SchemaCompiler compiler) {
        if (this.target == null) {
            this.target = compiler.getPreparedSchema().getGroup(this.getTargetComponentName());
        }
        if (this.target == null) {
            this.target = compiler.getConfiguration().getSuperSchema().getGroup(this.getTargetComponentName());
        }
    }

    @Override
    public boolean isPointless(ModelGroup container) throws MissingComponentException {
        return this.getMinOccurs() == 1 && this.getMaxOccurs() == 1 && ((ModelGroup)this.getTarget()).isPointless(container);
    }

    @Override
    public SchemaType getElementParticleType(int elementName) throws MissingComponentException {
        return this.getGroup().getElementParticleType(elementName);
    }

    @Override
    public int getElementParticleCardinality(int elementName) throws MissingComponentException {
        int card = this.getGroup().getElementParticleCardinality(elementName);
        return Cardinality.multiply(card, ModelGroupParticle.computeParticleCardinality(this.getMinOccurs(), this.getMaxOccurs()));
    }

    @Override
    public boolean containsElementWildcard() throws MissingComponentException {
        return this.getGroup().containsElementWildcard();
    }

    @Override
    public void gatherAllPermittedElements(IntHashSet result, boolean ignoreWildcards) throws SchemaException {
        this.getGroup().gatherAllPermittedElements(result, ignoreWildcards);
    }

    @Override
    public void markVulnerableSubParticles() throws MissingComponentException {
        this.getGroup().markVulnerableSubParticles(this.getMaxOccurs() > 1 || this.getMaxOccurs() == -1);
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        switch (this.getValidationStatus()) {
            case VALIDATED: {
                return true;
            }
            case INVALID: {
                return false;
            }
            case VALIDATING: {
                return false;
            }
        }
        ModelGroup decl = (ModelGroup)PreparedSchema.validateReference(this, compiler, false);
        if (this.isResolved()) {
            Particle first;
            List<Particle> particles;
            boolean result = decl.validate(compiler);
            if (result && (this.getMaxOccurs() == -1 || this.getMaxOccurs() > 1) && !(particles = decl.getParticles()).isEmpty() && (first = particles.get(0)) instanceof ModelGroupParticle && first.getTerm() instanceof AllModelGroup) {
                compiler.error("A group defined using <xs:all> cannot occur more than once", this);
                result = false;
            }
            if (this.getMaxOccurs() > 1 || this.getMaxOccurs() == -1) {
                decl.markVulnerableSubParticles(true);
            }
            return result;
        }
        this.setValidationStatus(SchemaComponent.ValidationStatus.INVALID);
        return false;
    }

    @Override
    public void compile(SchemaCompiler compiler) throws SchemaException {
        ((ModelGroup)this.getTarget()).compile(compiler);
    }

    @Override
    public Term getTerm() throws MissingComponentException {
        return this.getGroup();
    }

    @Override
    public void elaborate(SchemaCompiler compiler) throws SchemaException {
        this.getGroup().elaborate(compiler);
    }

    @Override
    public void serializeParticle(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("modelGroupParticle");
        serializer.emitAttribute("minOccurs", "" + this.getMinOccurs());
        serializer.emitAttribute("maxOccurs", this.getMaxOccurs() < 0 ? "unbounded" : "" + this.getMaxOccurs());
        if (this.getGroup() instanceof ModelGroupDefinition) {
            serializer.emitAttribute("ref", serializer.getId(this.getGroup(), false));
        } else {
            this.getGroup().serialize(serializer);
        }
        serializer.endElement();
    }
}

