/*
 * Decompiled with CFR 0.152.
 */
package experimental.ising;

import java.util.Map;

public abstract class Measure {
    private Map<Integer, String> int2String;
    protected double[] measure;
    protected int size;

    public Measure(int size) {
        this.setSize(size);
        this.measure = new double[this.size];
        for (int n = 0; n < this.size; ++n) {
            this.measure[n] = 1.0;
        }
    }

    public void renormalize() {
        double Z = 0.0;
        for (double v : this.measure) {
            Z += v;
        }
        int i = 0;
        while (i < this.measure.length) {
            int n = i++;
            this.measure[n] = this.measure[n] / Z;
        }
    }

    public void toZeros() {
        for (int i = 0; i < this.size; ++i) {
            this.measure[i] = 0.0;
        }
    }

    public void toOnes() {
        for (int i = 0; i < this.size; ++i) {
            this.measure[i] = 1.0;
        }
    }

    public Map<Integer, String> getInt2String() {
        return this.int2String;
    }

    public void setInt2String(Map<Integer, String> int2String) {
        this.int2String = int2String;
    }

    public double[] getMeasure() {
        return this.measure;
    }

    public void setMeasure(double[] measure) {
        this.measure = measure;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

