/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.tokenizer.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import marmot.tokenize.preprocess.InternalReader;
import marmot.tokenize.preprocess.Pair;
import marmot.tokenize.preprocess.WikiReader;
import org.junit.Assert;
import org.junit.Test;

public class WikiReaderTest {
    @Test
    public void simpleTest() {
        FakeReader a = new FakeReader();
        a.add("abc");
        FakeReader b = new FakeReader();
        b.add("ab");
        b.add("c");
        List<Pair> expected = Arrays.asList(new Pair("abc", "abc"));
        this.bothWayTest(a, b, expected);
    }

    @Test
    public void test() {
        FakeReader a = new FakeReader();
        a.add("a");
        a.add("");
        a.add("bcd");
        FakeReader b = new FakeReader();
        b.add("abc");
        a.add("");
        a.add("");
        b.add("d");
        a.add("");
        List<Pair> expected = Arrays.asList(new Pair("abcd", "abcd"));
        this.bothWayTest(a, b, expected);
    }

    private void bothWayTest(FakeReader a, FakeReader b, List<Pair> expected) {
        WikiReader reader = new WikiReader(a, b, true);
        List<Pair> actual = reader.readAll();
        Assert.assertEquals(expected, actual);
        a.fullReset();
        b.fullReset();
        reader = new WikiReader(b, a, true);
        actual = reader.readAll();
        Assert.assertEquals(expected, actual);
    }

    class FakeReader
    implements InternalReader {
        int current_pos_;
        int current_mark_;
        List<String> content_ = new ArrayList<String>();

        FakeReader() {
        }

        @Override
        public void mark() {
            this.current_mark_ = this.current_pos_;
        }

        @Override
        public void reset() {
            this.current_pos_ = this.current_mark_;
        }

        @Override
        public String readLine() {
            if (this.current_pos_ >= this.content_.size()) {
                return null;
            }
            String line = this.content_.get(this.current_pos_);
            ++this.current_pos_;
            return line;
        }

        public void add(String line) {
            this.content_.add(line);
        }

        public void fullReset() {
            this.current_pos_ = 0;
            this.current_mark_ = 0;
        }
    }
}

