/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SuffixTrie
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Character c_;
    private Map<Character, SuffixTrie> child_map_;
    private Map<String, Integer> tag_map_;
    private Integer total_count_;
    private Double entropy_;

    public SuffixTrie(Character c) {
        this.c_ = c;
        this.child_map_ = new TreeMap<Character, SuffixTrie>();
        this.tag_map_ = new TreeMap<String, Integer>();
    }

    public void add(String form, int limit, String tag) {
        this.add(form, form.length() - 1, limit, tag);
    }

    public void add(String form, int index, int limit, String tag) {
        Integer count2 = this.tag_map_.get(tag);
        if (count2 == null) {
            count2 = 0;
        }
        this.tag_map_.put(tag, count2 + 1);
        if (index >= limit) {
            char c = form.charAt(index);
            SuffixTrie trie = this.child_map_.get(Character.valueOf(c));
            if (trie == null) {
                trie = new SuffixTrie(Character.valueOf(c));
                this.child_map_.put(Character.valueOf(c), trie);
            }
            trie.add(form, index - 1, limit, tag);
        }
    }

    public boolean prune(double entropy_threshold, int count_threshold) {
        if (this.totalCount() < count_threshold) {
            return true;
        }
        if (this.entropy() < entropy_threshold) {
            this.child_map_.clear();
            return false;
        }
        TreeMap<Character, SuffixTrie> new_child_map = new TreeMap<Character, SuffixTrie>();
        for (SuffixTrie trie : this.child_map_.values()) {
            if (trie.prune(entropy_threshold, count_threshold)) continue;
            new_child_map.put(trie.c_, trie);
        }
        this.child_map_ = new_child_map;
        return this.child_map_.size() == 0;
    }

    private int totalCount() {
        if (this.total_count_ != null) {
            return this.total_count_;
        }
        this.calcTotalCount();
        return this.total_count_;
    }

    private void calcTotalCount() {
        this.total_count_ = 0;
        for (Map.Entry<String, Integer> tag_entry : this.tag_map_.entrySet()) {
            int count2 = tag_entry.getValue();
            this.total_count_ = this.total_count_ + count2;
        }
    }

    private double entropy() {
        if (this.entropy_ != null) {
            return this.entropy_;
        }
        this.calcEntropy();
        return this.entropy_;
    }

    private void calcEntropy() {
        int total_count = this.totalCount();
        this.entropy_ = 0.0;
        for (Map.Entry<String, Integer> tag_entry : this.tag_map_.entrySet()) {
            int count2 = tag_entry.getValue();
            double prob = (double)count2 / (double)total_count;
            this.entropy_ = this.entropy_ - prob * Math.log(prob);
        }
    }

    private void extractSuffixes(String suffix, List<String> suffixes) {
        if (this.c_ != null) {
            suffix = this.c_ + (String)suffix;
        }
        if (this.child_map_.size() == 0) {
            suffixes.add((String)suffix);
            return;
        }
        for (SuffixTrie trie : this.child_map_.values()) {
            trie.extractSuffixes((String)suffix, suffixes);
        }
    }

    public List<String> extractSuffixes() {
        LinkedList<String> suffixes = new LinkedList<String>();
        this.extractSuffixes("", suffixes);
        return suffixes;
    }

    public String getSuffix(String form) {
        return this.getSuffix(form, form.length() - 1);
    }

    private String getSuffix(String form, int index) {
        char c = form.charAt(index);
        SuffixTrie child = this.child_map_.get(Character.valueOf(c));
        if (child == null) {
            return null;
        }
        if (child.child_map_.size() == 0) {
            return form.substring(index, form.length());
        }
        if (index == 0) {
            return null;
        }
        return child.getSuffix(form, index - 1);
    }

    public void clean() {
        this.total_count_ = null;
        this.entropy_ = null;
        this.tag_map_ = null;
        for (SuffixTrie trie : this.child_map_.values()) {
            trie.clean();
        }
    }
}

