/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.StreamingSequenceWriter;
import com.saxonica.ee.stream.feed.AbsorptionFeed;
import com.saxonica.ee.stream.feed.ComplexNodeEventFeed;
import com.saxonica.ee.stream.feed.DecomposingFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.AccumulatorWatch;
import com.saxonica.ee.stream.watch.MultiAccumulatorWatch;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.validate.CatchingReceiver;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyOutputter;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceCollector;
import net.sf.saxon.event.Sink;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorManager;
import net.sf.saxon.expr.accum.IAccumulatorData;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.s9api.XmlProcessingError;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.z.IntHashMap;

public class CopyOfFeed
extends AbsorptionFeed {
    private final WatchManager watchManager;
    private boolean copyNamespaces = true;
    private boolean copyAccumulators = true;
    private int validation = 3;
    private SchemaType type = null;
    private XPathException validationError;
    private ComplexContentOutputter proxy;

    public static Trigger getWatch(ItemFeed result, Pattern selection, WatchManager wm, XPathContext context) {
        CopyOfFeed action = new CopyOfFeed(wm, result, context);
        Trigger watch = new Trigger(selection, action, context);
        watch.setPipelineConfiguration(wm.getPipelineConfiguration());
        return watch;
    }

    public CopyOfFeed(WatchManager watchManager, ItemFeed result, XPathContext context) {
        super(result, context);
        this.watchManager = watchManager;
        StreamingSequenceWriter writer = new StreamingSequenceWriter(this.getPipelineConfiguration(), result);
        this.proxy = new ComplexContentOutputter(writer);
    }

    @Override
    public void close() throws XPathException {
        if (this.hasFailed()) {
            if (this.validationError != null) {
                this.dynamicError(this.validationError);
            } else {
                this.dynamicError(new XPathException("Streamed copy-of has failed. A validation error, perhaps?)"));
            }
        }
        super.close();
    }

    public void setCopyNamespaces(boolean copy) {
        this.copyNamespaces = copy;
    }

    public void setCopyAccumulators(boolean copy) {
        this.copyAccumulators = copy;
    }

    public void setValidationOptions(int validation, SchemaType type) {
        this.validation = validation;
        this.type = type;
    }

    @Override
    protected AbsorptionFeed.PendingItem makePendingItem(int sequenceNr, FleetingParentNode node) {
        return new PendingCopyAction(this, sequenceNr, node);
    }

    @Override
    protected Sequence processGroundedItem(Item item) throws XPathException {
        Loc loc = Loc.NONE;
        if (item instanceof NodeInfo) {
            int kind = ((NodeInfo)item).getNodeKind();
            if (kind == 2) {
                NodeInfo node = (NodeInfo)item;
                Configuration config = this.getContext().getConfiguration();
                Orphan orphan = new Orphan(config);
                orphan.setNodeKind((short)node.getNodeKind());
                orphan.setNodeName(NameOfNode.makeName(node));
                orphan.setStringValue(item.getUnicodeStringValue());
                orphan.setTypeAnnotation(node.getSchemaType());
                if (this.validation != 3 || this.type != null) {
                    if (this.type != null && !this.type.isSimpleType()) {
                        throw new XPathException("When copying an attribute with schema validation, the requested type must not be a complex type", "XTTE1535", this.getExpression().getLocation());
                    }
                    SimpleType annotation = CopyOf.validateAttribute(node, (SimpleType)this.type, this.validation, this.getContext());
                    orphan.setTypeAnnotation(annotation);
                }
                return orphan;
            }
            if (kind == 1 || kind == 9) {
                if (!this.copyNamespaces) {
                    SequenceCollector writer = new SequenceCollector(this.getPipelineConfiguration());
                    ((NodeInfo)item).copy(writer, 0, loc);
                    return writer.getFirstItem();
                }
                if (this.validation != 3 || this.type != null) {
                    Receiver copier;
                    NodeInfo node = (NodeInfo)item;
                    ParseOptions validationOptions = new ParseOptions().withSchemaValidationMode(this.validation).withTopLevelType(this.type);
                    Configuration config = this.getPipelineConfiguration().getConfiguration();
                    SequenceCollector writer = new SequenceCollector(this.getPipelineConfiguration());
                    if (kind == 9) {
                        copier = config.getDocumentValidator(writer, node.getBaseURI(), validationOptions, loc);
                    } else {
                        validationOptions = validationOptions.withTopLevelElement(NameOfNode.makeName(node).getStructuredQName());
                        copier = config.getElementValidator(writer, validationOptions, loc);
                    }
                    node.copy(copier, 2, loc);
                    return writer.getFirstItem();
                }
            }
        }
        return item;
    }

    @Override
    public void dynamicError(XPathException error) throws XPathException {
        super.dynamicError(error);
        this.proxy = new ComplexContentOutputter(new Sink(this.getPipelineConfiguration()));
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.getNextOutputter().startDocument(properties);
    }

    @Override
    public void endDocument() throws XPathException {
        this.getNextOutputter().endDocument();
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
        this.getNextOutputter().setUnparsedEntity(name, systemID, publicID);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.getNextOutputter().startElement(elemName, typeCode, location, properties);
    }

    @Override
    public void namespace(String prefix, NamespaceUri namespaceUri, int properties) throws XPathException {
        this.getNextOutputter().namespace(prefix, namespaceUri, properties);
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, String value, Location location, int properties) throws XPathException {
        this.getNextOutputter().attribute(attName, typeCode, value, location, properties);
    }

    @Override
    public void startContent() throws XPathException {
        this.getNextOutputter().startContent();
    }

    @Override
    public void endElement() throws XPathException {
        this.getNextOutputter().endElement();
    }

    @Override
    public void characters(UnicodeString chars, Location location, int properties) throws XPathException {
        this.getNextOutputter().characters(chars, location, properties);
    }

    @Override
    public void processingInstruction(String name, UnicodeString data, Location location, int properties) throws XPathException {
        this.getNextOutputter().processingInstruction(name, data, location, properties);
    }

    @Override
    public void comment(UnicodeString content, Location location, int properties) throws XPathException {
        this.getNextOutputter().comment(content, location, properties);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.getNextOutputter().startElement(elemName, type, attributes, namespaces, location, properties);
    }

    private static class CopiedAccumulatorData
    implements IAccumulatorData {
        private final Accumulator accumulator;
        private final IntHashMap<Sequence> preDescentValues = new IntHashMap();
        private final IntHashMap<Sequence> postDescentValues = new IntHashMap();

        public CopiedAccumulatorData(Accumulator acc) {
            this.accumulator = acc;
        }

        public void addValues(TinyNodeImpl node, Sequence preDescent, Sequence postDescent) {
            this.preDescentValues.put(node.getNodeNumber(), preDescent);
            this.postDescentValues.put(node.getNodeNumber(), postDescent);
        }

        @Override
        public Accumulator getAccumulator() {
            return this.accumulator;
        }

        @Override
        public Sequence getValue(NodeInfo node, boolean postDescent) {
            int nodeNr = ((TinyNodeImpl)node).getNodeNumber();
            return postDescent ? this.postDescentValues.get(nodeNr) : this.preDescentValues.get(nodeNr);
        }
    }

    public static class AccumulatorCopier
    extends ProxyReceiver {
        private final WatchManager watchManager;
        private final TinyBuilder builder;
        private final Map<Accumulator, CopiedAccumulatorData> dataMap = new HashMap<Accumulator, CopiedAccumulatorData>();
        int depth = 0;

        public AccumulatorCopier(WatchManager watchManager, Receiver next, TinyBuilder builder) {
            super(next);
            this.builder = builder;
            this.watchManager = watchManager;
            MultiAccumulatorWatch multiAccumulatorWatch = watchManager.getMultiAccumulatorWatch();
            if (multiAccumulatorWatch != null) {
                Map<Accumulator, AccumulatorWatch> accumulators = multiAccumulatorWatch.getAccumulatorMap();
                for (AccumulatorWatch watch : accumulators.values()) {
                    this.dataMap.put(watch.getAccumulator(), new CopiedAccumulatorData(watch.getAccumulator()));
                }
            }
        }

        @Override
        public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
            super.startElement(elemName, type, attributes, namespaces, location, properties);
            this.depth = this.watchManager.getDepth();
        }

        @Override
        public void endElement() throws XPathException {
            super.endElement();
            --this.depth;
            TinyNodeImpl newNode = this.builder.getLastCompletedElement();
            MultiAccumulatorWatch multiAccumulatorWatch = this.watchManager.getMultiAccumulatorWatch();
            if (multiAccumulatorWatch != null) {
                Map<Accumulator, AccumulatorWatch> accumulators = multiAccumulatorWatch.getAccumulatorMap();
                for (AccumulatorWatch watch : accumulators.values()) {
                    Accumulator acc = watch.getAccumulator();
                    CopiedAccumulatorData data = this.dataMap.get(acc);
                    data.addValues(newNode, watch.getPreDescentValueAtDepth(this.depth), watch.getPostDescentValue(null));
                }
            }
        }

        @Override
        public void close() throws XPathException {
            Controller controller = this.watchManager.getPipelineConfiguration().getController();
            if (controller instanceof XsltController) {
                AccumulatorManager manager = ((XsltController)controller).getAccumulatorManager();
                TinyTree tree = this.builder.getTree();
                MultiAccumulatorWatch multiAccumulatorWatch = this.watchManager.getMultiAccumulatorWatch();
                if (multiAccumulatorWatch != null) {
                    Map<Accumulator, AccumulatorWatch> accumulatorWatchMap = multiAccumulatorWatch.getAccumulatorMap();
                    for (Accumulator acc : accumulatorWatchMap.keySet()) {
                        manager.addAccumulatorData(tree, acc, this.dataMap.get(acc));
                    }
                }
                for (CopiedAccumulatorData data : this.dataMap.values()) {
                    manager.addAccumulatorData(tree, data.getAccumulator(), data);
                }
            }
        }
    }

    private static class PendingCopyAction
    extends AbsorptionFeed.PendingItem {
        private TinyBuilder builder;
        private Receiver destination;
        private final FleetingParentNode rootOfCopy;
        public final CopyOfFeed feed;

        public PendingCopyAction(CopyOfFeed feed, int sequence, FleetingParentNode node) {
            super(sequence);
            this.feed = feed;
            this.rootOfCopy = node;
            PipelineConfiguration pipe = feed.getPipelineConfiguration();
            if (feed.valuesReadyToBeOutput.isEmpty() && (feed.getResultFeed() instanceof DecomposingFeed || feed.getResultFeed() instanceof ComplexNodeEventFeed)) {
                Outputter r = feed.getNextOutputter();
                this.destination = new ProxyOutputter(r){

                    @Override
                    public void open() {
                    }

                    @Override
                    public void close() {
                    }
                };
            } else {
                this.builder = new TinyBuilder(pipe);
                this.builder.setStatistics(pipe.getConfiguration().getTreeStatistics().TEMPORARY_TREE_STATISTICS);
                this.destination = this.builder;
                if (feed.copyAccumulators) {
                    this.destination = new AccumulatorCopier(feed.watchManager, this.builder, this.builder);
                }
            }
        }

        @Override
        public Receiver getGatherer() throws XPathException {
            Receiver copier = this.destination;
            if (!this.feed.copyNamespaces) {
                copier = new ProxyReceiver(copier){

                    @Override
                    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
                        NamespaceMap map = NamespaceMap.emptyMap();
                        if (!elemName.getNamespaceUri().isEmpty()) {
                            map = map.put(elemName.getPrefix(), elemName.getNamespaceUri());
                        }
                        for (AttributeInfo att : attributes) {
                            NodeName name = att.getNodeName();
                            if (name.getNamespaceUri().isEmpty()) continue;
                            map = map.put(name.getPrefix(), name.getNamespaceUri());
                        }
                        super.startElement(elemName, type, attributes, map, location, properties);
                    }
                };
            }
            if (this.feed.validation != 3 || this.feed.type != null) {
                Loc loc;
                ParseOptions validationOptions = new ParseOptions().withSchemaValidationMode(this.feed.validation).withTopLevelType(this.feed.type);
                Configuration config = this.feed.getPipelineConfiguration().getConfiguration();
                Location location = loc = this.feed.getExpression() == null ? Loc.NONE : this.feed.getExpression().getLocation();
                if (this.rootOfCopy.getNodeKind() == 9) {
                    copier = new ComplexContentOutputter(config.getDocumentValidator(copier, this.rootOfCopy.getBaseURI(), validationOptions, loc));
                } else {
                    validationOptions = validationOptions.withTopLevelElement(NameOfNode.makeName(this.rootOfCopy).getStructuredQName());
                    try {
                        copier = new ComplexContentOutputter(config.getElementValidator(copier, validationOptions, loc));
                    }
                    catch (XPathException e) {
                        this.feed.dynamicError(e);
                        return null;
                    }
                }
                PipelineConfiguration newPipe = new PipelineConfiguration(this.feed.getPipelineConfiguration());
                newPipe.setErrorReporter(new ErrorReporter(){
                    private int errorCount = 0;

                    @Override
                    public void report(XmlProcessingError error) {
                        if (!error.isWarning() && this.errorCount++ == 0) {
                            feed.validationError = XPathException.fromXmlProcessingError(error);
                            try {
                                feed.dynamicError(feed.validationError);
                            }
                            catch (XPathException xPathException) {
                                // empty catch block
                            }
                        }
                    }
                });
                copier.setPipelineConfiguration(newPipe);
                copier = new CatchingReceiver(copier, newPipe.getErrorReporter());
            }
            return copier;
        }

        @Override
        public Sequence deliver() throws XPathException {
            if (this.feed.hasFailed()) {
                if (this.feed.validationError != null) {
                    throw this.feed.validationError;
                }
                throw new XPathException("Streamed copy-of has failed. Perhaps a validation error?");
            }
            if (this.builder != null) {
                return this.builder.getCurrentRoot();
            }
            return EmptySequence.getInstance();
        }

        @Override
        public void rollback() {
        }
    }
}

