/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.trans.Characteristic;
import com.saxonica.ee.trans.GeneralComparisonOperand;
import com.saxonica.ee.trans.GeneralPatternOptimizer;
import com.saxonica.ee.trans.PatternOptimizer;
import com.saxonica.ee.trans.Precondition;
import com.saxonica.ee.trans.RuleEE;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.pattern.BasePatternWithPredicate;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternWithPredicate;

public class EqualityPatternOptimizer
extends PatternOptimizer {
    private static final EqualityPatternOptimizer THE_INSTANCE = new EqualityPatternOptimizer();

    public static EqualityPatternOptimizer getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public boolean appliesTo(Pattern pattern) {
        Expression exp;
        if (pattern instanceof PatternWithPredicate && (exp = ((PatternWithPredicate)((Object)pattern)).getPredicate()) instanceof ComparisonExpression) {
            if (exp instanceof GeneralComparison && ((ComparisonExpression)((Object)exp)).getRhsExpression() instanceof StringLiteral && ((GeneralComparison)exp).getSingletonOperator() == 50) {
                return true;
            }
            if (exp instanceof ValueComparison && ((ComparisonExpression)((Object)exp)).getRhsExpression() instanceof StringLiteral && ((ValueComparison)exp).getSingletonOperator() == 50) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void process(RuleEE rule, Pattern pattern, Map<Precondition, List<RuleEE>> preconditions, Map<Characteristic, Characteristic> characteristics) {
        Expression exp = ((PatternWithPredicate)((Object)pattern)).getPredicate();
        Expression lhs = ((ComparisonExpression)((Object)exp)).getLhsExpression();
        StringCollator collator = ((ComparisonExpression)((Object)exp)).getStringCollator();
        GeneralComparisonOperand chic = new GeneralComparisonOperand(collator, lhs);
        chic = (GeneralComparisonOperand)this.allocateCharacteristic(characteristics, chic);
        AtomicMatchKey key = collator.getCollationKey(((StringLiteral)((ComparisonExpression)((Object)exp)).getRhsExpression()).getString());
        Precondition.StringHashPrecondition p = new Precondition.StringHashPrecondition(chic, key, collator);
        this.addPrecondition(rule, preconditions, p);
        if (pattern instanceof BasePatternWithPredicate) {
            Pattern base = ((BasePatternWithPredicate)pattern).getBasePattern();
            GeneralPatternOptimizer.getInstance().process(rule, base, preconditions, characteristics);
        }
    }
}

