/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class Serialize
extends SystemFunction {
    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        SerializationProperties outputProps;
        NodeInfo node = (NodeInfo)arguments[0].head();
        if (node == null) {
            return StringValue.EMPTY_STRING;
        }
        Properties props = null;
        Item secondArg = arguments[1].head();
        if (secondArg instanceof StringValue) {
            String lexicalName = secondArg.getStringValue();
            PackageData pack = this.getRetainedStaticContext().getPackageData();
            if (pack instanceof StylesheetPackage) {
                StructuredQName qName;
                try {
                    qName = StructuredQName.fromLexicalQName(lexicalName, false, true, this.getRetainedStaticContext());
                }
                catch (XPathException e) {
                    throw new XPathException("Invalid output format name " + lexicalName + ". " + e.getMessage());
                }
                props = ((StylesheetPackage)pack).getNamedOutputProperties(qName);
                if (props == null) {
                    throw new XPathException("Unknown output format " + lexicalName);
                }
                outputProps = new SerializationProperties(props);
            } else {
                outputProps = new SerializationProperties();
                outputProps.setProperty("method", lexicalName);
            }
        } else if (secondArg instanceof NodeInfo && ((NodeInfo)secondArg).getNodeKind() == 1 && ((NodeInfo)secondArg).getNamespaceUri().equals(NamespaceUri.XSLT) && ((NodeInfo)secondArg).getLocalPart().equals("output")) {
            props = new Properties();
            ResultDocument.processXslOutputElement((NodeInfo)secondArg, props, context);
            outputProps = new SerializationProperties(props);
        } else {
            throw new XPathException("The second argument of saxon:serialize must either be a string literal, or an xsl:output element");
        }
        StringWriter result = new StringWriter();
        SerializerFactory sf = context.getConfiguration().getSerializerFactory();
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        pipe.setXPathContext(context);
        Receiver out = sf.getReceiver((Result)new StreamResult(result), outputProps, pipe);
        out.open();
        node.copy(out, 6, Loc.NONE);
        out.close();
        return new StringValue(result.toString());
    }
}

