/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class LSSchemaResolver
implements SchemaURIResolver {
    private LSResourceResolver resourceResolver;
    private Configuration config;

    public LSSchemaResolver(LSResourceResolver resolver, Configuration config) {
        this.resourceResolver = resolver;
        this.config = config;
    }

    @Override
    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    @Override
    public Source[] resolve(String targetNamespace, String baseURI, String[] locations) throws XPathException {
        Source[] sources = new Source[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            LSInput in = this.resourceResolver.resolveResource("http://www.w3.org/2001/XMLSchema", targetNamespace, null, locations[i], baseURI);
            if (in != null) {
                StreamSource ss = new StreamSource();
                ss.setInputStream(in.getByteStream());
                ss.setReader(in.getCharacterStream());
                ss.setSystemId(in.getSystemId());
                ss.setPublicId(in.getPublicId());
                if (ss.getSystemId() == null) {
                    try {
                        URI buri = new URI(baseURI);
                        ss.setSystemId(buri.resolve(locations[i]).toString());
                    }
                    catch (URISyntaxException err) {
                        ss.setSystemId(baseURI);
                    }
                }
                sources[i] = ss;
                continue;
            }
            sources[i] = new StandardURIResolver(this.config).resolve(locations[i], baseURI);
        }
        return sources;
    }
}

