/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.AllModelGroup;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ElementParticle;
import com.saxonica.ee.schema.ElementWildcard;
import com.saxonica.ee.schema.ModelGroupParticle;
import com.saxonica.ee.schema.Particle;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.SequenceModelGroup;
import com.saxonica.ee.schema.Term;
import com.saxonica.ee.schema.UserSchemaComponent;
import com.saxonica.ee.schema.Wildcard;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntHashSet;

public abstract class ModelGroup
extends SchemaStructure
implements UserSchemaComponent,
Term {
    protected List<Particle> contentModel = new ArrayList<Particle>(20);
    protected List<Particle> simplifiedContentModel;

    public abstract String getCompositorName();

    public void addParticle(Particle particle) {
        if (particle != null && (particle.getMinOccurs() != 0 || particle.getMaxOccurs() != 0)) {
            this.contentModel.add(particle);
        }
    }

    public void setContentModel(List<Particle> particles) {
        this.contentModel = particles;
    }

    public abstract boolean isEmptiable() throws MissingComponentException;

    public boolean isPointless(ModelGroup container) throws MissingComponentException {
        return this.getSimplifiedContentModel().isEmpty();
    }

    public List<Particle> getParticles() {
        return this.contentModel;
    }

    public int getContentModelSize() {
        return this.contentModel.size();
    }

    public boolean isEmpty() {
        return this.getParticles().isEmpty();
    }

    public boolean containsAll(boolean simplified) throws MissingComponentException {
        Iterator<Particle> iter;
        if (simplified) {
            List<Particle> model = this.getSimplifiedContentModel();
            iter = model.iterator();
        } else {
            iter = this.contentModel.iterator();
        }
        while (iter.hasNext()) {
            Particle p = iter.next();
            if (!(p instanceof ModelGroupParticle) || !((ModelGroupParticle)p).getGroup().containsAll(simplified)) continue;
            return true;
        }
        return false;
    }

    public List<Particle> getSimplifiedContentModel() throws MissingComponentException {
        if (this.simplifiedContentModel == null) {
            this.simplifiedContentModel = new ArrayList<Particle>(this.contentModel.size());
            for (Particle p : this.contentModel) {
                if (p instanceof ModelGroupParticle) {
                    ModelGroup mgd = ((ModelGroupParticle)p).getGroup();
                    if (p.isPointless(this)) {
                        this.simplifiedContentModel.addAll(mgd.getSimplifiedContentModel());
                        continue;
                    }
                    if (this instanceof AllModelGroup && mgd instanceof AllModelGroup) {
                        this.simplifiedContentModel.addAll(mgd.getSimplifiedContentModel());
                        continue;
                    }
                    this.simplifiedContentModel.add(p);
                    continue;
                }
                this.simplifiedContentModel.add(p);
            }
        }
        return this.simplifiedContentModel;
    }

    public void markVulnerableSubParticles(boolean isRepeatable) throws MissingComponentException {
        if (isRepeatable) {
            int numberOfOptionalSubParticles = 0;
            for (Particle p : this.contentModel) {
                if (p.getMinOccurs() != 0 && !p.isEmptiable()) continue;
                ++numberOfOptionalSubParticles;
            }
            if (numberOfOptionalSubParticles == this.contentModel.size()) {
                for (Particle p : this.contentModel) {
                    p.setVulnerable(true);
                }
            } else if (numberOfOptionalSubParticles == this.contentModel.size() - 1) {
                for (Particle p : this.contentModel) {
                    if (p.getMinOccurs() == 0 || p.isEmptiable()) continue;
                    p.setVulnerable(true);
                    break;
                }
            }
        }
        for (Particle p : this.contentModel) {
            if (!(p instanceof ModelGroupParticle)) continue;
            p.markVulnerableSubParticles();
        }
    }

    @Override
    public void lookForCycles(Stack references, SchemaCompiler compiler) throws SchemaException {
        references.push(this);
        for (Particle p : this.getParticles()) {
            p.lookForCycles(references, compiler);
        }
        references.pop();
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        boolean result = true;
        for (Particle p : this.getParticles()) {
            if (p instanceof ModelGroupParticle) {
                ModelGroupParticle ref = (ModelGroupParticle)p;
                ref.tryToResolve(compiler);
                if (ref.isResolved()) {
                    result &= ref.getGroup().validate(compiler);
                    continue;
                }
                String err = "Group " + ref.getTargetComponentName().getDisplayName() + " is referenced, but has not been declared";
                compiler.error(err, this);
                this.setValidationStatus(SchemaComponent.ValidationStatus.INCOMPLETE);
                return false;
            }
            result &= p.validate(compiler);
        }
        if (!result) {
            this.setValidationStatus(SchemaComponent.ValidationStatus.INVALID);
            return false;
        }
        IntHashMap<ElementDecl> elements = new IntHashMap<ElementDecl>(20);
        if (!(result &= this.checkElements(elements, compiler))) {
            this.setValidationStatus(SchemaComponent.ValidationStatus.INVALID);
            return false;
        }
        return true;
    }

    protected boolean checkElements(IntHashMap<ElementDecl> map, SchemaCompiler compiler) throws SchemaException, MissingComponentException {
        HashSet<ElementWildcard> wildcards = new HashSet<ElementWildcard>();
        for (Particle p : this.getParticles()) {
            if (p instanceof ModelGroupParticle) {
                boolean b = ((ModelGroupParticle)p).getGroup().checkElements(map, compiler);
                if (b) continue;
                return false;
            }
            if (p instanceof ElementWildcard) {
                wildcards.add((ElementWildcard)p);
                continue;
            }
            if (!(p instanceof ElementParticle)) continue;
            if (!p.isResolved()) {
                String err = "Unresolved reference to element " + Err.wrap(p.getTargetComponentName().getDisplayName(), 1);
                compiler.error(err, this);
                return false;
            }
            ElementDecl e = ((ElementParticle)p).getDeclaration();
            int key = e.getFingerprint();
            ElementDecl prev = map.get(key);
            if (prev == null) {
                map.put(key, e);
                continue;
            }
            if (!e.getType().equals(prev.getType())) {
                String err = "Two elements in the content model have the same name " + Err.wrap(e.getDisplayName(), 1) + " but different types. This violates the constraint 'Element Declarations Consistent'.";
                compiler.error(err, this);
                return false;
            }
            if (e.hasSameTypeTable(prev)) continue;
            String err = "Two elements in the content model have the same name " + Err.wrap(e.getDisplayName(), 1) + " but different type alternatives. This violates the constraint 'Element Declarations Consistent'.";
            compiler.error(err, this);
            return false;
        }
        Iterator<ElementDecl> iterM = map.valueIterator();
        while (iterM.hasNext()) {
            ElementDecl e = iterM.next();
            if (!e.isGlobal()) continue;
            for (ElementDecl member : e.getSubstitutionGroupMembers()) {
                ElementDecl local = map.get(member.getFingerprint());
                if (local == null || local == member) continue;
                if (!e.getType().isSameType(local.getType())) {
                    String err = "An element " + Err.wrap(member.getDisplayName(), 1) + " appears in the content model both as a local element and also as a member of the substitution group of element " + Err.wrap(e.getDisplayName(), 1) + ", and the two element declarations have different types. This violates the constraint 'Element Declarations Consistent'.";
                    compiler.error(err, this);
                    this.setValidationStatus(SchemaComponent.ValidationStatus.INVALID);
                    return false;
                }
                if (e.hasSameTypeTable(local)) continue;
                String err = "An element " + Err.wrap(member.getDisplayName(), 1) + " appears in the content model both as a local element and also as a member of the substitution group of element " + Err.wrap(e.getDisplayName(), 1) + ", and the two element declarations have different type alternatives. This violates the constraint 'Element Declarations Consistent'.";
                compiler.error(err, this);
                return false;
            }
        }
        if (wildcards.isEmpty() || compiler.getConfiguration().getXsdVersion() == 10) {
            return true;
        }
        iterM = map.valueIterator();
        while (iterM.hasNext()) {
            ElementDecl global;
            ElementDecl local = iterM.next();
            if (local.isGlobal() || (global = compiler.getPreparedSchema().getElementDecl(local.getComponentName())) == null) continue;
            for (ElementWildcard wild : wildcards) {
                Wildcard card = wild.getWildcard();
                if (card.getProcessContents().equals("skip") || !card.matches(global.getComponentName(), true, (Configuration)this.getConfiguration(), null) || local.hasSameTypeTable(global)) continue;
                String err = "A local element " + Err.wrap(local.getDisplayName(), 1) + " appears in the content model that has the same name as a global element declaration that could match a strict or lax wildcard in the content model. The table of type alternatives differs between the local element declaration and the global element declaration, which violates the Element Declarations Consistent constraint.";
                compiler.error(err, this);
                return false;
            }
        }
        return true;
    }

    public SchemaType getElementParticleType(int elementName) throws MissingComponentException {
        for (Particle p : this.getParticles()) {
            SchemaType t = p.getElementParticleType(elementName);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public int getElementParticleCardinality(int elementName) throws MissingComponentException {
        int card = 8192;
        for (Particle p : this.getParticles()) {
            int t = p.getElementParticleCardinality(elementName);
            if (t == 8192) continue;
            if (this instanceof SequenceModelGroup) {
                card = Cardinality.sum(card, t);
                continue;
            }
            card = Cardinality.union(card, t);
        }
        return card;
    }

    public boolean containsElementWildcard() throws MissingComponentException {
        for (Particle p : this.getParticles()) {
            if (!p.containsElementWildcard()) continue;
            return true;
        }
        return false;
    }

    public void gatherAllPermittedElements(IntHashSet result, boolean ignoreWildcards) throws SchemaException {
        for (Particle p : this.getParticles()) {
            p.gatherAllPermittedElements(result, ignoreWildcards);
        }
    }

    public void compile(SchemaCompiler compiler) throws SchemaException {
        for (Particle p : this.getParticles()) {
            p.compile(compiler);
        }
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException, MissingComponentException {
        if (this.getFixupStatus() == SchemaComponent.ValidationStatus.UNVALIDATED) {
            this.setFixupStatus(SchemaComponent.ValidationStatus.VALIDATING);
            for (Particle p : this.contentModel) {
                p.fixup(compiler);
            }
            this.lookForCycles(new Stack(), compiler);
        }
        this.setFixupStatus(SchemaComponent.ValidationStatus.VALIDATED);
        return true;
    }

    public Term getTerm() {
        return this;
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException, MissingComponentException {
        String compositor = this.getCompositorName();
        serializer.startElement(compositor);
        for (Particle p : this.getParticles()) {
            p.serializeParticle(serializer);
        }
        serializer.endElement();
    }

    @Override
    public Function getComponentAsFunction() {
        Callable callable = new Callable(){

            public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
                String key;
                switch (key = arguments[0].head().getStringValue()) {
                    case "class": {
                        return new StringValue("Model Group");
                    }
                    case "implementation": {
                        return new ObjectValue<ModelGroup>(ModelGroup.this);
                    }
                    case "compositor": {
                        return new StringValue(ModelGroup.this.getCompositorName());
                    }
                    case "particles": {
                        ArrayList<Function> particles = new ArrayList<Function>();
                        for (Particle p : ModelGroup.this.getParticles()) {
                            particles.add(p.getComponentAsFunction());
                        }
                        return SequenceExtent.makeSequenceExtent(particles);
                    }
                }
                return EmptySequence.getInstance();
            }
        };
        return new CallableFunction(1, callable, COMPONENT_FUNCTION_TYPE);
    }
}

