/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.IdentityConstraint;
import com.saxonica.ee.schema.IdentityConstraintReference;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.sdoc.SchemaDocument;
import com.saxonica.ee.schema.sdoc.SchemaDocumentTransformer;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SchemaReader;
import com.saxonica.ee.schema.sdoc.XSDSchema;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.type.ISchemaCompiler;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AnyURIValue;

public class SchemaCompiler
implements ISchemaCompiler {
    private EnterpriseConfiguration config;
    private PreparedSchema preparedSchema;
    private int[] occurrenceLimits;
    private SchemaURIResolver schemaURIResolver;
    private ErrorListener listener;
    private HashMap<IdentityConstraintReference, SchemaType> identityConstraintsAwaitingTypeChecking = null;
    private int errorCount = 0;
    private int xsdlVersion = 10;
    private boolean deferValidation;
    private HashMap<String, XSDSchema> documentsAlreadyRead = new HashMap(10);
    private HashSet<String> documentsBeingRead = new HashSet(10);
    private PipelineConfiguration pipelineConfiguration;
    private SchemaDocumentTransformer chameleonTransformer = null;
    private SchemaDocumentTransformer overrideTransformer = null;
    private Set<String> componentsReportedMissing = new HashSet<String>();
    private SavedNamespaceContext latestNamespaceContext;

    public SchemaCompiler(EnterpriseConfiguration config) {
        this.config = config;
        this.listener = config.getErrorListener();
        this.schemaURIResolver = config.getSchemaURIResolver();
        this.occurrenceLimits = config.getOccurrenceLimits();
    }

    public EnterpriseConfiguration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public void setLanguageVersion(int version) {
        this.xsdlVersion = version;
    }

    public int getLanguageVersion() {
        return this.xsdlVersion;
    }

    public void setDeferredValidationMode(boolean defer) {
        this.deferValidation = defer;
    }

    public boolean isDeferredValidationMode() {
        return this.deferValidation;
    }

    public void setPreparedSchema(PreparedSchema schema) {
        this.preparedSchema = schema;
    }

    public PreparedSchema getPreparedSchema() {
        return this.preparedSchema;
    }

    public ErrorListener getErrorListener() {
        if (this.listener == null) {
            this.listener = new StandardErrorListener();
            ((StandardErrorListener)this.listener).setLogger(this.config.getLogger());
        }
        return this.listener;
    }

    public void setErrorListener(ErrorListener listener) {
        this.listener = listener;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setOccurrenceLimits(int minimum, int maximum) {
        if (minimum < 1 || minimum >= maximum) {
            throw new IllegalArgumentException("Invalid occurrence limits: min<1 or max<min");
        }
        this.occurrenceLimits = new int[]{minimum, maximum};
    }

    public int[] getOccurrenceLimits() {
        return this.occurrenceLimits;
    }

    public void setBeingRead(String systemId) {
        this.documentsBeingRead.add(systemId);
    }

    public boolean isBeingRead(String systemId) {
        return this.documentsBeingRead.contains(systemId);
    }

    public void markAsRead(String systemId, XSDSchema schema) {
        this.documentsBeingRead.remove(systemId);
        this.documentsAlreadyRead.put(systemId + "##" + schema.getTargetNamespace(), schema);
    }

    public XSDSchema getExistingSchemaDocument(String systemId, String targetNamespace) {
        return this.documentsAlreadyRead.get(systemId + "##" + targetNamespace);
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipelineConfiguration;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipelineConfiguration = pipelineConfiguration;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public String readSchema(PipelineConfiguration pipe, String baseURI, String schemaLocation, String expected) throws SchemaException {
        Source source = SchemaReader.getSource(baseURI, schemaLocation, pipe, expected);
        if (source == null) {
            throw new SchemaException("No schema could be loaded at location " + schemaLocation);
        }
        SchemaDocument schemadoc = SchemaReader.read(source, this, pipe, null);
        if (schemadoc.isCompiledSchemaDocument()) {
            try {
                this.getConfiguration().importComponents(schemadoc.getDocument().getRootNode());
                return expected;
            }
            catch (XPathException e) {
                throw new SchemaException(e);
            }
        }
        return this.processSchemaDocument(schemadoc, schemaLocation, expected);
    }

    private String processSchemaDocument(SchemaDocument schemadoc, String schemaLocation, String expected) throws SchemaException {
        if (schemadoc.isCompiledSchemaDocument()) {
            return expected;
        }
        String targetNamespace = schemadoc.getTargetNamespace();
        if (expected != null && !expected.equals(targetNamespace)) {
            SchemaException exception = new SchemaException("Schema " + (schemaLocation == null ? "" : "at location " + schemaLocation + " ") + "has target namespace \"" + targetNamespace + "\" but requested namespace was \"" + expected + '\"');
            if (schemaLocation == null) {
                exception.setErrorCode("XTSE0215");
            }
            throw exception;
        }
        SingleNamespaceSchema ps = schemadoc.getXSDSchema().getSchema();
        if (this.deferValidation) {
            this.retainSchemaComponents(ps);
        } else {
            this.preparedSchema = ps;
            this.validate(schemadoc);
            this.preparedSchema = null;
        }
        Collection<GlobalParam> globalParams = schemadoc.getXSDSchema().getGlobalParams();
        for (GlobalParam param : globalParams) {
            ps.addGlobalParam(param);
        }
        return targetNamespace;
    }

    private void retainSchemaComponents(PreparedSchema ps) throws SchemaException {
        this.preparedSchema = this.preparedSchema == null ? ps : PreparedSchema.merge(this.preparedSchema, ps);
    }

    public void readMultipleSchemas(PipelineConfiguration pipe, String baseURI, Collection<String> schemaLocations, String expected) throws SchemaException {
        String[] locations = new String[schemaLocations.size()];
        int loc = 0;
        for (String schemaLocation : schemaLocations) {
            locations[loc++] = schemaLocation;
        }
        Source[] sources = SchemaReader.getSources(baseURI, locations, pipe, expected);
        if (sources.length == 0) {
            return;
        }
        boolean success = false;
        SchemaException lastException = null;
        PreparedSchema mergedSchema = null;
        for (int i = 0; i < sources.length; ++i) {
            try {
                Source source = sources[i];
                SchemaDocument schemadoc = SchemaReader.read(source, this, pipe, null);
                if (schemadoc.isCompiledSchemaDocument()) {
                    throw new SchemaException("Only source schema documents (not SCM compiled schemas) are accepted here");
                }
                success = true;
                SingleNamespaceSchema ps = schemadoc.getXSDSchema().getSchema();
                mergedSchema = mergedSchema == null ? ps : PreparedSchema.merge(mergedSchema, ps);
                String targetNamespace = schemadoc.getTargetNamespace();
                if (expected == null || expected.equals(targetNamespace)) continue;
                throw new SchemaException("Schema at " + locations[i] + " has target namespace \"" + targetNamespace + "\" but requested namespace was \"" + expected + '\"');
            }
            catch (SchemaException e) {
                if (e.getException() instanceof IOException) {
                    pipe.getErrorListener().warning(e);
                    continue;
                }
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        if (!success) {
            throw new SchemaException("No valid schema was found");
        }
        if (this.deferValidation) {
            this.retainSchemaComponents(mergedSchema);
        } else {
            this.preparedSchema = mergedSchema;
            mergedSchema.validate(this);
            this.preparedSchema = null;
        }
    }

    public String readInlineSchema(NodeInfo root, String expected, ErrorListener errorListener) throws SchemaException {
        ErrorListener listener = errorListener == null ? this.getErrorListener() : errorListener;
        this.setErrorListener(listener);
        PipelineConfiguration pipe = this.config.makePipelineConfiguration();
        pipe.setErrorListener(listener);
        pipe.setHostLanguage(52);
        SchemaDocument schemadoc = SchemaReader.read(root, this, pipe, null);
        return this.processSchemaDocument(schemadoc, null, expected);
    }

    public void compile() throws SchemaException {
        boolean valid = this.preparedSchema.validate(this);
        if (!valid) {
            throw new SchemaException("The schema is invalid");
        }
    }

    public PreparedSchema validate(SchemaDocument doc) throws SchemaException {
        if (doc.isCompiledSchemaDocument()) {
            throw new SchemaException("Only source schema documents (not SCM compiled schemas) are accepted here");
        }
        XSDSchema schemaRoot = doc.getXSDSchema();
        this.preparedSchema = schemaRoot.getSchema();
        int errors = schemaRoot.getErrorCount();
        if (errors > 0) {
            String msg = errors == 1 ? "One error was" : errors + " errors were";
            throw new SchemaException(msg + " found while processing the schema");
        }
        for (GlobalParam param : schemaRoot.getGlobalParams()) {
            this.preparedSchema.addGlobalParam(param);
        }
        this.compile();
        PreparedSchema ps = this.preparedSchema;
        this.preparedSchema = null;
        return ps;
    }

    public boolean reportMissingComponent(String componentType, StructuredQName componentName) {
        String key = componentType + " " + componentName.getEQName();
        return this.componentsReportedMissing.add(key);
    }

    public void error(String message, Location locator) throws SchemaException {
        ErrorListener errorListener = this.getErrorListener();
        SchemaException exception = new SchemaException(message, locator);
        if (errorListener == null) {
            errorListener = this.config.getErrorListener();
        }
        ++this.errorCount;
        try {
            errorListener.fatalError(exception);
        }
        catch (TransformerException err) {
            if (err instanceof SchemaException) {
                throw (SchemaException)err;
            }
            throw new SchemaException(err);
        }
    }

    public void warning(String message, Location locator) {
        if (locator.getSystemId() != null && locator.getSystemId().endsWith("override.xsl")) {
            locator = new ExplicitLocation("schema_document_resulting_from_override_processing", -1, -1);
        }
        SchemaException exception = new SchemaException(message, locator);
        try {
            this.getErrorListener().warning(exception);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public void addPendingTypeCheck(IdentityConstraintReference constraint, SchemaType contextItemType) {
        if (this.identityConstraintsAwaitingTypeChecking == null) {
            this.identityConstraintsAwaitingTypeChecking = new HashMap(20);
        }
        this.identityConstraintsAwaitingTypeChecking.put(constraint, contextItemType);
    }

    public void typeCheckIdentityConstraints() throws SchemaException {
        try {
            if (this.identityConstraintsAwaitingTypeChecking != null) {
                for (Map.Entry<IdentityConstraintReference, SchemaType> e : this.identityConstraintsAwaitingTypeChecking.entrySet()) {
                    IdentityConstraint constraint = e.getKey().getTarget();
                    SchemaType contextItemType = e.getValue();
                    constraint.typeCheck(this, contextItemType);
                }
                this.identityConstraintsAwaitingTypeChecking = null;
            }
        }
        catch (XPathException e) {
            throw new SchemaException(e);
        }
    }

    public SchemaDocument doChameleonTransformation(NodeInfo input, SchemaElement referrer) throws SchemaException {
        if (this.chameleonTransformer == null) {
            this.chameleonTransformer = new SchemaDocumentTransformer(this.config, "chameleon.xsl");
        }
        HashMap<StructuredQName, AnyURIValue> params = new HashMap<StructuredQName, AnyURIValue>();
        params.put(new StructuredQName("", "", "newTargetNamespace"), new AnyURIValue(referrer.getXSDSchema().getTargetNamespace()));
        GlobalParameterSet parameterSet = new GlobalParameterSet();
        parameterSet.put(new StructuredQName("", "", "newTargetNamespace"), new AnyURIValue(referrer.getXSDSchema().getTargetNamespace()));
        TreeInfo doc = this.chameleonTransformer.transform(this, this.pipelineConfiguration, referrer, input, parameterSet);
        return new SchemaDocument(doc);
    }

    public SchemaDocument doOverrideTransformation(NodeInfo input, SchemaElement referrer) throws SchemaException {
        if (this.overrideTransformer == null) {
            this.overrideTransformer = new SchemaDocumentTransformer(this.config, "override.xsl");
        }
        GlobalParameterSet params = new GlobalParameterSet();
        params.put(new StructuredQName("", "", "overrideElement"), referrer);
        TreeInfo doc = this.overrideTransformer.transform(this, this.pipelineConfiguration, referrer, input, params);
        return new SchemaDocument(doc);
    }

    public NamespaceResolver makeNamespaceResolver(NodeInfo node) {
        SavedNamespaceContext nc = new SavedNamespaceContext(NamespaceIterator.iterateNamespaces(node));
        if (!nc.equals(this.latestNamespaceContext)) {
            this.latestNamespaceContext = nc;
        }
        return this.latestNamespaceContext;
    }
}

