/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import java.net.URISyntaxException;
import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.DescendingComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public class HighestOrLowest
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Item next;
        StringCollator collator;
        StringValue val;
        Configuration config = context.getConfiguration();
        Sequence input = arguments[0];
        String collationUri = null;
        if (arguments.length >= 2 && (val = (StringValue)arguments[1].head()) != null) {
            try {
                collationUri = ResolveURI.makeAbsolute(val.getStringValue(), this.getStaticBaseUriString()).toString();
            }
            catch (URISyntaxException e) {
                throw new XPathException(e);
            }
        }
        if (collationUri == null) {
            collationUri = this.getRetainedStaticContext().getDefaultCollationName();
        }
        if ((collator = config.getCollation(collationUri)) == null) {
            throw new XPathException("Unknown collation " + this.getRetainedStaticContext().getDefaultCollationName(), "FOCH0002");
        }
        AtomicComparer comparer = new GenericAtomicComparer(collator, context);
        if (this.getFunctionName().getLocalPart().equals("lowest")) {
            comparer = new DescendingComparer(comparer);
        }
        FunctionItem keyFn = arguments.length >= 3 ? (FunctionItem)arguments[2].head() : SystemFunction.makeFunction("data", this.getRetainedStaticContext(), 1);
        Sequence[] args = new Sequence[1];
        AtomicValue maxSoFar = null;
        ArrayList<Item> highestSoFar = new ArrayList<Item>();
        SequenceIterator iter = arguments[0].iterate();
        while ((next = iter.next()) != null) {
            int result;
            args[0] = next;
            Sequence key = HighestOrLowest.dynamicCall(keyFn, context, args);
            Item head = key.head();
            if (head == null) continue;
            if (!(head instanceof AtomicValue)) {
                throw new XPathException("Result of function supplied as second argument to " + this.getFunctionName().getDisplayName() + " must be an atomic value", "XPTY0004");
            }
            AtomicValue keyVal = (AtomicValue)key.head();
            if (keyVal.isUntypedAtomic()) {
                StringToDouble converter = context.getConfiguration().getConversionRules().getStringToDoubleConverter();
                try {
                    keyVal = new DoubleValue(converter.stringToNumber(keyVal.getUnicodeStringValue()));
                }
                catch (NumberFormatException e) {
                    throw new XPathException("Failed to convert key to xs:double: " + e.getMessage(), "FORG0001").withXPathContext(context);
                }
            }
            if (keyVal.isNaN()) continue;
            if (!keyVal.getPrimitiveType().isOrdered(false)) {
                throw new XPathException("Type " + keyVal.getPrimitiveType() + " is not an ordered type").withErrorCode("FORG0006").asTypeError().withXPathContext(context);
            }
            if (maxSoFar == null) {
                highestSoFar.add(next);
                maxSoFar = keyVal;
                continue;
            }
            try {
                result = comparer.compareAtomicValues(keyVal, maxSoFar);
            }
            catch (ClassCastException e) {
                throw new XPathException("Keys computed for " + this.getFunctionName().getDisplayName() + " are not comparable", "FORG0006");
            }
            if (result > 0) {
                highestSoFar.clear();
                highestSoFar.add(next);
                maxSoFar = keyVal;
                continue;
            }
            if (result != 0) continue;
            highestSoFar.add(next);
        }
        return new SequenceExtent.Of(highestSoFar);
    }
}

