/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn.instruct;

import com.saxonica.functions.extfn.WithPedigree;
import com.saxonica.xsltextn.pedigree.Pedigree;
import com.saxonica.xsltextn.pedigree.PedigreeMapItem;
import com.saxonica.xsltextn.pedigree.PedigreeValue;
import java.util.ArrayList;
import java.util.LinkedList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class TabulateMaps
extends Instruction {
    private Operand rootOp;
    private Operand selectOp;

    public TabulateMaps(Expression root, Expression select) {
        this.rootOp = new Operand(this, root, OperandRole.INSPECT);
        this.selectOp = new Operand(this, select, OperandRole.FOCUS_CONTROLLED_ACTION);
    }

    public Expression getRootExpression() {
        return this.rootOp.getChildExpression();
    }

    public Expression getSelectExpression() {
        return this.selectOp.getChildExpression();
    }

    public void setRootExpression(Expression expr) {
        this.rootOp.setChildExpression(expr);
    }

    public void setSelectExpression(Expression expr) {
        this.selectOp.setChildExpression(expr);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.rootOp, this.selectOp);
    }

    @Override
    public int getInstructionNameCode() {
        return 265;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.rootOp.typeCheck(visitor, contextInfo);
        ContextItemStaticInfo ciso2 = new ContextItemStaticInfo(this.getRootExpression().getItemType(), false);
        this.selectOp.typeCheck(visitor, ciso2);
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(false);
        RoleDiagnostic role = new RoleDiagnostic(4, "saxon:tabulate-maps/root", 0);
        SequenceType required = SequenceType.FUNCTION_ITEM_SEQUENCE;
        this.setRootExpression(tc.staticTypeCheck(this.getRootExpression(), required, role, visitor));
        required = MapType.SEQUENCE_OF_MAPS;
        role = new RoleDiagnostic(4, "saxon:tabulate-maps/select", 0);
        this.setSelectExpression(tc.staticTypeCheck(this.getSelectExpression(), required, role, visitor));
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        TabulateMaps exp = new TabulateMaps(this.getRootExpression().copy(rebindings), this.getSelectExpression().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public ItemType getItemType() {
        return MapType.ANY_MAP_TYPE;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Object root;
        SequenceIterator<?> rootIterator = this.getRootExpression().iterate(context);
        MappingFunction mapper = item -> SingletonIterator.makeIterator(WithPedigree.makeRootWithPedigree(item));
        MappingIterator mappedRootIterator = new MappingIterator(rootIterator, mapper);
        XPathContextMinor c2 = context.newMinorContext();
        FocusIterator trackingIterator = c2.trackFocus(mappedRootIterator);
        while ((root = trackingIterator.next()) != null) {
            this.processRootItem((Item)root, c2);
        }
        return null;
    }

    private void processRootItem(Item root, XPathContext c2) throws XPathException {
        Object selected;
        FocusTrackingIterator selectIterator = new FocusTrackingIterator(this.getSelectExpression().iterate(c2));
        while ((selected = selectIterator.next()) != null) {
            if (!(selected instanceof PedigreeMapItem)) {
                if (selected instanceof MapItem) {
                    throw new XPathException("saxon:tabulate: selected item is a map with no pedigree", "SXTM0001");
                }
                throw new XPathException("saxon:tabulate: selected item is not a map", "SXTM0001");
            }
            MapItem selectedMap = (MapItem)selected;
            Pedigree pedigree = ((PedigreeValue)selected).getPedigree();
            PedigreeValue parent = pedigree.getContainer();
            int level = 0;
            LinkedList<AtomicValue> keys = new LinkedList<AtomicValue>();
            while (parent != null) {
                ++level;
                Item latestParent = (Item)((Object)parent);
                if (latestParent instanceof ArrayItem) {
                    keys.add(0, new Int64Value(pedigree.getIndex() + 1));
                } else if (latestParent instanceof MapItem) {
                    keys.add(0, pedigree.getKey());
                    block2: for (KeyValuePair kvp : ((MapItem)latestParent).keyValuePairs()) {
                        AtomicValue k = kvp.key;
                        if (k.isIdentical(pedigree.getKey())) continue;
                        GroundedValue<?> value = selectedMap.get(k);
                        if (value == null) {
                            selectedMap = selectedMap.addEntry(k, kvp.value);
                            continue;
                        }
                        if (!(k instanceof StringValue)) continue;
                        String ks = k.getStringValue();
                        for (int suffix = 1; suffix < Integer.MAX_VALUE; ++suffix) {
                            StringValue sv = new StringValue(ks = ks + suffix + "");
                            if (selectedMap.get(sv) != null) continue;
                            selectedMap = selectedMap.addEntry(sv, kvp.value);
                            continue block2;
                        }
                    }
                } else assert (false);
                pedigree = parent.getPedigree();
                parent = pedigree.getContainer();
            }
            String keysKey = "_keys";
            while (selectedMap.get(new StringValue(keysKey)) != null) {
                keysKey = keysKey + "_";
            }
            ArrayList copy = new ArrayList(keys);
            selectedMap = selectedMap.addEntry(new StringValue(keysKey), new SimpleArrayItem(copy));
            c2.getReceiver().append(selectedMap);
        }
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("tabulate", this);
        this.getRootExpression().export(out);
        this.getSelectExpression().export(out);
        out.endElement();
    }
}

