/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.index;

import de.ids_mannheim.korap.index.MultiTermTokenStream;
import de.ids_mannheim.korap.util.CorpusDataException;
import java.nio.ByteBuffer;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTerm
implements Comparable<MultiTerm> {
    public int start;
    public int end = 0;
    public String term = null;
    private boolean storeOffsets = false;
    public BytesRef payload = null;
    private static ByteBuffer bb = ByteBuffer.allocate(8);
    private static String[] stringOffset;
    private static short i;
    private static short l;
    public static final boolean DEBUG = false;
    private final Logger log = LoggerFactory.getLogger(MultiTermTokenStream.class);

    public MultiTerm() {
        this.term = "";
    }

    public MultiTerm(String term) throws CorpusDataException {
        this._fromString(term);
    }

    public MultiTerm(char prefix, String term) throws CorpusDataException {
        StringBuilder sb = new StringBuilder();
        this._fromString(sb.append(prefix).append(':').append(term).toString());
    }

    public String getTerm() {
        return this.term;
    }

    public MultiTerm setTerm(String term) {
        this.term = term;
        return this;
    }

    public BytesRef getPayload() {
        return this.payload;
    }

    public MultiTerm setPayload(Byte pl) {
        this.payload = new BytesRef(ByteBuffer.allocate(1).put(pl).array());
        return this;
    }

    public MultiTerm setPayload(short pl) {
        this.payload = new BytesRef(ByteBuffer.allocate(2).putShort(pl).array());
        return this;
    }

    public MultiTerm setPayload(int pl) {
        this.payload = new BytesRef(ByteBuffer.allocate(4).putInt(pl).array());
        return this;
    }

    public MultiTerm setPayload(long pl) {
        this.payload = new BytesRef(ByteBuffer.allocate(8).putLong(pl).array());
        return this;
    }

    public MultiTerm setPayload(String pl) {
        this.payload = new BytesRef(pl);
        return this;
    }

    public MultiTerm setPayload(byte[] pl) {
        this.payload = new BytesRef(pl);
        return this;
    }

    public MultiTerm setPayload(BytesRef pl) {
        this.payload = pl;
        return this;
    }

    public int getStart() {
        return this.start;
    }

    public MultiTerm setStart(int start) {
        this.start = start;
        return this;
    }

    public int getEnd() {
        return this.end;
    }

    public MultiTerm setEnd(int end) {
        this.end = end;
        return this;
    }

    public boolean hasStoredOffsets() {
        return this.storeOffsets;
    }

    public MultiTerm hasStoredOffsets(boolean value) {
        this.storeOffsets = value;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this._escape(this.term));
        if (this.start != this.end) {
            sb.append('#').append(this.start).append('-').append(this.end);
        }
        if (this.payload != null) {
            sb.append('$');
            try {
                sb.append(this.payload.utf8ToString());
            }
            catch (AssertionError e) {
                sb.append("<?>").append(this.payload.toString().replace(' ', ','));
            }
        }
        return sb.toString();
    }

    @Override
    public int compareTo(MultiTerm o) {
        if (this.payload == null || o.payload == null) {
            return 0;
        }
        if (this.end < o.end) {
            return -1;
        }
        if (this.end > o.end) {
            return 1;
        }
        if (this.start < o.start) {
            return -1;
        }
        if (this.start > o.start) {
            return 1;
        }
        return 0;
    }

    public String toStringShort() {
        StringBuilder sb = new StringBuilder(this._escape(this.term));
        if (this.payload != null) {
            sb.append('$');
            try {
                sb.append(this.payload.utf8ToString());
            }
            catch (AssertionError e) {
                sb.append("<?>").append(this.payload.toString().replace(' ', ','));
            }
        }
        return sb.toString();
    }

    private void _fromString(String term) throws CorpusDataException {
        String[] termSurface = term.split("(?<!\\\\)\\$", 2);
        if (termSurface.length == 2) {
            String payloadStr = termSurface[1];
            if (payloadStr.charAt(0) == '<' && payloadStr.charAt(2) == '>') {
                bb.rewind();
                String[] pls = payloadStr.split("((?=<)|(?<=>))(?!\\A)");
                l = 0;
                try {
                    block16: for (i = 1; i < pls.length; i = (short)(i + 2)) {
                        if (bb.capacity() - l < 8) {
                            bb = ByteBuffer.allocate(bb.capacity() + 8).put(bb.array());
                            bb.position(l);
                        }
                        switch (pls[i - 1]) {
                            case "<b>": {
                                bb.put(Byte.parseByte(pls[i]));
                                l = (short)(l + 1);
                                continue block16;
                            }
                            case "<s>": {
                                bb.putShort(Short.parseShort(pls[i]));
                                l = (short)(l + 2);
                                continue block16;
                            }
                            case "<i>": {
                                bb.putInt(Integer.parseInt(pls[i]));
                                l = (short)(l + 4);
                                continue block16;
                            }
                            case "<l>": {
                                bb.putLong(Long.parseLong(pls[i]));
                                l = (short)(l + 8);
                            }
                        }
                    }
                    byte[] bytes = new byte[l];
                    System.arraycopy(bb.array(), 0, bytes, 0, l);
                    this.payload = new BytesRef(bytes);
                }
                catch (Exception exception) {}
            } else {
                this.payload = new BytesRef(payloadStr);
            }
        }
        if ((stringOffset = termSurface[0].split("(?<!\\\\)\\#", 2)).length == 2) {
            String[] offset = stringOffset[1].split("\\-", 2);
            if (offset.length == 2 && offset[0].length() > 0) {
                try {
                    this.start = Integer.parseInt(offset[0]);
                    this.end = Integer.parseInt(offset[1]);
                }
                catch (NumberFormatException e) {
                    throw new CorpusDataException(952, "Given offset information is not numeric in " + termSurface[0]);
                }
            } else {
                throw new CorpusDataException(953, "Given offset information is incomplete in " + termSurface[0]);
            }
        }
        this.term = this._unescape(stringOffset[0]);
    }

    private String _escape(String term) {
        return term.replaceAll("([#\\$\\\\])", "\\\\$1");
    }

    private String _unescape(String term) {
        return term.replace("\\\\", "\\").replace("\\#", "#").replace("\\$", "$");
    }
}

