/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class CountingCompletionService<V>
extends ExecutorCompletionService<V> {
    private final AtomicLong submittedTasks = new AtomicLong();
    private final AtomicLong completedTasks = new AtomicLong();

    public CountingCompletionService(Executor executor) {
        super(executor);
    }

    public CountingCompletionService(Executor executor, BlockingQueue<Future<V>> queue) {
        super(executor, queue);
    }

    @Override
    public Future<V> submit(Callable<V> task) {
        Future<V> future = super.submit(task);
        this.submittedTasks.incrementAndGet();
        return future;
    }

    @Override
    public Future<V> submit(Runnable task, V result) {
        Future<V> future = super.submit(task, result);
        this.submittedTasks.incrementAndGet();
        return future;
    }

    @Override
    public Future<V> take() throws InterruptedException {
        Future future = super.take();
        this.completedTasks.incrementAndGet();
        return future;
    }

    @Override
    public Future<V> poll() {
        Future future = super.poll();
        if (future != null) {
            this.completedTasks.incrementAndGet();
        }
        return future;
    }

    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        Future future = super.poll(timeout, unit);
        if (future != null) {
            this.completedTasks.incrementAndGet();
        }
        return future;
    }

    public long getNumberOfCompletedTasks() {
        return this.completedTasks.get();
    }

    public long getNumberOfSubmittedTasks() {
        return this.submittedTasks.get();
    }

    public boolean hasUncompletedTasks() {
        return this.completedTasks.get() < this.submittedTasks.get();
    }
}

