/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.IdentityConstraint;
import com.saxonica.ee.schema.IdentityConstraintReference;
import com.saxonica.ee.schema.Key;
import com.saxonica.ee.schema.KeyRef;
import com.saxonica.ee.schema.Unique;
import com.saxonica.ee.stream.watch.Watch;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.validate.KeySelectorWatch;
import com.saxonica.ee.validate.RefSelectorWatch;
import com.saxonica.ee.validate.SelectorWatch;
import com.saxonica.ee.validate.ValidationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.MultiIterator;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;

public class ConstraintChecker
extends WatchManager {
    private ValidationContext validationContext;
    private List<Watch> prearrangedWatches = new ArrayList<Watch>(4);

    public ConstraintChecker(PipelineConfiguration pipe) {
        super(pipe);
    }

    public void setValidationContext(ValidationContext vc) {
        this.validationContext = vc;
    }

    public ValidationContext getValidationContext() {
        return this.validationContext;
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        Controller controller = pipe.getController();
        if (controller == null) {
            Configuration config = this.getPipelineConfiguration().getConfiguration();
            controller = new Controller(config);
            controller.getExecutable().setSchemaAware(true);
            this.getPipelineConfiguration().setController(controller);
        }
        XPathContextMajor context = controller.newXPathContext();
        this.setXPathContext(context);
    }

    public void setElementDeclaration(ElementDecl decl) throws XPathException {
        SelectorWatch watch;
        IdentityConstraint constraint;
        for (IdentityConstraintReference icr : decl.getIdentityConstraints()) {
            constraint = icr.getTarget();
            if (!(constraint instanceof KeyRef)) continue;
            watch = new RefSelectorWatch(this, (KeyRef)constraint);
            this.prearrangedWatches.add(watch);
        }
        for (IdentityConstraintReference icr : decl.getIdentityConstraints()) {
            constraint = icr.getTarget();
            if (!(constraint instanceof Unique) && !(constraint instanceof Key)) continue;
            watch = new KeySelectorWatch(this, constraint);
            this.prearrangedWatches.add(watch);
            List iterators = Arrays.asList(this.watchList.iterator(), this.prearrangedWatches.iterator());
            MultiIterator watches = new MultiIterator(iterators);
            while (watches.hasNext()) {
                StructuredQName reffp;
                Watch ref = (Watch)watches.next();
                if (!(ref instanceof RefSelectorWatch) || !(reffp = ((KeyRef)((RefSelectorWatch)ref).getIdentityConstraint()).getTargetComponentName()).equals(constraint.getConstraintName())) continue;
                ((KeySelectorWatch)watch).addKeyRef((RefSelectorWatch)ref);
            }
        }
    }

    @Override
    protected void addPrearrangedWatches() throws XPathException {
        for (Watch prearrangedWatch : this.prearrangedWatches) {
            this.addWatch(prearrangedWatch, true);
        }
        this.prearrangedWatches.clear();
    }
}

