/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.axiom;

import java.util.Stack;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.option.axiom.AxiomDocumentNodeWrapper;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;

public class AxiomWriter
extends Builder {
    private final OMFactory factory;
    private OMDocument document;
    private final Stack<OMContainer> ancestors = new Stack();
    private final Stack<NamespaceMap> nsStack = new Stack();
    private boolean implicitDocumentNode = false;
    private final StringBuilder textBuffer = new StringBuilder(256);

    public AxiomWriter(PipelineConfiguration pipe) {
        super(pipe);
        this.factory = OMAbstractFactory.getOMFactory();
        this.nsStack.push(NamespaceMap.emptyMap());
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.document = this.factory.createOMDocument();
        this.ancestors.push((OMContainer)this.document);
        this.textBuffer.setLength(0);
    }

    @Override
    public void endDocument() throws XPathException {
        this.ancestors.pop();
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        OMElement element;
        this.flush();
        String local = elemName.getLocalPart();
        NamespaceUri uri = elemName.getNamespaceUri();
        String prefix = elemName.getPrefix();
        if (this.ancestors.isEmpty()) {
            this.startDocument(0);
            this.implicitDocumentNode = true;
        }
        if (!uri.isEmpty()) {
            OMNamespace ns = this.factory.createOMNamespace(uri.toString(), prefix);
            element = this.factory.createOMElement(local, ns);
        } else {
            element = this.factory.createOMElement(local, null);
        }
        if (this.ancestors.size() == 1) {
            this.document.setOMDocumentElement(element);
        } else {
            this.ancestors.peek().addChild((OMNode)element);
        }
        this.ancestors.push((OMContainer)element);
        NamespaceMap parentNamespaces = this.nsStack.peek();
        if (namespaces != parentNamespaces) {
            NamespaceBinding[] declarations;
            for (NamespaceBinding ns : declarations = namespaces.getDifferences(parentNamespaces, false)) {
                String nsprefix = ns.getPrefix();
                NamespaceUri nsuri = ns.getNamespaceUri();
                if (nsprefix.equals("")) {
                    element.declareDefaultNamespace(nsuri.toString());
                    continue;
                }
                if (nsuri.isEmpty()) continue;
                OMNamespace ons = this.factory.createOMNamespace(nsuri.toString(), nsprefix);
                element.declareNamespace(ons);
            }
        }
        this.nsStack.push(namespaces);
        for (AttributeInfo att : attributes) {
            NodeName nameCode = att.getNodeName();
            String attlocal = nameCode.getLocalPart();
            NamespaceUri atturi = nameCode.getNamespaceUri();
            String attprefix = nameCode.getPrefix();
            OMNamespace ns = atturi.isEmpty() ? null : this.factory.createOMNamespace(atturi.toString(), attprefix);
            OMAttribute attr = this.factory.createOMAttribute(attlocal, ns, att.getValue());
            if (ReceiverOption.contains(properties, 2048) || attlocal.equals("id") && atturi.equals(NamespaceUri.XML)) {
                attr.setAttributeType("ID");
            } else if (ReceiverOption.contains(properties, 4096)) {
                attr.setAttributeType("IDREF");
            }
            element.addAttribute(attr);
        }
    }

    @Override
    public void endElement() throws XPathException {
        this.flush();
        this.ancestors.pop();
        this.nsStack.pop();
        OMContainer parent = this.ancestors.peek();
        if (parent == this.document && this.implicitDocumentNode) {
            this.endDocument();
        }
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.textBuffer.append(chars);
    }

    private void flush() {
        if (this.textBuffer.length() != 0) {
            OMText text = this.factory.createOMText(this.textBuffer.toString());
            this.ancestors.peek().addChild((OMNode)text);
            this.textBuffer.setLength(0);
        }
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        this.flush();
        OMContainer parent = this.ancestors.peek();
        OMProcessingInstruction pi = this.factory.createOMProcessingInstruction(parent, target, data.toString());
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.flush();
        OMContainer parent = this.ancestors.peek();
        OMComment comment = this.factory.createOMComment(parent, chars.toString());
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    public OMDocument getDocument() {
        return this.document;
    }

    @Override
    public NodeInfo getCurrentRoot() {
        return new AxiomDocumentNodeWrapper(this.document, this.systemId, this.config);
    }
}

