/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma.edit;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lemming.lemma.LemmaCandidateGenerator;
import lemming.lemma.LemmaCandidateGeneratorTrainer;
import lemming.lemma.LemmaInstance;
import lemming.lemma.LemmaOptions;
import lemming.lemma.edit.EditTreeGenerator;
import marmot.util.Counter;
import marmot.util.edit.EditTree;
import marmot.util.edit.EditTreeBuilder;
import marmot.util.edit.EditTreeBuilderTrainer;

public class EditTreeGeneratorTrainer
implements LemmaCandidateGeneratorTrainer {
    private EditTreeGeneratorTrainerOptions options_ = new EditTreeGeneratorTrainerOptions();

    @Override
    public LemmaCandidateGenerator train(List<LemmaInstance> instances, List<LemmaInstance> dev_instances) {
        EditTreeBuilder builder = new EditTreeBuilderTrainer(this.options_.getRandom(), this.options_.getNumSteps(), this.options_.getMaxDepth()).train(instances);
        HashMap<String, Counter> map2 = new HashMap<String, Counter>();
        map2.put(this.options_.getUnknown(), new Counter());
        for (LemmaInstance instance : instances) {
            String tag;
            String form = instance.getForm();
            String lemma = instance.getLemma();
            EditTree tree = builder.build(form, lemma);
            Counter counter = (Counter)map2.get(this.options_.getUnknown());
            counter.increment(tree, 1.0);
            if (!this.options_.getIsTagDependent() || (tag = instance.getPosTag()) == null) continue;
            counter = map2.computeIfAbsent(tag, k -> new Counter());
            counter.increment(tree, 1.0);
        }
        HashMap<String, List<EditTree>> list_map = new HashMap<String, List<EditTree>>();
        for (Map.Entry map_entry : map2.entrySet()) {
            LinkedList<EditTree> list = new LinkedList<EditTree>();
            Counter counter = (Counter)map_entry.getValue();
            list_map.put((String)map_entry.getKey(), list);
            for (Map.Entry entry : counter.entrySet()) {
                double count2 = entry.getValue();
                if (!(count2 >= (double)this.options_.getMinCount().intValue())) continue;
                EditTree tree = (EditTree)entry.getKey();
                list.add(tree);
            }
        }
        return new EditTreeGenerator(this.options_.getUnknown(), list_map);
    }

    @Override
    public LemmaOptions getOptions() {
        return this.options_;
    }

    public static class EditTreeGeneratorTrainerOptions
    extends LemmaOptions {
        private static final long serialVersionUID = 1L;
        public static final String MIN_COUNT = "min-count";
        public static final String NUM_STEPS = "num-steps";
        public static final String TAG_DEPENDENT = "tag-dependent";
        public static final String UNKNOWN = "unknown";
        public static final String MAX_DEPTH = "max-depth";

        public EditTreeGeneratorTrainerOptions() {
            this.map_.put(MIN_COUNT, 1);
            this.map_.put(NUM_STEPS, 1);
            this.map_.put(TAG_DEPENDENT, false);
            this.map_.put(UNKNOWN, "<UNKNOWN>");
            this.map_.put(MAX_DEPTH, -1);
        }

        public int getNumSteps() {
            return (Integer)this.getOption(NUM_STEPS);
        }

        public boolean getIsTagDependent() {
            return (Boolean)this.getOption(TAG_DEPENDENT);
        }

        public String getUnknown() {
            return (String)this.getOption(UNKNOWN);
        }

        public Integer getMinCount() {
            return (Integer)this.getOption(MIN_COUNT);
        }

        public int getMaxDepth() {
            return (Integer)this.getOption(MAX_DEPTH);
        }
    }
}

