/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.ForEachAdjunct;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.IterateAction;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.IterateInstr;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;

public class IterateAdjunct
extends TransmissionAdjunct
implements FeedMaker {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        IterateInstr exp = (IterateInstr)this.getExpression();
        PostureAndSweep initiallyPS = Streamability.getStreamability(exp.getInitiallyExp(), contextInfo, reasons);
        if (initiallyPS.getSweep() != Sweep.MOTIONLESS) {
            if (reasons != null) {
                reasons.add("The xsl:param initializer is not motionless");
            }
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        PostureAndSweep finallyPS = Streamability.getStreamability(exp.getOnCompletion(), contextInfo, reasons);
        if (finallyPS.getSweep() != Sweep.MOTIONLESS) {
            if (reasons != null) {
                reasons.add("The xsl:on-completion expression is not motionless");
            }
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        return ForEachAdjunct.getStreamability(exp, contextInfo, reasons);
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Expression select = ((IterateInstr)this.getExpression()).getSelectExpression();
        Expression action = ((IterateInstr)this.getExpression()).getActionExpression();
        Configuration config = this.getConfiguration();
        if (Streamability.getPosture(select) == Posture.GROUNDED) {
            return null;
        }
        Inversion body = null;
        if (Streamability.getSweep(action) == Sweep.CONSUMING) {
            body = Inversion.invertExpression(action, forGrouping);
        }
        Inversion actionInversion = body;
        Pattern selection = StreamingPatternMaker.makeStreamingPattern(select, config, null);
        StreamingAdjunct sa = StreamingAdjunct.makeStreamingAdjunct(config, select);
        return (watchManager, out, context) -> {
            IterateAction actor = new IterateAction(watchManager, this.getExpression(), out, context);
            actor.setInversion(actionInversion);
            if (selection != null) {
                return new Trigger(selection, actor, context);
            }
            return ((TransmissionAdjunct)sa).makeTransmissionFlow(watchManager, select, actor, context);
        };
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return new IterateAction(watchManager, this.getExpression(), out, context);
    }
}

