/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import javax.xml.transform.TransformerException;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.value.AnyExternalObject;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;

public class TransformFn
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        try {
            Builder builder;
            AnyExternalObject templatesObject = (AnyExternalObject)arguments[0].head();
            if (templatesObject == null) {
                return EmptySequence.getInstance();
            }
            PreparedStylesheet pss = (PreparedStylesheet)templatesObject.getWrappedObject();
            NodeInfo source = (NodeInfo)arguments[1].head();
            if (source == null) {
                return EmptySequence.getInstance();
            }
            XsltController transformer = pss.newController();
            GlobalParameterSet params = new GlobalParameterSet();
            if (arguments.length == 3) {
                Item param;
                SequenceIterator iter = arguments[2].iterate();
                block6: while ((param = iter.next()) != null) {
                    if (param instanceof NodeInfo) {
                        switch (((NodeInfo)param).getNodeKind()) {
                            case 1: 
                            case 2: {
                                TransformFn.setTransformerParameter(param, params);
                                continue block6;
                            }
                            case 9: {
                                for (NodeInfo nodeInfo : ((NodeInfo)param).children(NodeKindTest.ELEMENT)) {
                                    TransformFn.setTransformerParameter(nodeInfo, params);
                                }
                                continue block6;
                            }
                        }
                        throw new XPathException("Parameters passed to saxon:transform() must be element, attribute, or document nodes");
                    }
                    if (param instanceof MapItem) {
                        for (KeyValuePair keyValuePair : ((MapItem)param).keyValuePairs()) {
                            AtomicValue key = keyValuePair.key;
                            GroundedValue val = keyValuePair.value.materialize();
                            if (key instanceof StringValue) {
                                params.put(new StructuredQName("", NamespaceUri.NULL, key.getStringValue()), val);
                                continue;
                            }
                            if (!(key instanceof QNameValue)) continue;
                            params.put(((QNameValue)key).getStructuredQName(), val);
                        }
                        continue;
                    }
                    throw new XPathException("Parameters passed to saxon:transform() must be nodes");
                }
            }
            if ((builder = context.getController().makeBuilder()) instanceof TinyBuilder) {
                ((TinyBuilder)builder).setStatistics(context.getConfiguration().getTreeStatistics().RESULT_TREE_STATISTICS);
            }
            transformer.setApplyFunctionConversionRulesToExternalVariables(true);
            transformer.initializeController(params);
            transformer.applyTemplates(source, new TreeReceiver(builder));
            NodeInfo result = builder.getCurrentRoot();
            if (result == null) {
                return EmptySequence.getInstance();
            }
            return result;
        }
        catch (TransformerException e) {
            throw XPathException.makeXPathException(e);
        }
    }

    private static void setTransformerParameter(Item param, GlobalParameterSet params) throws XPathException {
        NodeName name = NameOfNode.makeName((NodeInfo)param);
        AtomicSequence val = param.atomize();
        params.put(name.getStructuredQName(), val);
    }
}

