/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.local;

import net.sf.saxon.expr.number.AbstractNumberer;
import net.sf.saxon.str.BMPString;

public class Numberer_de
extends AbstractNumberer {
    private static final String[] germanUnits = new String[]{"", "Ein", "Zwei", "Drei", "Vier", "F\u00fcnf", "Sechs", "Sieben", "Acht", "Neun", "Zehn", "Elf", "Zw\u00f6lf", "Dreizehn", "Vierzehn", "F\u00fcnfzehn", "Sechzehn", "Siebzehn", "Achtzehn", "Neunzehn"};
    private static final String[] germanTens = new String[]{"", "Zehn", "Zwanzig", "Drei\u00dfig", "Vierzig", "F\u00fcnfzig", "Sechzig", "Siebzig", "Achtzig", "Neunzig"};
    private static final String[] germanOrdinalUnits = new String[]{"Nullt", "Erst", "Zweit", "Dritt", "Viert", "F\u00fcnft", "Sechst", "Siebt", "Acht", "Neunt", "Zehnt", "Elft", "Zw\u00f6lft", "Dreizehnt", "Vierzehnt", "F\u00fcnfzehnt", "Sechszehnt", "Siebzehnt", "Achtzehnt", "Neunzehnt"};
    private static final String[] germanMonths = new String[]{"Januar", "Februar", "M\u00e4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"};
    private static final String[] germanDays = new String[]{"Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag", "Sonntag"};

    @Override
    protected String ordinalSuffix(String ordinalParam, long number) {
        return ".";
    }

    @Override
    public String toWords(String cardinal, long number) {
        if (number >= 1000000000000000L) {
            return this.format(number, BMPString.of("1.000.000"), 3, ".", "", "", "");
        }
        if (number >= 1000000000000L) {
            long rem = number % 1000000000000L;
            long n = number / 1000000000000L;
            String s = n == 1L ? "Eine" : this.toWords(cardinal, n);
            return s + " Billion" + (rem == 0L ? "" : ' ' + this.toWords(cardinal, rem));
        }
        if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            long n = number / 1000000000L;
            String s = n == 1L ? "Eine" : this.toWords(cardinal, n);
            return s + " Milliarde" + (rem == 0L ? "" : ' ' + this.toWords(cardinal, rem));
        }
        if (number >= 1000000L) {
            long rem = number % 1000000L;
            long n = number / 1000000L;
            String s = n == 1L ? "Eine" : this.toWords(cardinal, n);
            return s + " Million" + (n == 1L ? "" : "en") + (rem == 0L ? "" : this.toWords(cardinal, rem));
        }
        if (number >= 1000L) {
            long rem = number % 1000L;
            long n = number / 1000L;
            String s = n == 1L ? "Ein" : this.toWords(cardinal, n);
            return s + "tausend" + (rem == 0L ? "" : this.toWords(cardinal, rem, 1));
        }
        if (number >= 100L) {
            long rem = number % 100L;
            long n = number / 100L;
            String s = n == 1L ? "Ein" : this.toWords(cardinal, n);
            return s + "hundert" + (rem == 0L ? "" : this.toWords(cardinal, rem, 1));
        }
        if (number < 20L) {
            return number == 0L ? "Null" : (number == 1L ? "Eins" : germanUnits[(int)number]);
        }
        int rem = (int)(number % 10L);
        int tens = (int)number / 10;
        return germanUnits[rem] + (rem == 0 ? "" : "und") + germanTens[tens];
    }

    @Override
    public String zero() {
        return "Null";
    }

    @Override
    public String toOrdinalWords(String ordinalParam, long number, int wordCase) {
        String suffix = "e";
        if (ordinalParam.equalsIgnoreCase("-er")) {
            suffix = "er";
        } else if (ordinalParam.equalsIgnoreCase("-es")) {
            suffix = "es";
        } else if (ordinalParam.equalsIgnoreCase("-en")) {
            suffix = "en";
        }
        long mod100 = number % 100L;
        if (number < 20L) {
            String ord = germanOrdinalUnits[(int)number] + suffix;
            if (wordCase == 0) {
                return ord.toUpperCase();
            }
            if (wordCase == 1) {
                return ord.toLowerCase();
            }
            return ord;
        }
        if (mod100 < 20L && mod100 > 0L) {
            return this.toWords("", number - mod100, wordCase) + this.toOrdinalWords(ordinalParam, mod100, wordCase == 2 ? 1 : wordCase);
        }
        String ending = "st" + suffix;
        if (wordCase == 0) {
            ending = ending.toUpperCase();
        }
        return this.toWords("", number, wordCase) + (wordCase == 0 ? ending.toUpperCase() : ending);
    }

    @Override
    public String monthName(int month, int minWidth, int maxWidth) {
        String name = germanMonths[month - 1];
        if (maxWidth < 3) {
            maxWidth = 3;
        }
        if (name.length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = name + " ";
        }
        return name;
    }

    @Override
    public String dayName(int day, int minWidth, int maxWidth) {
        String name = germanDays[day - 1];
        if (maxWidth < 10) {
            name = name.substring(0, 2);
        }
        while (name.length() < minWidth) {
            name = name + ' ';
        }
        return name;
    }

    @Override
    public String getOrdinalSuffixForDateTime(String component) {
        return "-e";
    }

    @Override
    public String getEraName(int year) {
        return year <= 0 ? "v. Chr." : "n. Chr.";
    }

    @Override
    public String getCalendarName(String code) {
        if (code.equals("AD")) {
            return "Gregorianisch";
        }
        return code;
    }
}

