/*
 * Decompiled with CFR 0.152.
 */
package marmot.tokenize.rules;

import java.io.Serializable;
import java.util.Collection;
import java.util.regex.Matcher;
import marmot.tokenize.rules.Rule;

public class RulebasedTransformator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Collection<Rule> rules_;

    public RulebasedTransformator(Collection<Rule> rules) {
        this.rules_ = rules;
    }

    public String applyRules(String string) {
        return this.applyRules(string, this.rules_);
    }

    private String applyRules(String string, Collection<Rule> rules) {
        StringBuilder sb = new StringBuilder();
        for (Rule rule : rules) {
            Matcher matcher = rule.pattern.matcher(string);
            int end = 0;
            int start = 0;
            while (matcher.find(start)) {
                start = matcher.start(1);
                if (end > start) {
                    start = end;
                    continue;
                }
                sb.append(string.substring(end, start));
                sb.append(rule.replacement);
                end = matcher.end(1);
            }
            sb.append(string.substring(end));
            string = sb.toString();
            sb.setLength(0);
        }
        return string;
    }
}

