/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn.pedigree;

import com.saxonica.xsltextn.pedigree.DelegatingArrayItem;
import com.saxonica.xsltextn.pedigree.Pedigree;
import com.saxonica.xsltextn.pedigree.PedigreeValue;
import java.util.ArrayList;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.om.GroundedValue;

public class PedigreeArrayItem
extends DelegatingArrayItem
implements PedigreeValue {
    Pedigree pedigree;

    public PedigreeArrayItem(ArrayItem base) {
        this(base, Pedigree.PEDIGREE_ROOT);
    }

    public PedigreeArrayItem(ArrayItem base, Pedigree pedigree) {
        super(base);
        this.pedigree = pedigree;
    }

    @Override
    public GroundedValue get(int index) {
        GroundedValue value = super.get(index);
        Pedigree ped = new Pedigree((PedigreeValue)this, index);
        return ped.makePedigreeValue(value);
    }

    @Override
    public ArrayItem remove(int index) {
        ArrayList<GroundedValue> list = new ArrayList<GroundedValue>(this.arrayLength() - 1);
        int i = 0;
        for (GroundedValue seq : super.remove(index).members()) {
            if (i == index) {
                // empty if block
            }
            int n = ++i;
            ++i;
            Pedigree ped = new Pedigree((PedigreeValue)this, n);
            list.add(ped.makePedigreeValue(seq));
        }
        return new SimpleArrayItem(list);
    }

    @Override
    public ArrayItem subArray(int start, int end) {
        ArrayList<GroundedValue> list = new ArrayList<GroundedValue>(end - start);
        int index = start;
        for (GroundedValue seq : super.subArray(start, end).members()) {
            Pedigree ped = new Pedigree((PedigreeValue)this, index++);
            list.add(ped.makePedigreeValue(seq));
        }
        return new SimpleArrayItem(list);
    }

    @Override
    public Iterable<GroundedValue> members() {
        ArrayList<GroundedValue> memberValues = new ArrayList<GroundedValue>();
        int index = 0;
        for (GroundedValue val : super.members()) {
            Pedigree ped = new Pedigree((PedigreeValue)this, index++);
            memberValues.add(ped.makePedigreeValue(val));
        }
        return memberValues;
    }

    @Override
    public Pedigree getPedigree() {
        return this.pedigree;
    }

    @Override
    public ArrayItem getBaseItem() {
        return super.getBaseItem();
    }
}

