/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.jaxp;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.jaxp.SchemaFactoryImpl;
import java.io.IOException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.Sink;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.type.SchemaException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class ValidatingReader
implements XMLReader {
    private EnterpriseConfiguration config;
    private XMLReader parser;
    private ContentHandler contentHandler;

    public ValidatingReader() {
        this(new EnterpriseConfiguration());
    }

    public ValidatingReader(EnterpriseConfiguration config) {
        this(config, config.getSourceParser());
    }

    public ValidatingReader(EnterpriseConfiguration config, XMLReader parser) {
        this.config = config;
        this.parser = parser;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.startsWith("http://saxon.sf.net/")) {
            try {
                Object result = this.config.getConfigurationProperty(name);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                throw new SAXNotRecognizedException("Feature name " + name + " is recognized, but is not boolean");
            }
            catch (IllegalArgumentException e) {
                throw new SAXNotRecognizedException(e.getMessage());
            }
        }
        return this.parser.getFeature(name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.startsWith("http://saxon.sf.net/")) {
            try {
                this.config.setBooleanProperty(name, value);
            }
            catch (IllegalArgumentException err) {
                throw new SAXNotRecognizedException(err.getMessage());
            }
        } else if (!(name.equals("http://xml.org/sax/features/validation") || name.equals("http://apache.org/xml/features/validation/schema") || name.equals("http://apache.org/xml/features/validation/schema-full-checking") || name.equals("http://apache.org/xml/features/disallow-doctype-decl"))) {
            this.parser.setFeature(name, value);
        }
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.startsWith("http://saxon.sf.net/")) {
            try {
                return this.config.getConfigurationProperty(name);
            }
            catch (IllegalArgumentException err) {
                throw new SAXNotRecognizedException(err.getMessage());
            }
        }
        return this.parser.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.startsWith("http://saxon.sf.net/")) {
            try {
                this.config.setConfigurationProperty(name, value);
            }
            catch (IllegalArgumentException err) {
                throw new SAXNotRecognizedException(err.getMessage());
            }
        } else if (name.equals("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation")) {
            try {
                this.config.addSchemaSource(new StreamSource((String)value));
            }
            catch (SchemaException err) {
                throw new SAXNotSupportedException("Error in no-namespace schema document: " + err.getMessage());
            }
        } else if (name.equals("http://apache.org/xml/properties/schema/external-schemaLocation")) {
            int space = value.toString().indexOf(32);
            if (space <= 0) {
                throw new SAXNotSupportedException("Value of property " + name + " contains no space. Value should contain namespace URI and schema location URI, space-separated.");
            }
            String locationURI = value.toString().substring(space + 1);
            try {
                this.config.addSchemaSource(new StreamSource(locationURI));
            }
            catch (SchemaException err) {
                throw new SAXNotSupportedException("Error in schema document: " + err.getMessage());
            }
        } else {
            this.parser.setProperty(name, value);
        }
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.parser.setEntityResolver(resolver);
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.parser.getEntityResolver();
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.parser.setDTDHandler(handler);
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.parser.getDTDHandler();
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.parser.setErrorHandler(handler);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.parser.getErrorHandler();
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.setValidator(input.getSystemId());
        this.parser.parse(input);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.setValidator(systemId);
        this.parser.parse(systemId);
    }

    private void setValidator(String systemId) {
        Receiver output;
        PipelineConfiguration pipe = this.config.makePipelineConfiguration();
        pipe.setHostLanguage(52);
        pipe.setErrorListener(new SchemaFactoryImpl.ErrorListenerWrappingErrorHandler(this.parser.getErrorHandler()));
        if (this.contentHandler == null) {
            output = new Sink(pipe);
        } else {
            ContentHandlerProxy chp = new ContentHandlerProxy();
            chp.setUnderlyingContentHandler(this.contentHandler);
            chp.setPipelineConfiguration(pipe);
            output = chp;
        }
        ParseOptions options = pipe.getParseOptions();
        options.setCheckEntityReferences(true);
        options.setSchemaValidationMode(this.config.getSchemaValidationMode() == 2 ? 2 : 1);
        options.setTopLevelElement(this.config.getParseOptions().getTopLevelElement());
        options.setTopLevelType(this.config.getParseOptions().getTopLevelType());
        options.setSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance());
        Receiver receiver = this.config.getDocumentValidator(output, systemId, options, null);
        ReceivingContentHandler rch = new ReceivingContentHandler();
        rch.setPipelineConfiguration(output.getPipelineConfiguration());
        rch.setReceiver(receiver);
        this.parser.setContentHandler(rch);
    }
}

