/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.AttributeUse;
import com.saxonica.ee.schema.AttributeWildcard;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.Wildcard;
import com.saxonica.ee.validate.ContentValidator;
import com.saxonica.ee.validate.LaxValidator;
import com.saxonica.ee.validate.SkipValidator;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.AttributeLocation;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntToIntMap;

public abstract class AttributeValidator
extends ContentValidator {
    private IntHashMap<AttributeUse> declaredAttributes;
    private IntToIntMap attributeCounterMap;
    private boolean[] found;
    private AttributeWildcard attributeWildcard = null;
    private int idAttributes = 0;
    SimpleType latestAttributeType = null;

    public AttributeValidator(Receiver next) {
        super(next);
    }

    public void setAttributeGroup(AttributeGroupDecl attributeGroup) throws MissingComponentException {
        if (attributeGroup != null) {
            this.attributeWildcard = attributeGroup.getAttributeWildcard(null);
            this.declaredAttributes = attributeGroup.getDeclaredAttributes();
            this.attributeCounterMap = attributeGroup.getCounterMap();
            this.found = new boolean[this.attributeCounterMap.size()];
        }
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, Location location, int properties) throws XPathException {
        int fingerprint = attName.obtainFingerprint(this.getNamePool());
        if (fingerprint == 642) {
            if (this.getNillability() == ContentValidator.Nillability.DISALLOWED) {
                String message = "The element is not nillable, so xsi:nil must not be present";
                ValidationFailure ve = new ValidationFailure(message);
                ve.setConstraintReference(1, "cvc-elt", "3.1");
                ve.setSchemaType(this.getSchemaType());
                this.reportValidationError(ve, true, this.makeAttributeLocation(attName, location));
            }
            String b = Whitespace.trim(value.toString());
            if (this.getNillability() != ContentValidator.Nillability.IGNORED && (b.equals("true") || b.equals("1"))) {
                this.nil = true;
            }
        }
        SimpleType annotation = typeCode;
        AttributeUse use = this.declaredAttributes == null ? null : this.declaredAttributes.get(fingerprint);
        AttributeDecl decl = null;
        if (use != null && !use.isProhibited()) {
            decl = (AttributeDecl)use.getTarget();
            int counter = this.attributeCounterMap.get(fingerprint);
            if (counter != this.attributeCounterMap.getDefaultValue()) {
                this.found[counter] = true;
            }
        } else {
            boolean implicitlyAllowed = false;
            String uri = attName.getURI();
            if (uri.equals("http://www.w3.org/2001/XMLSchema-instance") && (fingerprint == 641 || fingerprint == 642 || fingerprint == 643 || fingerprint == 644)) {
                implicitlyAllowed = true;
            }
            if (!implicitlyAllowed) {
                ValidationFailure ve;
                String message;
                if (this.attributeWildcard != null) {
                    String process;
                    if (!this.attributeWildcard.getWildcard().matches(attName, false, this.getConfiguration(), null)) {
                        String reason = this.attributeWildcard.getWildcard().reasonForNonMatch(attName, false, this.getConfiguration(), null);
                        message = "Attribute " + Err.wrap(attName.getDisplayName(), 2) + " is not allowed on " + this.getContainingElementName() + ". " + reason;
                        ve = new ValidationFailure(message);
                        ve.setConstraintReference(1, "cvc-complex-type", "3.2.1");
                        ve.setSchemaType(this.getSchemaType());
                        this.reportValidationError(ve, false, this.makeAttributeLocation(attName, location));
                    }
                    if (!(process = this.attributeWildcard.getWildcard().getProcessContents()).equals("skip") && (decl = (AttributeDecl)this.getConfiguration().getAttributeDeclaration(attName.getStructuredQName())) == null && process.equals("strict")) {
                        message = "The <xs:anyAttribute> that matches attribute " + Err.wrap(attName.getDisplayName(), 2) + " requires strict validation, but no attribute declaration is available";
                        ve = new ValidationFailure(message);
                        ve.setConstraintReference(1, "cvc-wildcard", "2");
                        ve.setSchemaType(this.getSchemaType());
                        this.reportValidationError(ve, false, this.makeAttributeLocation(attName, location));
                    }
                } else {
                    String possibleNamespaceMessage = "";
                    if (this.declaredAttributes != null) {
                        Iterator<AttributeUse> ii = this.declaredAttributes.valueIterator();
                        while (ii.hasNext()) {
                            AttributeUse au = ii.next();
                            if (!au.getTargetComponentName().getLocalPart().equals(attName.getLocalPart())) continue;
                            String ns = au.getTargetComponentName().getURI();
                            if (ns.isEmpty()) {
                                possibleNamespaceMessage = " (it would be allowed in no namespace)";
                                break;
                            }
                            possibleNamespaceMessage = " (it would be allowed in namespace " + ns + ")";
                            break;
                        }
                    }
                    message = "Attribute " + Err.wrap(attName.getDisplayName(), 2) + " is not allowed on " + this.getContainingElementName() + possibleNamespaceMessage;
                    ve = new ValidationFailure(message);
                    ve.setConstraintReference(1, "cvc-complex-type", "3");
                    ve.setSchemaType(this.getSchemaType());
                    this.reportValidationError(ve, true, this.makeAttributeLocation(attName, location));
                }
            }
        }
        if (decl != null) {
            ValidationFailure err;
            ValidationFailure ve;
            String message;
            SimpleType type;
            this.latestAttributeType = type = decl.getSimpleType();
            if (type.getBuiltInBaseType().getFingerprint() == 560) {
                ++this.idAttributes;
                if (this.idAttributes == 2 && this.getConfiguration().getXsdVersion() == 10) {
                    message = "Element has more than one ID attribute";
                    ve = new ValidationFailure(message);
                    ve.setConstraintReference(1, "cvc-complex-type", "5");
                    ve.setSchemaType(this.getSchemaType());
                    this.reportValidationError(ve, false, this.makeAttributeLocation(attName, location));
                }
            }
            if (type.getFingerprint() == 531) {
                message = "Cannot validate against type xs:NOTATION (only against a subtype defining an enumeration of values)";
                ve = new ValidationFailure(message);
                ve.setConstraintReference(1, "enumeration-required-notation", "0");
                ve.setSchemaType(this.getSchemaType());
                this.reportValidationError(ve, false, location);
            }
            if ((err = type.validateContent(value, this.getNamespaceResolver(), this.getConfiguration().getConversionRules())) != null) {
                err.setConstraintReference(2, "cvc-complex-type", "3");
                AttributeLocation attLocation = this.makeAttributeLocation(attName, location);
                this.reportValidationError(err, false, attLocation);
            } else {
                if (type instanceof UserAtomicType) {
                    value = ((UserAtomicType)type).getSharedInstance(value.toString());
                }
                annotation = type;
                boolean matchesFixed = true;
                if (use != null && use.getFixedValueConstraint() != null) {
                    matchesFixed = use.getFixedValueConstraint().testFixedValue(this.getConfiguration(), value, type, this.getNamespaceResolver());
                }
                if (decl.getFixedValueConstraint() != null) {
                    boolean bl = matchesFixed = matchesFixed && decl.getFixedValueConstraint().testFixedValue(this.getConfiguration(), value, type, this.getNamespaceResolver());
                }
                if (!matchesFixed) {
                    AtomicSequence fixed = use != null ? use.getUnderlyingFixedValue() : decl.getFixedValue();
                    String message2 = "The actual value " + Err.wrap(value, 4) + " of attribute " + Err.wrap(attName.getDisplayName(), 2) + " does not match the required fixed value " + (fixed instanceof AtomicValue ? Err.wrap(fixed.getStringValue(), 4) : "");
                    ValidationFailure ve2 = new ValidationFailure(message2);
                    ve2.setConstraintReference(1, "cvc-au", "0");
                    ve2.setSchemaType(this.getSchemaType());
                    this.reportValidationError(ve2, false, this.makeAttributeLocation(attName, location));
                }
            }
        }
        if (use != null && use.isInheritable() || use == null && decl != null && decl.isInheritable()) {
            this.getStartTagBuffer().notifyInheritableAttribute(attName, value.toString(), location, properties);
        }
        this.nextReceiver.attribute(attName, annotation, value, location, properties);
    }

    private AttributeLocation makeAttributeLocation(NodeName attName, Location location) {
        return new AttributeLocation(this.getContainingElement(), attName.getStructuredQName(), location);
    }

    public SimpleType getMostRecentAttributeType() {
        return this.latestAttributeType;
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.idAttributes = 0;
        this.checkNoChildrenWhenNil(location);
        super.startElement(nameCode, typeCode, location, properties);
    }

    @Override
    public final void startContent() throws XPathException {
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        if (this.declaredAttributes != null) {
            IntIterator iter2 = this.declaredAttributes.keyIterator();
            while (iter2.hasNext()) {
                ValidationFailure err;
                int key = iter2.next();
                int counter = this.attributeCounterMap.get(key);
                if (this.found[counter]) continue;
                AttributeUse use = this.declaredAttributes.get(key);
                if (use.isRequired()) {
                    String name = use.getTargetComponentName().getEQName();
                    String message = "Required attribute " + Err.wrap(name, 2) + " is missing on " + this.getContainingElementName();
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setConstraintReference(1, "cvc-complex-type", "4");
                    ve.setSchemaType(this.getSchemaType());
                    this.reportValidationError(ve, true, this.getContainingElementLocationId());
                    continue;
                }
                if (!pipe.getParseOptions().isExpandAttributeDefaults()) continue;
                String value = use.getUnderlyingDefaultValue();
                if (value == null) {
                    AtomicSequence fixed = use.getUnderlyingFixedValue();
                    String string = value = fixed == null ? null : fixed.getStringValue();
                }
                if (value == null) continue;
                if (use.getAttributeDeclaration().getSimpleType().isNamespaceSensitive() && (err = use.getAttributeDeclaration().getSimpleType().validateContent(value, this.getNamespaceResolver(), this.getConfiguration().getConversionRules())) != null) {
                    String message = "The namespace-sensitive default value is invalid in the namespace context where it is being used";
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setSchemaType(this.getSchemaType());
                    this.reportValidationError(ve, true, this.getContainingElementLocationId());
                }
                NamePool pool = this.getNamePool();
                String uri = use.getTargetComponentName().getURI();
                String prefix = null;
                if (uri.isEmpty()) {
                    prefix = "";
                } else {
                    NamespaceResolver resolver = this.getNamespaceResolver();
                    Iterator<String> iter = resolver.iteratePrefixes();
                    while (iter.hasNext()) {
                        String p = iter.next();
                        if (p.isEmpty() || !uri.equals(resolver.getURIForPrefix(p, false))) continue;
                        prefix = p;
                        break;
                    }
                    if (prefix == null) {
                        String u;
                        prefix = use.getTargetComponentName().getPrefix();
                        if (prefix.isEmpty()) {
                            prefix = pool.suggestPrefixForURI(uri);
                        }
                        if (prefix == null) {
                            prefix = "ns";
                        }
                        while ((u = this.getNamespaceResolver().getURIForPrefix(prefix, false)) != null && !u.equals(uri)) {
                            prefix = prefix + "1";
                        }
                        this.nextReceiver.namespace(new NamespaceBinding(prefix, uri), 0);
                    }
                }
                this.nextReceiver.attribute(new CodedName(key, prefix, this.getNamePool()), use.getAttributeDeclaration().getSimpleType(), value, ExplicitLocation.UNKNOWN_LOCATION, 8);
            }
        }
        this.nextReceiver.startContent();
        if (this.locallyInvalid && this.pendingMessages != null) {
            for (String pendingMessage : this.pendingMessages) {
                this.nextReceiver.comment(pendingMessage, ExplicitLocation.UNKNOWN_LOCATION, 0);
            }
        }
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.checkNoCharactersWhenNil(locationId);
        this.nextReceiver.characters(chars, locationId, properties);
    }

    protected SchemaType processWildcardTerm(Wildcard card, NodeName elementName, Location locationId) throws XPathException {
        UserComplexType containingType;
        SchemaType annotation;
        StructuredQName elementQName = elementName.getStructuredQName();
        int fingerprint = elementName.getFingerprint();
        Configuration config = this.getConfiguration();
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        String mode = card.getProcessContents();
        SchemaType xsiType = this.getValidationContext().getXSIType();
        switch (mode) {
            case "strict": {
                ElementDecl decl = (ElementDecl)this.getConfiguration().getElementDeclaration(fingerprint);
                if (decl == null) {
                    if (xsiType == null) {
                        String message = "No element declaration found for element " + Err.wrap(elementName.getDisplayName(), 1);
                        if (this.getContainingElement() != null) {
                            message = "In content of " + this.getContainingElementName() + ": " + message;
                        }
                        ValidationFailure ve = new ValidationFailure(message);
                        ve.setConstraintReference(1, "cvc-wildcard", "2");
                        ve.setSchemaType(this.getSchemaType());
                        this.reportValidationError(ve, true, locationId);
                        AnyType annotation2 = AnyType.getInstance();
                        return annotation2;
                    }
                    this.makeChildValidator(null, elementQName, locationId, 0);
                } else {
                    this.makeChildValidator(decl, elementQName, locationId, 0);
                }
                this.childValidator.setContainingElement(elementName.getStructuredQName(), locationId);
                annotation = this.childValidator.getAnnotation();
                break;
            }
            case "lax": {
                ElementDecl decl = (ElementDecl)this.getConfiguration().getElementDeclaration(fingerprint);
                if (decl == null) {
                    if (xsiType != null) {
                        ArrayList<ValidationFailure> failures = new ArrayList<ValidationFailure>(1);
                        this.childValidator = AttributeValidator.makeValidator(null, elementQName, locationId, this.getValidationContext(), xsiType, 0, pipe, this.getNextReceiver(), failures);
                        if (!failures.isEmpty()) {
                            this.reportValidationError((ValidationFailure)failures.get(0), true, locationId);
                            this.childValidator = new SkipValidator(this.getNextReceiver());
                            annotation = AnyType.getInstance();
                            break;
                        }
                        annotation = this.childValidator.getAnnotation();
                        break;
                    }
                    this.childValidator = new LaxValidator(this.getNextReceiver());
                    this.childValidator.setContainingElement(elementQName, locationId);
                    annotation = AnyType.getInstance();
                    break;
                }
                this.makeChildValidator(decl, elementQName, locationId, 0);
                this.childValidator.setContainingElement(elementQName, locationId);
                annotation = this.childValidator.getAnnotation();
                break;
            }
            default: {
                annotation = AnyType.getInstance();
                this.childValidator = new SkipValidator(this.getNextReceiver());
                this.childValidator.setValidationContext(this.getValidationContext());
            }
        }
        if (!(this.childValidator instanceof SkipValidator) && (containingType = (UserComplexType)this.getSchemaType()).getLanguageVersion() != 10) {
            SchemaType contextDeterminedType = containingType.getContextDeterminedTypeForElement(elementQName);
            SchemaType governingType = this.childValidator.getSchemaType();
            if (contextDeterminedType != null && governingType != null) {
                try {
                    config.checkTypeDerivationIsOK(governingType, contextDeterminedType, 0);
                }
                catch (SchemaException err) {
                    String message = "The governing type (" + governingType.getDescription() + ") of the " + Err.wrap(elementName.getDisplayName(), 1) + " element which matches against a wildcard is not substitutable for the context-determined type of the element particle named " + elementName.getDisplayName() + " within the content model of type " + containingType.getDescription() + ". " + err.getMessage();
                    ValidationFailure verr = new ValidationFailure(message);
                    verr.setConstraintReference(1, "cvc-complex-type", "5");
                    verr.setSchemaType(this.getSchemaType());
                    this.reportValidationError(verr, true, locationId);
                }
            }
        }
        return annotation;
    }
}

