/*
 * Decompiled with CFR 0.152.
 */
package marmot.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import marmot.core.Options;
import marmot.core.Sequence;
import marmot.core.State;
import marmot.core.Token;
import marmot.util.SymbolTable;

public abstract class Model
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BORDER_SYMBOL_ = "<STOP>";
    public static final String EMPTY_SYMBOL_ = "<EMPTY>";
    private Options options_;
    private List<SymbolTable<String>> tag_tables_;
    private SymbolTable<String> catgegory_table_;
    private int order_;
    private int boundary_index_;

    public State getBoundaryState(int level) {
        State state = new State(this.boundary_index_);
        for (int clevel = 0; clevel < level; ++clevel) {
            state = new State(this.boundary_index_, state);
        }
        return state;
    }

    public void init(Options options, SymbolTable<String> category_tables) {
        this.options_ = options;
        this.order_ = options.getOrder();
        this.catgegory_table_ = category_tables;
        this.tag_tables_ = new ArrayList<SymbolTable<String>>(this.catgegory_table_.size());
        for (int index = 0; index < this.catgegory_table_.size(); ++index) {
            SymbolTable<String> tag_table = new SymbolTable<String>(true);
            tag_table.toIndex(BORDER_SYMBOL_, true);
            this.tag_tables_.add(tag_table);
        }
        this.boundary_index_ = 0;
    }

    public int getBoundaryIndex() {
        return this.boundary_index_;
    }

    public List<SymbolTable<String>> getTagTables() {
        return this.tag_tables_;
    }

    public int getOrder() {
        return this.order_;
    }

    public Options getOptions() {
        return this.options_;
    }

    public SymbolTable<String> getCategoryTable() {
        return this.catgegory_table_;
    }

    public abstract int[] getTagCandidates(Sequence var1, int var2, State var3);

    public abstract void setLemmaCandidates(Token var1, State var2, boolean var3, boolean var4);

    public abstract void setLemmaCandidates(State var1, boolean var2);

    public abstract boolean getMarganlizeLemmas();
}

