/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanDistanceQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.DistanceSpans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public class ElementDistanceExclusionSpans
extends DistanceSpans {
    private Spans elements;
    private boolean hasMoreElements;
    private int elementPosition;
    private boolean isOrdered;
    private boolean hasMoreSecondSpans;
    protected List<CandidateSpan> targetList;
    protected List<CandidateSpan> candidateList;
    private int currentDocNum;
    private int minDistance;
    private int maxDistance;
    private int firstSpanPostion;

    public ElementDistanceExclusionSpans(SpanDistanceQuery query, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(query, context, acceptDocs, termContexts);
        this.elements = query.getElementQuery().getSpans(context, acceptDocs, termContexts);
        this.hasMoreElements = this.elements.next();
        this.hasMoreSpans = this.firstSpans.next() && this.hasMoreElements;
        this.hasMoreSecondSpans = this.secondSpans.next();
        this.elementPosition = 0;
        this.isOrdered = query.isOrdered();
        this.candidateList = new ArrayList<CandidateSpan>();
        this.targetList = new ArrayList<CandidateSpan>();
        this.currentDocNum = this.hasMoreSpans ? this.firstSpans.doc() : Integer.MAX_VALUE;
        this.minDistance = query.getMinDistance();
        this.maxDistance = query.getMaxDistance();
    }

    @Override
    protected boolean advance() throws IOException {
        while (!this.targetList.isEmpty() || this.hasMoreSpans && this.ensureSameDoc(this.firstSpans, this.elements)) {
            if (!(!this.targetList.isEmpty() ? this.isFirstTargetValid() : this.findMatch())) continue;
            return true;
        }
        return false;
    }

    private boolean isFirstTargetValid() throws IOException {
        CandidateSpan target = this.targetList.get(0);
        this.targetList.remove(0);
        this.firstSpanPostion = target.getPosition();
        this.filterCandidateList(this.firstSpanPostion);
        this.collectRightCandidates();
        if (this.isWithinDistance()) {
            return false;
        }
        this.setMatchProperties(target);
        return true;
    }

    private boolean findMatch() throws IOException {
        if (this.firstSpans.doc() != this.currentDocNum) {
            this.currentDocNum = this.firstSpans.doc();
            this.candidateList.clear();
        }
        if (this.hasMoreSecondSpans) {
            if (this.secondSpans.doc() == this.firstSpans.doc()) {
                return this.isFirstSpanValid();
            }
            if (this.secondSpans.doc() < this.firstSpans.doc()) {
                this.hasMoreSecondSpans = this.secondSpans.skipTo(this.firstSpans.doc());
                return false;
            }
        }
        if (this.candidateList.isEmpty()) {
            if (this.isFirstSpanInElement()) {
                this.setMatchProperties(new CandidateSpan(this.firstSpans, this.elementPosition));
                this.hasMoreSpans = this.firstSpans.next();
                return true;
            }
            this.hasMoreSpans = this.firstSpans.next();
            return false;
        }
        return this.isFirstSpanValid();
    }

    private boolean advanceElementTo(Spans span) throws IOException {
        while (this.hasMoreElements && this.elements.doc() == this.currentDocNum && this.elements.start() < span.end()) {
            if (span.start() >= this.elements.start() && span.end() <= this.elements.end()) {
                return true;
            }
            this.hasMoreElements = this.elements.next();
            ++this.elementPosition;
        }
        return false;
    }

    private boolean isFirstSpanValid() throws IOException {
        if (!this.isOrdered) {
            this.collectLeftCandidates();
        }
        if (this.isFirstSpanInElement()) {
            CandidateSpan target = new CandidateSpan(this.firstSpans, this.elementPosition);
            this.hasMoreSpans = this.firstSpans.next();
            if (!this.isOrdered && this.isWithinDistance()) {
                return false;
            }
            this.collectRightCandidates();
            if (this.isWithinDistance()) {
                return false;
            }
            this.setMatchProperties(target);
            return true;
        }
        this.hasMoreSpans = this.firstSpans.next();
        return false;
    }

    private void collectRightCandidates() throws IOException {
        while (this.hasMoreSecondSpans && this.secondSpans.doc() == this.currentDocNum && this.elementPosition <= this.firstSpanPostion + this.maxDistance) {
            if (this.hasMoreSpans && this.firstSpans.start() < this.secondSpans.start() && this.firstSpans.doc() == this.currentDocNum) {
                if (this.advanceElementTo(this.firstSpans)) {
                    this.targetList.add(new CandidateSpan(this.firstSpans, this.elementPosition));
                }
                this.hasMoreSpans = this.firstSpans.next();
                continue;
            }
            if (this.advanceElementTo(this.secondSpans)) {
                this.candidateList.add(new CandidateSpan(this.secondSpans, this.elementPosition));
            }
            this.hasMoreSecondSpans = this.secondSpans.next();
        }
    }

    private void collectLeftCandidates() throws IOException {
        while (this.hasMoreSecondSpans && this.secondSpans.doc() == this.firstSpans.doc() && this.secondSpans.start() < this.firstSpans.end()) {
            if (this.advanceElementTo(this.secondSpans)) {
                this.candidateList.add(new CandidateSpan(this.secondSpans, this.elementPosition));
                this.filterCandidateList(this.elementPosition);
            }
            this.hasMoreSecondSpans = this.secondSpans.next();
        }
    }

    private boolean isWithinDistance() {
        for (CandidateSpan cs : this.candidateList) {
            int actualDistance = cs.getPosition() - this.firstSpanPostion;
            if (!this.isOrdered) {
                actualDistance = Math.abs(actualDistance);
            }
            if (this.minDistance > actualDistance || actualDistance > this.maxDistance) continue;
            return true;
        }
        return false;
    }

    private boolean isFirstSpanInElement() throws IOException {
        if (this.advanceElementTo(this.firstSpans)) {
            this.firstSpanPostion = this.elementPosition;
            this.filterCandidateList(this.firstSpanPostion);
            return true;
        }
        return false;
    }

    private void filterCandidateList(int position) {
        CandidateSpan cs;
        Iterator<CandidateSpan> i = this.candidateList.iterator();
        while (i.hasNext() && (cs = i.next()).getPosition() != position && cs.getPosition() + this.maxDistance < position) {
            i.remove();
        }
    }

    private void setMatchProperties(CandidateSpan match) throws IOException {
        this.matchDocNumber = match.getDoc();
        this.matchStartPosition = match.getStart();
        this.matchEndPosition = match.getEnd();
        if (this.collectPayloads && match.getPayloads() != null) {
            this.matchPayload.addAll(match.getPayloads());
        }
        this.setMatchFirstSpan(match);
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.firstSpans.doc() < target && !this.firstSpans.skipTo(target)) {
            this.hasMoreSpans = false;
            return false;
        }
        return this.advance();
    }

    @Override
    public long cost() {
        return this.elements.cost() + this.firstSpans.cost() + this.secondSpans.cost();
    }
}

