/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanDistanceQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.UnorderedDistanceSpans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public class UnorderedElementDistanceSpans
extends UnorderedDistanceSpans {
    private Spans elements;
    private boolean hasMoreElements;
    private int elementPosition;
    private List<CandidateSpan> elementList;
    private Logger log = LogManager.getLogger(UnorderedElementDistanceSpans.class);
    boolean DEBUG = false;

    public UnorderedElementDistanceSpans(SpanDistanceQuery query, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(query, context, acceptDocs, termContexts);
        this.elements = query.getElementQuery().getSpans(context, acceptDocs, termContexts);
        this.hasMoreElements = this.elements.next();
        this.elementPosition = 0;
        this.elementList = new ArrayList<CandidateSpan>();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean prepareLists() throws IOException {
        if (this.firstSpanList.isEmpty() && this.secondSpanList.isEmpty()) {
            if (this.hasMoreFirstSpans && this.hasMoreSecondSpans && this.hasMoreElements && this.findSameDoc(this.firstSpans, this.secondSpans, this.elements)) {
                if (this.currentDocNum != this.firstSpans.doc()) {
                    this.currentDocNum = this.firstSpans.doc();
                    this.elementList.clear();
                }
                this.hasMoreFirstSpans = this.addSpan(this.firstSpans, this.firstSpanList, this.hasMoreFirstSpans);
                this.hasMoreSecondSpans = this.addSpan(this.secondSpans, this.secondSpanList, this.hasMoreSecondSpans);
                if (!this.DEBUG) return true;
                this.log.debug("prepare firstSpanList: " + this.firstSpanList.size());
                this.log.debug("prepare secondSpanList: " + this.secondSpanList.size());
                return true;
            }
            this.hasMoreSpans = false;
            return false;
        }
        if (this.firstSpanList.isEmpty() && this.hasMoreFirstSpans && this.firstSpans.doc() == this.currentDocNum) {
            this.hasMoreFirstSpans = this.addSpan(this.firstSpans, this.firstSpanList, this.hasMoreFirstSpans);
            return true;
        }
        if (!this.secondSpanList.isEmpty()) return true;
        if (!this.hasMoreSecondSpans) return true;
        if (this.secondSpans.doc() != this.currentDocNum) return true;
        this.hasMoreSecondSpans = this.addSpan(this.secondSpans, this.secondSpanList, this.hasMoreSecondSpans);
        return true;
    }

    private boolean addSpan(Spans span, List<CandidateSpan> list, boolean hasMoreSpan) throws IOException {
        while (hasMoreSpan && span.doc() == this.currentDocNum) {
            int position = this.findElementPosition(span);
            if (position != -1) {
                list.add(new CandidateSpan(span, position));
                hasMoreSpan = span.next();
                return hasMoreSpan;
            }
            hasMoreSpan = span.next();
        }
        return hasMoreSpan;
    }

    private int findElementPosition(Spans span) throws IOException {
        if (!this.elementList.isEmpty() && span.end() <= this.elementList.get(this.elementList.size() - 1).getEnd()) {
            for (CandidateSpan e : this.elementList) {
                if (e.getEnd() < span.end() || e.getStart() > span.start()) continue;
                return e.getPosition();
            }
            return -1;
        }
        return this.advanceElementTo(span) ? this.elementPosition : -1;
    }

    private boolean advanceElementTo(Spans span) throws IOException {
        while (this.hasMoreElements && this.elements.doc() == this.currentDocNum && this.elements.start() < span.end()) {
            if (span.start() >= this.elements.start() && span.end() <= this.elements.end()) {
                return true;
            }
            this.elementList.add(new CandidateSpan(this.elements, this.elementPosition));
            this.hasMoreElements = this.elements.next();
            ++this.elementPosition;
        }
        return false;
    }

    @Override
    protected boolean setCandidateList(List<CandidateSpan> candidateList, Spans candidate, boolean hasMoreCandidates, List<CandidateSpan> targetList) throws IOException {
        if (!targetList.isEmpty()) {
            CandidateSpan target = targetList.get(0);
            while (hasMoreCandidates && candidate.doc() == target.getDoc()) {
                int position = this.findElementPosition(candidate);
                if (position != -1) {
                    CandidateSpan cs = new CandidateSpan(candidate, position);
                    if (!this.isWithinMaxDistance(target, cs)) break;
                    candidateList.add(cs);
                }
                hasMoreCandidates = candidate.next();
            }
        }
        return hasMoreCandidates;
    }

    protected boolean isWithinMaxDistance(CandidateSpan target, CandidateSpan candidate) {
        int targetPos;
        int candidatePos = candidate.getPosition();
        if (candidatePos < (targetPos = target.getPosition()) && candidatePos + this.maxDistance < targetPos) {
            return false;
        }
        return candidatePos <= targetPos || targetPos + this.maxDistance >= candidatePos;
    }

    @Override
    protected List<CandidateSpan> findMatches(CandidateSpan target, List<CandidateSpan> candidateList, boolean isTargetFirstSpan) {
        ArrayList<CandidateSpan> matches = new ArrayList<CandidateSpan>();
        int targetPos = target.getPosition();
        for (CandidateSpan cs : candidateList) {
            int actualDistance = Math.abs(targetPos - cs.getPosition());
            if (this.minDistance == 0 && actualDistance == 0) {
                matches.add(this.createMatchCandidate(target, cs, true, isTargetFirstSpan));
                continue;
            }
            if (this.minDistance > actualDistance || actualDistance > this.maxDistance) continue;
            matches.add(this.createMatchCandidate(target, cs, false, isTargetFirstSpan));
        }
        return matches;
    }

    @Override
    protected void updateList(List<CandidateSpan> candidateList) {
        this.updateElementList(candidateList.get(0).getPosition());
        candidateList.remove(0);
    }

    private void updateElementList(int position) {
        CandidateSpan e;
        Iterator<CandidateSpan> i = this.elementList.iterator();
        if (i.hasNext() && (e = i.next()).getPosition() <= position) {
            i.remove();
        }
    }
}

