/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ApplyTemplatesCompiler;
import com.saxonica.ee.bytecode.ToPushCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.NextMatch;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.rules.BuiltInRuleSet;
import net.sf.saxon.trans.rules.Rule;

public class NextMatchCompiler
extends ToPushCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        NextMatchCompiler.visitAnnotation(compiler, "NextMatch-push");
        NextMatchCompiler.visitLineNumber(compiler, ga, expression);
        NextMatch instr = (NextMatch)expression;
        boolean hasNonTunnelParams = instr.getActualParams() != null;
        int paramsVar = 0;
        if (hasNonTunnelParams) {
            paramsVar = methodInfo.allocateLocal(ParameterSet.class);
            ApplyTemplatesCompiler.compileParameterSet(compiler, this, instr.getActualParams());
            ga.storeLocal(paramsVar);
        }
        int tunnelsVar = methodInfo.allocateLocal(ParameterSet.class);
        ApplyTemplatesCompiler.compileTunnelParameterSet(compiler, this, instr.getTunnelParams());
        ga.storeLocal(tunnelsVar);
        LabelInfo iteratorNotNull = methodInfo.newLabel("iteratorNotNull");
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getCurrentIterator", new Class[0]);
        ga.dup();
        ga.ifNonNull(iteratorNotNull.label());
        compiler.generateDynamicError("Cannot call xsl:next-match when there is no context item", "XTDE0565", instr.getLocation(), false);
        methodInfo.placeLabel(iteratorNotNull);
        ga.invokeInstanceMethod(FocusIterator.class, "current", new Class[0]);
        int currentItemVar = methodInfo.allocateLocal(Item.class);
        ga.storeLocal(currentItemVar);
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getCurrentMode", new Class[0]);
        ga.invokeInstanceMethod(Component.class, "getActor", new Class[0]);
        ga.checkClass(Mode.class);
        int modeVar = methodInfo.allocateLocal(Mode.class);
        ga.dup();
        ga.storeLocal(modeVar);
        ga.loadLocal(currentItemVar);
        LabelInfo templateNotNull = methodInfo.newLabel("templateNotNull");
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getCurrentTemplateRule", new Class[0]);
        ga.dup();
        ga.ifNonNull(templateNotNull.label());
        compiler.generateDynamicError("There is no current template rule", "XTDE0560", instr.getLocation(), false);
        methodInfo.placeLabel(templateNotNull);
        compiler.generateGetContext();
        ga.invokeInstanceMethod(Mode.class, "getNextMatchRule", Item.class, Rule.class, XPathContext.class);
        LabelInfo ruleNotNull = methodInfo.newLabel("ruleNotNull");
        LabelInfo applyEnd = methodInfo.newLabel("applyEnd");
        ga.dup();
        ga.ifNonNull(ruleNotNull.label());
        ga.pop();
        ga.loadLocal(modeVar);
        ga.invokeInstanceMethod(Mode.class, "getBuiltInRuleSet", new Class[0]);
        ga.loadLocal(currentItemVar);
        if (hasNonTunnelParams) {
            ga.loadLocal(paramsVar);
        } else {
            ga.pushNull();
        }
        ga.loadLocal(tunnelsVar);
        compiler.generateGetContext();
        NextMatchCompiler.allocateStatic(compiler, instr.getLocation());
        ga.invokeInstanceMethod(BuiltInRuleSet.class, "process", Item.class, ParameterSet.class, ParameterSet.class, XPathContext.class, Location.class);
        ga.goTo(applyEnd);
        methodInfo.placeLabel(ruleNotNull);
        int ruleVar = methodInfo.allocateLocal(Rule.class);
        ga.storeLocal(ruleVar);
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "newContext", new Class[0]);
        ga.dup();
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getCurrentMode", new Class[0]);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setCurrentComponent", Component.class);
        ga.dup();
        if (hasNonTunnelParams) {
            ga.loadLocal(paramsVar);
        } else {
            ga.pushNull();
        }
        ga.invokeInstanceMethod(XPathContextMajor.class, "setLocalParameters", ParameterSet.class);
        ga.dup();
        ga.loadLocal(tunnelsVar);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setTunnelParameters", ParameterSet.class);
        ga.dup();
        ga.loadLocal(ruleVar);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setCurrentTemplateRule", Rule.class);
        ga.dup();
        NextMatchCompiler.allocateStatic(compiler, expression);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setOrigin", ContextOriginator.class);
        ga.dup();
        ga.loadLocal(ruleVar);
        ga.invokeInstanceMethod(Rule.class, "getAction", new Class[0]);
        ga.checkClass(TemplateRule.class);
        ga.dup();
        ga.invokeInstanceMethod(TemplateRule.class, "initialize", new Class[0]);
        int templateVar = methodInfo.allocateLocal(TemplateRule.class);
        ga.dup();
        ga.storeLocal(templateVar);
        ga.invokeInstanceMethod(TemplateRule.class, "getStackFrameMap", new Class[0]);
        ga.invokeInstanceMethod(XPathContextMajor.class, "openStackFrame", SlotManager.class);
        ga.loadLocal(templateVar);
        ga.swap();
        ga.invokeInstanceMethod(TemplateRule.class, "apply", XPathContextMajor.class);
        methodInfo.placeLabel(applyEnd);
        methodInfo.releaseLocal(paramsVar);
        methodInfo.releaseLocal(tunnelsVar);
        methodInfo.releaseLocal(currentItemVar);
        methodInfo.releaseLocal(modeVar);
        methodInfo.releaseLocal(ruleVar);
        methodInfo.releaseLocal(templateVar);
    }
}

