/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.ee.schema.UserSimpleType;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.Function;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class ExplicitTimezoneFacet
extends Facet {
    public static final int OPTIONAL = 0;
    public static final int REQUIRED = 1;
    public static final int PROHIBITED = 2;
    int facetValue;

    @Override
    public String getName() {
        return "explicitTimezone";
    }

    @Override
    public String getValue() {
        switch (this.facetValue) {
            case 1: {
                return "required";
            }
            case 0: {
                return "optional";
            }
        }
        return "prohibited";
    }

    public void setValue(String value) throws SchemaException {
        switch (value) {
            case "required": {
                this.facetValue = 1;
                break;
            }
            case "optional": {
                this.facetValue = 0;
                break;
            }
            case "prohibited": {
                this.facetValue = 2;
                break;
            }
            default: {
                throw new SchemaException("Value of explicitTimezone facet must be required, optional, or prohibited");
            }
        }
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException {
        if (base instanceof UserAtomicType) {
            UserAtomicType ubase = (UserAtomicType)base;
            ExplicitTimezoneFacet baseFacet = (ExplicitTimezoneFacet)ubase.getFacet(ExplicitTimezoneFacet.class);
            if (baseFacet != null) {
                if (baseFacet.isFixed() && this.facetValue != baseFacet.facetValue) {
                    throw new SchemaException("The explicitTimezone facet is fixed in the base type and cannot be varied");
                }
                if (baseFacet.facetValue == 2 && this.facetValue != 2) {
                    throw new SchemaException("The explicitTimezone is prohibited in the base type so it must be prohibited in the derived type");
                }
                if (baseFacet.facetValue == 1 && this.facetValue != 1) {
                    throw new SchemaException("The explicitTimezone is required in the base type so it must be required in the derived type");
                }
            }
        } else if (base.getFingerprint() == 565 && this.facetValue != 1) {
            throw new SchemaException("The explicitTimezone is required in the base type so it must be required in the derived type");
        }
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        if (this.facetValue != 0) {
            if (value instanceof CalendarValue) {
                return this.facetValue == 1 == ((CalendarValue)value).hasTimezone();
            }
            return false;
        }
        return true;
    }

    @Override
    public Function getFacetAsFunctionItem() {
        Callable callable = (context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue(this.getName());
                }
                case "implementation": {
                    return new ObjectValue<ExplicitTimezoneFacet>(this);
                }
                case "value": {
                    return new StringValue(this.getValue());
                }
                case "fixed": {
                    return BooleanValue.get(this.isFixed());
                }
            }
            return EmptySequence.getInstance();
        };
        return new CallableFunction(1, callable, SchemaComponent.COMPONENT_FUNCTION_TYPE);
    }
}

