/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AssertionFacet;
import com.saxonica.ee.schema.EnumerationFacetSet;
import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.LengthFacet;
import com.saxonica.ee.schema.MinLengthFacet;
import com.saxonica.ee.schema.PatternFacet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserSimpleType;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class UserListType
extends UserSimpleType
implements ListType {
    private TypeReference itemType = null;

    public UserListType(EnterpriseConfiguration config) {
        this.setConfiguration(config);
    }

    @Override
    public boolean isAtomicType() {
        return false;
    }

    @Override
    public boolean isIdType() throws MissingComponentException {
        return this.getItemType().isIdType();
    }

    @Override
    public boolean isIdRefType() throws MissingComponentException {
        return this.getItemType().isIdRefType();
    }

    @Override
    public boolean isBuiltInType() {
        return false;
    }

    @Override
    public boolean isListType() {
        return true;
    }

    @Override
    protected List<Facet> addInheritedFacets(List<Facet> localFacets) {
        localFacets = super.addInheritedFacets(localFacets);
        for (int i = 0; i < localFacets.size(); ++i) {
            Facet f = localFacets.get(i);
            if (!(f instanceof LengthFacet) && !(f instanceof MinLengthFacet)) continue;
            return localFacets;
        }
        SchemaType base = this;
        while (base != null) {
            if (!((base = base.getBaseType()) instanceof BuiltInListType)) continue;
            ArrayList<Facet> extendedFacets = new ArrayList<Facet>(localFacets);
            MinLengthFacet minLength = new MinLengthFacet();
            minLength.setNumericValue(1);
            extendedFacets.add(minLength);
            return extendedFacets;
        }
        return localFacets;
    }

    @Override
    public void elaborate(SchemaCompiler compiler) throws SchemaException {
        SimpleType st = (SimpleType)this.itemType.getTarget();
        if (st instanceof UserSimpleType) {
            ((UserSimpleType)st).elaborate(compiler);
        }
        super.elaborate(compiler);
    }

    public TypeReference getItemTypeReference() {
        return this.itemType;
    }

    @Override
    public SimpleType getItemType() throws MissingComponentException {
        return (SimpleType)this.itemType.getTarget();
    }

    public void setItemTypeReference(TypeReference type) {
        this.itemType = type;
    }

    @Override
    public ValidationFailure validateContent(CharSequence value, NamespaceResolver nsResolver, ConversionRules rules) {
        StringValue val;
        SimpleType itemType = null;
        try {
            itemType = this.getItemType();
        }
        catch (MissingComponentException e) {
            return new ValidationFailure(e.getMessage());
        }
        Whitespace.Tokenizer iter = new Whitespace.Tokenizer(value);
        int count = 0;
        while ((val = iter.next()) != null) {
            ValidationFailure err = itemType.validateContent(val.getStringValueCS(), nsResolver, rules);
            if (err != null) {
                return err;
            }
            ++count;
        }
        return this.checkAgainstListFacets(value, nsResolver, rules, count);
    }

    public ValidationFailure checkAgainstListFacets(CharSequence value, NamespaceResolver nsResolver, ConversionRules rules, int count) {
        for (Facet f : this.getExtendedFacetList()) {
            block14: {
                if (f instanceof PatternFacet) {
                    boolean match = f.testAtomicValue(StringValue.makeStringValue(Whitespace.collapseWhitespace(value)));
                    if (!match) {
                        ValidationFailure vf = new ValidationFailure("List " + Err.wrap(value) + " contravenes the pattern facet " + Err.wrap(f.getValue()));
                        vf.setConstraintReference(2, "cvc-pattern-valid", "1");
                        return vf;
                    }
                } else {
                    boolean match;
                    if (f instanceof EnumerationFacetSet) {
                        try {
                            AtomicSequence typedValue = ((SimpleType)this.getBaseType()).getTypedValue(value, nsResolver, rules);
                            match = f.testListValue(typedValue);
                            if (!match) {
                                String message = "List " + Err.wrap(value) + " does not match any of the values in the enumeration facet " + Err.wrap(f.getValue());
                                if (f.getMessage() != null) {
                                    message = message + ". " + f.getMessage();
                                }
                                ValidationFailure vf = new ValidationFailure(message);
                                vf.setConstraintReference(2, "cvc-enumeration-valid", "1");
                                return vf;
                            }
                            break block14;
                        }
                        catch (XPathException e) {
                            ValidationFailure vf = new ValidationFailure("List " + Err.wrap(value) + " cannot be compared against the enumeration facet " + Err.wrap(f.getValue()) + ": " + e.getMessage());
                            vf.setConstraintReference(2, "cvc-enumeration-valid", "1");
                            return vf;
                        }
                    }
                    if (f instanceof AssertionFacet) {
                        try {
                            AtomicSequence typedValue = ((SimpleType)this.getBaseType()).getTypedValue(value, nsResolver, rules);
                            match = ((AssertionFacet)f).testListValue(typedValue, rules);
                            if (!match) {
                                String message = f.getMessage();
                                if (message == null) {
                                    message = "List " + Err.wrap(value) + " does not satisfy the assertion " + Err.wrap(f.getValue());
                                }
                                ValidationFailure vf = new ValidationFailure(message);
                                vf.setConstraintReference(2, "cvc-assertions-valid", "1");
                                return vf;
                            }
                        }
                        catch (XPathException e) {
                            ValidationFailure vf = new ValidationFailure("List " + Err.wrap(value) + " cannot be compared against the assertion facet " + Err.wrap(f.getValue()) + ": " + e.getMessage());
                            vf.setConstraintReference(2, "cvc-assertions-valid", "1");
                            return vf;
                        }
                    }
                }
            }
            if (f.testLength(count)) continue;
            ValidationFailure vf = new ValidationFailure("Length of list " + Err.wrap(count + "") + " contravenes " + f.getName() + " facet " + Err.wrap(f.getValue()));
            vf.setConstraintReference(2, f.getConstraintName(), "1");
            return vf;
        }
        return null;
    }

    @Override
    public AtomicSequence getTypedValue(CharSequence value, NamespaceResolver resolver, ConversionRules rules) throws ValidationException {
        Whitespace.Tokenizer iter = new Whitespace.Tokenizer(value);
        UserListMappingFunction map = new UserListMappingFunction();
        map.resolver = resolver;
        try {
            map.itemType = this.getItemType();
        }
        catch (MissingComponentException e) {
            throw new ValidationException(e);
        }
        map.rules = rules;
        try {
            return new AtomicArray(new MappingIterator<StringValue, AtomicValue>(iter, map));
        }
        catch (XPathException err) {
            throw new ValidationException(err);
        }
    }

    @Override
    public boolean isNamespaceSensitive() {
        try {
            return this.getItemType().isNamespaceSensitive();
        }
        catch (MissingComponentException e) {
            return true;
        }
    }

    @Override
    public void serializeVariety(SchemaModelSerializer serializer) throws XPathException {
        serializer.emitAttribute("variety", "list");
        serializer.emitAttribute("itemType", serializer.getTypeLink(this.getItemType()));
    }

    @Override
    public String toString() {
        return this.getStructuredQName().getEQName();
    }

    private static class UserListMappingFunction
    implements MappingFunction<StringValue, AtomicValue> {
        public NamespaceResolver resolver;
        public SimpleType itemType;
        public ConversionRules rules;

        private UserListMappingFunction() {
        }

        public AtomicIterator map(StringValue item) throws XPathException {
            try {
                return this.itemType.getTypedValue(item.getStringValueCS(), this.resolver, this.rules).iterate();
            }
            catch (ValidationException err) {
                throw new XPathException(err);
            }
        }
    }
}

