/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lemming.lemma.LemmaInstance;
import lemming.lemma.LemmaOptions;
import lemming.lemma.LemmatizerGenerator;
import lemming.lemma.LemmatizerGeneratorTrainer;
import lemming.lemma.SimpleLemmatizer;
import marmot.util.Counter;

public class SimpleLemmatizerTrainer
implements LemmatizerGeneratorTrainer {
    private SimpleLemmatizerTrainerOptions options_ = new SimpleLemmatizerTrainerOptions();

    @Override
    public LemmatizerGenerator train(List<LemmaInstance> instances, List<LemmaInstance> dev_instances) {
        HashMap<String, Counter<String>> map2 = new HashMap<String, Counter<String>>();
        for (LemmaInstance instance : instances) {
            String key = null;
            if (this.options_.getUsePos()) {
                key = SimpleLemmatizer.toKey(instance);
                this.addToMap(key, map2, instance);
            }
            if (!this.options_.getUseBackup()) continue;
            key = SimpleLemmatizer.toSimpleKey(instance);
            this.addToMap(key, map2, instance);
        }
        return new SimpleLemmatizer(this.options_, map2);
    }

    private void addToMap(String key, Map<String, Counter<String>> map2, LemmaInstance instance) {
        Counter lemmas = map2.computeIfAbsent(key, k -> new Counter());
        lemmas.increment(instance.getLemma(), instance.getCount());
    }

    @Override
    public LemmaOptions getOptions() {
        return this.options_;
    }

    public static class SimpleLemmatizerTrainerOptions
    extends LemmaOptions {
        private static final long serialVersionUID = 1L;
        public static final String HANDLE_UNSEEN = "handle-unseen";
        public static final String USE_BACKUP = "use-backup";
        public static final String ABSTAIN_IF_AMBIGIOUS = "abstain-if-ambigious";

        private SimpleLemmatizerTrainerOptions() {
            this.map_.put(HANDLE_UNSEEN, false);
            this.map_.put(USE_BACKUP, true);
            this.map_.put(ABSTAIN_IF_AMBIGIOUS, false);
        }

        public static SimpleLemmatizerTrainerOptions newInstance() {
            return new SimpleLemmatizerTrainerOptions();
        }

        public boolean getHandleUnseen() {
            return (Boolean)this.getOption(HANDLE_UNSEEN);
        }

        public boolean getUseBackup() {
            return (Boolean)this.getOption(USE_BACKUP);
        }

        public boolean getAbstainIfAmbigous() {
            return (Boolean)this.getOption(ABSTAIN_IF_AMBIGIOUS);
        }
    }
}

