/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.spanish;

import java.io.IOException;
import java.io.Writer;
import marmot.morph.mapper.Node;
import marmot.morph.mapper.SyntaxTree;
import marmot.morph.mapper.SyntaxTreeIterator;
import marmot.morph.mapper.spanish.EaglesTag;
import marmot.util.FileUtils;

public class IulaConverter {
    public static void main(String[] args) throws IOException {
        SyntaxTreeIterator iterator2 = new SyntaxTreeIterator(args[0], 1, 2, 4, 5, 6, 7, false);
        Writer writer = FileUtils.openFileWriter(args[1]);
        boolean normalize = true;
        if (args.length > 2) {
            normalize = Boolean.parseBoolean(args[2]);
        }
        IulaConverter c = new IulaConverter();
        while (iterator2.hasNext()) {
            SyntaxTree tree = iterator2.next();
            for (Node node : tree.getNodes()) {
                EaglesTag tag = c.convert(node.getPos());
                node.setMorphTag(tag);
            }
            if (normalize) {
                for (Node node : tree.getNodes()) {
                    ((EaglesTag)node.getMorphTag()).normalize(node, true);
                }
            }
            tree.write(writer);
            writer.write(10);
            if (iterator2.hasNext()) {
                iterator2.next();
            }
            if (iterator2.hasNext()) {
                iterator2.next();
            }
            if (!iterator2.hasNext()) continue;
            iterator2.next();
        }
        writer.close();
    }

    public EaglesTag convert(String freeling_pos) {
        freeling_pos = freeling_pos.toLowerCase();
        EaglesTag tag = new EaglesTag();
        this.setPos(freeling_pos, tag);
        switch (tag.pos_) {
            case a: {
                this.setAdjectiveFeatures(freeling_pos, tag);
                break;
            }
            case d: {
                this.setDeterminerFeatures(freeling_pos, tag);
                break;
            }
            case n: {
                this.setNounFeatures(freeling_pos, tag);
                break;
            }
            case v: {
                this.setVerbFeatures(freeling_pos, tag);
                break;
            }
            case p: {
                this.setPronounFeatures(freeling_pos, tag);
                break;
            }
            case r: 
            case c: 
            case i: 
            case z: 
            case w: {
                this.setDefaultFeatures(freeling_pos, tag);
                break;
            }
            case s: {
                this.setPrepositionFeatures(freeling_pos, tag);
                break;
            }
            case f: {
                this.setPunctFeatures(freeling_pos, tag);
                break;
            }
        }
        return tag;
    }

    public void setNounFeatures(String freeling_pos, EaglesTag tag) {
        block8: for (int pos = 1; pos <= freeling_pos.length(); ++pos) {
            char c = freeling_pos.charAt(pos - 1);
            if (c == '0') continue;
            switch (pos) {
                case 1: {
                    continue block8;
                }
                case 2: {
                    this.setType(c, tag);
                    continue block8;
                }
                case 3: {
                    this.setGender(c, tag);
                    continue block8;
                }
                case 4: {
                    this.setNumber(c, tag);
                    continue block8;
                }
                case 5: 
                case 6: {
                    continue block8;
                }
                case 7: {
                    this.setNounDegree(c, tag);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("Invalid position : " + pos + " " + freeling_pos);
                }
            }
        }
    }

    public void setNounDegree(char c, EaglesTag tag) {
        if (c == 'x') {
            return;
        }
        tag.noun_degree_ = EaglesTag.NounDegree.valueOf(Character.toString(c));
    }

    public void setPunctFeatures(String freeling_pos, EaglesTag tag) {
        block5: for (int pos = 1; pos <= freeling_pos.length(); ++pos) {
            char c = freeling_pos.charAt(pos - 1);
            if (c == '0') continue;
            switch (pos) {
                case 1: {
                    continue block5;
                }
                case 2: {
                    this.setType(c, tag);
                    continue block5;
                }
                case 3: {
                    this.setClosing(c, tag);
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Invalid position : " + pos + " " + freeling_pos);
                }
            }
        }
    }

    public void setClosing(char c, EaglesTag tag) {
        if (c == 'c') {
            c = (char)116;
        }
        tag.closing_ = EaglesTag.Closing.valueOf(Character.toString(c));
    }

    public void setDeterminerFeatures(String freeling_pos, EaglesTag tag) {
        block8: for (int pos = 1; pos <= freeling_pos.length(); ++pos) {
            char c = freeling_pos.charAt(pos - 1);
            if (c == '0') continue;
            switch (pos) {
                case 1: {
                    continue block8;
                }
                case 2: {
                    this.setType(c, tag);
                    continue block8;
                }
                case 3: {
                    this.setPerson(c, tag);
                    continue block8;
                }
                case 4: {
                    this.setGender(c, tag);
                    continue block8;
                }
                case 5: {
                    this.setNumber(c, tag);
                    continue block8;
                }
                case 6: {
                    this.setOwnerNumber(c, tag);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("Invalid position : " + pos + " " + freeling_pos);
                }
            }
        }
    }

    public void setPrepositionFeatures(String freeling_pos, EaglesTag tag) {
        block7: for (int pos = 1; pos <= freeling_pos.length(); ++pos) {
            char c = freeling_pos.charAt(pos - 1);
            if (c == '0') continue;
            switch (pos) {
                case 1: {
                    continue block7;
                }
                case 2: {
                    this.setType(c, tag);
                    continue block7;
                }
                case 3: {
                    this.setForm(c, tag);
                    continue block7;
                }
                case 4: {
                    this.setGender(c, tag);
                    continue block7;
                }
                case 5: {
                    this.setNumber(c, tag);
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Invalid position : " + pos + " " + freeling_pos);
                }
            }
        }
    }

    public void setForm(char c, EaglesTag tag) {
        tag.form_ = EaglesTag.Form.valueOf(Character.toString(c));
    }

    public void setPronounFeatures(String freeling_pos, EaglesTag tag) {
        block10: for (int pos = 1; pos <= freeling_pos.length(); ++pos) {
            char c = freeling_pos.charAt(pos - 1);
            if (c == '0') continue;
            switch (pos) {
                case 1: {
                    continue block10;
                }
                case 2: {
                    this.setType(c, tag);
                    continue block10;
                }
                case 3: {
                    this.setPerson(c, tag);
                    continue block10;
                }
                case 4: {
                    this.setGender(c, tag);
                    continue block10;
                }
                case 5: {
                    if (c == 'c') continue block10;
                    this.setNumber(c, tag);
                    continue block10;
                }
                case 6: {
                    this.setCase(c, tag);
                    continue block10;
                }
                case 7: {
                    if (c == 'c') continue block10;
                    this.setOwnerNumber(c, tag);
                    continue block10;
                }
                case 8: {
                    this.setPoliteness(c, tag);
                    continue block10;
                }
                default: {
                    throw new RuntimeException("Invalid position : " + pos + " " + freeling_pos);
                }
            }
        }
    }

    public void setPoliteness(char c, EaglesTag tag) {
        tag.politeness_ = EaglesTag.Politeness.valueOf(Character.toString(c));
    }

    public void setOwnerNumber(char c, EaglesTag tag) {
        tag.owner_ = EaglesTag.OwnerNumber.valueOf(Character.toString(c));
    }

    public void setCase(char c, EaglesTag tag) {
        tag.case_ = EaglesTag.Case.valueOf(Character.toString(c));
    }

    public void setVerbFeatures(String freeling_pos, EaglesTag tag) {
        block9: for (int pos = 1; pos <= freeling_pos.length(); ++pos) {
            char c = freeling_pos.charAt(pos - 1);
            if (c == '0') continue;
            switch (pos) {
                case 1: {
                    continue block9;
                }
                case 2: {
                    this.setType(c, tag);
                    continue block9;
                }
                case 3: {
                    this.setMood(c, tag);
                    continue block9;
                }
                case 4: {
                    this.setTense(c, tag);
                    continue block9;
                }
                case 5: {
                    this.setPerson(c, tag);
                    continue block9;
                }
                case 6: {
                    this.setNumber(c, tag);
                    continue block9;
                }
                case 7: {
                    this.setGender(c, tag);
                    continue block9;
                }
                default: {
                    throw new RuntimeException("Invalid position : " + pos + " " + freeling_pos);
                }
            }
        }
    }

    public void setPerson(char c, EaglesTag tag) {
        switch (c) {
            case '1': {
                tag.person_ = EaglesTag.Person.first;
                break;
            }
            case '2': {
                tag.person_ = EaglesTag.Person.second;
                break;
            }
            case '3': {
                tag.person_ = EaglesTag.Person.third;
            }
        }
    }

    public void setTense(char c, EaglesTag tag) {
        if (c == 'b') {
            return;
        }
        tag.tense_ = EaglesTag.Tense.valueOf(Character.toString(c));
    }

    public void setMood(char c, EaglesTag tag) {
        tag.mood_ = EaglesTag.Mood.valueOf(Character.toString(c));
    }

    public void setDefaultFeatures(String freeling_pos, EaglesTag tag) {
        block4: for (int pos = 1; pos <= freeling_pos.length(); ++pos) {
            char c = freeling_pos.charAt(pos - 1);
            if (c == '0') continue;
            switch (pos) {
                case 1: {
                    continue block4;
                }
                case 2: {
                    this.setType(c, tag);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Invalid position : " + pos + " " + freeling_pos);
                }
            }
        }
    }

    public void setAdjectiveFeatures(String freeling_pos, EaglesTag tag) {
        block8: for (int pos = 1; pos <= freeling_pos.length(); ++pos) {
            char c = freeling_pos.charAt(pos - 1);
            if (c == '0') continue;
            switch (pos) {
                case 1: {
                    continue block8;
                }
                case 2: {
                    this.setType(c, tag);
                    continue block8;
                }
                case 3: {
                    this.setDegree(c, tag);
                    continue block8;
                }
                case 4: {
                    this.setGender(c, tag);
                    continue block8;
                }
                case 5: {
                    this.setNumber(c, tag);
                    continue block8;
                }
                case 6: {
                    this.setFunction(c, tag);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("Invalid position : " + pos + " " + freeling_pos);
                }
            }
        }
    }

    public void setFunction(char c, EaglesTag tag) {
        tag.function_ = EaglesTag.Function.valueOf(Character.toString(c));
    }

    public void setNumber(char c, EaglesTag tag) {
        tag.number_ = EaglesTag.Number.valueOf(Character.toString(c));
    }

    public void setGender(char c, EaglesTag tag) {
        tag.gender_ = EaglesTag.Gender.valueOf(Character.toString(c));
    }

    public void setDegree(char c, EaglesTag tag) {
        if (c == 'd') {
            c = (char)99;
        }
        try {
            tag.degree_ = EaglesTag.Degree.valueOf(Character.toString(c));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid degree: " + c);
        }
    }

    public void setType(char c, EaglesTag tag) {
        tag.type_ = EaglesTag.Type.valueOf(Character.toString(c));
    }

    public void setPos(String freeling_pos, EaglesTag tag) {
        char c = freeling_pos.charAt(0);
        tag.pos_ = EaglesTag.Pos.valueOf(Character.toString(c));
    }
}

