/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.AttributeGroupReference;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ModelGroupDefinition;
import com.saxonica.ee.schema.Notation;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.Wildcard;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.schema.sdoc.XSDAttribute;
import com.saxonica.ee.schema.sdoc.XSDAttributeGroup;
import com.saxonica.ee.schema.sdoc.XSDComplexType;
import com.saxonica.ee.schema.sdoc.XSDDefaultOpenContent;
import com.saxonica.ee.schema.sdoc.XSDElement;
import com.saxonica.ee.schema.sdoc.XSDGroup;
import com.saxonica.ee.schema.sdoc.XSDImport;
import com.saxonica.ee.schema.sdoc.XSDInclude;
import com.saxonica.ee.schema.sdoc.XSDNotation;
import com.saxonica.ee.schema.sdoc.XSDOverride;
import com.saxonica.ee.schema.sdoc.XSDRedefine;
import com.saxonica.ee.schema.sdoc.XSDSimpleType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeSelector;
import net.sf.saxon.type.SchemaException;

public class XSDSchema
extends SchemaElement {
    private SingleNamespaceSchema schema = null;
    private SchemaCompiler compiler;
    private int errorCount = 0;
    private Executable executable;
    private final HashMap<StructuredQName, GlobalParam> params = new HashMap();
    private SchemaElement referrer;
    private String attributeFormDefault = null;
    private int blockDefault = 0;
    private String elementFormDefault = null;
    private int finalDefault = 0;
    private NamespaceUri targetNamespace;
    private boolean chameleon = false;
    private Set<NamespaceUri> importedNamespaces = null;
    private Wildcard openContentWildcard;
    private String openContentMode;
    private boolean openContentAppliesToEmpty = false;
    private String xpathDefaultNamespace = "##local";
    private StructuredQName defaultAttributeGroup = null;
    private AttributeGroupReference defaultAttributeGroupReference = null;
    private final Set<String> saxonExtensionEnabled = new HashSet<String>();
    private static final int[] state0terms = new int[]{613, 597, 589, 621, 578, 585, 588, 598, 611, 591, 584, 596, 615};
    private static final int[] state0targets = new int[]{2, 2, 3, 1, 2, 1, 1, 2, 1, 1, 1, 1, 2};
    private static final int[] state1terms = new int[]{591, 596, 621, 588, 611, 585, 584, 578};
    private static final int[] state1targets = new int[]{1, 1, 1, 1, 1, 1, 1, 4};
    private static final int[] state2terms = new int[]{613, 597, 589, 621, 578, 585, 588, 598, 611, 591, 584, 596, 615};
    private static final int[] state2targets = new int[]{2, 2, 3, 1, 2, 1, 1, 2, 1, 1, 1, 1, 2};
    private static final int[] state3terms = new int[]{591, 596, 621, 588, 611, 585, 584, 578};
    private static final int[] state3targets = new int[]{1, 1, 1, 1, 1, 1, 1, 5};
    private static final int[] state4terms = new int[]{591, 596, 621, 588, 611, 585, 584, 578};
    private static final int[] state4targets = new int[]{1, 1, 1, 1, 1, 1, 1, 4};
    private static final int[] state5terms = new int[]{591, 596, 621, 588, 611, 585, 584, 578};
    private static final int[] state5targets = new int[]{1, 1, 1, 1, 1, 1, 1, 5};
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms, state3terms, state4terms, state5terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets, state3targets, state4targets, state5targets};

    @Override
    public SingleNamespaceSchema getSchema() {
        return this.schema;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public Set<String> getAllowedExtensions() {
        return this.saxonExtensionEnabled;
    }

    public void setSchema(SingleNamespaceSchema schema) {
        this.schema = schema;
    }

    public void setSchemaCompiler(SchemaCompiler manager) {
        this.compiler = manager;
    }

    public SchemaCompiler getSchemaCompiler() {
        return this.compiler;
    }

    public void setReferrer(SchemaElement referrer) {
        this.referrer = referrer;
    }

    public boolean isChameleon() {
        return this.chameleon;
    }

    @Override
    protected void prepareAttributes() throws SchemaException {
        Configuration config = this.getConfiguration();
        this.executable = new Executable(config);
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"attributeFormDefault", "blockDefault", "defaultAttributes", "elementFormDefault", "finalDefault", "id", "targetNamespace", "version", "xpathDefaultNamespace"};
        this.allowAttributes(atts, allowed);
        String nsURIatt = atts.getValue(NamespaceUri.NULL, "targetNamespace");
        if (nsURIatt != null && nsURIatt.isEmpty()) {
            this.error("The zero-length string is not a legal namespace URI");
            nsURIatt = null;
        }
        if (nsURIatt != null) {
            NamespaceUri includingNamespace;
            NamespaceUri nsURI = NamespaceUri.of(nsURIatt);
            if ((this.referrer instanceof XSDInclude || this.referrer instanceof XSDRedefine) && !(includingNamespace = this.referrer.getXSDSchema().getTargetNamespace()).equals(nsURI)) {
                this.error("The target namespace of the included schema must be the same as the target namespace of the including schema");
                return;
            }
            this.schema.setTargetNamespace(nsURI);
            ((EnterpriseConfiguration)config).addSurrogateSchema(nsURI);
            this.targetNamespace = nsURI;
        } else if (this.referrer instanceof XSDInclude || this.referrer instanceof XSDRedefine || this.referrer instanceof XSDOverride) {
            this.targetNamespace = this.referrer.getXSDSchema().getTargetNamespace();
            this.chameleon = true;
        } else {
            this.targetNamespace = NamespaceUri.NULL;
            ((EnterpriseConfiguration)config).addSurrogateSchema(NamespaceUri.NULL);
        }
        String extensions = atts.getValue(NamespaceUri.SAXON, "extensions");
        if (extensions != null) {
            StringTokenizer st = new StringTokenizer(extensions, " \t\n\r");
            while (st.hasMoreTokens()) {
                this.saxonExtensionEnabled.add(st.nextToken());
            }
        }
        this.processId();
        atts.getValue(NamespaceUri.NULL, "version");
        String attValue = atts.getValue(NamespaceUri.NULL, "attributeFormDefault");
        if (attValue != null) {
            if (attValue.equals("qualified") || attValue.equals("unqualified")) {
                this.setAttributeFormDefault(attValue);
            } else {
                this.invalidAttributeValue("attributeFormDefault", attValue, "Must be 'qualified' or 'unqualified'");
            }
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "defaultAttributes")) != null) {
            try {
                this.defaultAttributeGroup = this.getComponentName(attValue, 3);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
            }
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "elementFormDefault")) != null) {
            if (attValue.equals("qualified") || attValue.equals("unqualified")) {
                this.setElementFormDefault(attValue);
            } else {
                this.invalidAttributeValue("elementFormDefault", attValue, "Must be 'qualified' or 'unqualified'");
            }
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "blockDefault")) != null) {
            int v = this.parseFinalOrBlock("blockDefault", attValue, 19);
            this.setBlockDefault(v);
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "finalDefault")) != null) {
            int v = this.parseFinalOrBlock("finalDefault", attValue, 15);
            this.setFinalDefault(v);
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "xpathDefaultNamespace")) != null) {
            this.xpathDefaultNamespace = attValue;
        }
    }

    public boolean isImportedNamespace(NamespaceUri uri) {
        if (this.importedNamespaces == null) {
            if (this.getConfiguration().getBooleanProperty(Feature.IMPLICIT_SCHEMA_IMPORTS)) {
                return true;
            }
            this.importedNamespaces = new HashSet<NamespaceUri>(10);
            for (NodeInfo nodeInfo : this.children()) {
                if (!(nodeInfo instanceof XSDImport)) continue;
                NamespaceUri targetNamespace = ((XSDImport)nodeInfo).getTargetNamespace();
                this.importedNamespaces.add(targetNamespace);
            }
        }
        return this.importedNamespaces.contains(uri);
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        if (compiler.getLanguageVersion() == 10) {
            if (!this.xpathDefaultNamespace.equals("##local")) {
                this.error("The xpathDefaultNamespace attribute requires XSD 1.1 to be enabled");
            }
            if (this.defaultAttributeGroup != null) {
                this.error("The defaultAttributes attribute requires XSD 1.1 to be enabled");
            }
        }
        this.checkContentModel(stateTerms, stateTargets, false);
        if (this.defaultAttributeGroup != null) {
            String attValue = this.getAttributeValue(NamespaceUri.NULL, "defaultAttributes");
            try {
                this.defaultAttributeGroup = this.getComponentName(attValue, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
            }
        }
    }

    @Override
    protected void validateChildren(SchemaCompiler compiler) throws SchemaException {
        for (NodeInfo nodeInfo : this.children(NodeSelector.of(c -> c instanceof XSDDefaultOpenContent))) {
            ((SchemaElement)nodeInfo).validateSubtree(compiler);
        }
        for (NodeInfo nodeInfo : this.children()) {
            if (!(nodeInfo instanceof SchemaElement) || nodeInfo instanceof XSDDefaultOpenContent) continue;
            ((SchemaElement)nodeInfo).validateSubtree(compiler);
        }
    }

    @Override
    protected boolean isFinalState(int state) {
        return state == 0 || state == 1 || state == 2 || state == 3 || state == 4 || state == 5;
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        for (NodeInfo nodeInfo : this.children()) {
            int childfp = nodeInfo.getFingerprint();
            switch (childfp) {
                case 584: {
                    AttributeDecl att = ((XSDAttribute)nodeInfo).getAttributeDeclaration();
                    if (att == null) break;
                    if (this.schema.getAttributeDecl(att.getComponentName()) != null) {
                        this.duplicate("attribute declaration", att.getDisplayName());
                    }
                    this.schema.addAttributeDecl(att);
                    break;
                }
                case 585: {
                    AttributeGroupDecl ag = ((XSDAttributeGroup)nodeInfo).getAttributeGroupDecl();
                    if (ag == null) break;
                    if (this.schema.getAttributeGroup(ag.getAttributeGroupName()) != null) {
                        this.duplicate("attribute group", ag.getDisplayName());
                        break;
                    }
                    this.schema.addAttributeGroup(ag);
                    break;
                }
                case 588: {
                    UserComplexType complexType = ((XSDComplexType)nodeInfo).getComplexType();
                    int fpt = complexType.getFingerprint();
                    if (this.schema.getSchemaType(complexType.getTypeName()) != null && fpt > 1023) {
                        this.duplicate("complex type", complexType.getName());
                        break;
                    }
                    this.schema.addType(complexType);
                    break;
                }
                case 589: {
                    break;
                }
                case 621: {
                    SimpleTypeDefinition typeDef;
                    try {
                        typeDef = ((XSDSimpleType)nodeInfo).getSimpleTypeDefinition();
                    }
                    catch (SchemaException e) {
                        this.error(e.getMessage());
                        return;
                    }
                    int fingerprint = typeDef.getFingerprint();
                    if (this.schema.getSchemaType(typeDef.getTypeName()) != null && fingerprint > 1023) {
                        this.duplicate("simple type", typeDef.getDisplayName());
                        break;
                    }
                    this.schema.addType(typeDef);
                    break;
                }
                case 591: {
                    ElementDecl element = ((XSDElement)nodeInfo).getElementDeclaration();
                    String elname = element.getName();
                    if (this.schema.getElementDecl(element.getComponentName()) != null) {
                        this.duplicate("element declaration", elname);
                    }
                    this.schema.addElementDecl(element);
                    break;
                }
                case 596: {
                    ModelGroupDefinition group = ((XSDGroup)nodeInfo).getGroupDeclaration();
                    String groupName = group.getName();
                    if (groupName == null) break;
                    if (this.schema.getGroup(group.getModelGroupName()) != null) {
                        this.duplicate("group", groupName);
                        break;
                    }
                    this.schema.addGroup(group);
                    break;
                }
                case 611: {
                    Notation n = ((XSDNotation)nodeInfo).getNotation();
                    if (this.schema.getNotation(n.getNotationName()) != null) {
                        this.duplicate("notation", n.getNotationName().getDisplayName());
                        break;
                    }
                    this.schema.addNotation(n);
                    break;
                }
                case 598: {
                    PreparedSchema includedSchema = ((XSDInclude)nodeInfo).getIncludedSchema();
                    if (includedSchema == null) break;
                    if (compiler.getErrorCount() > 0) {
                        ((XSDInclude)nodeInfo).error("Errors were found in the included schema document");
                        break;
                    }
                    includedSchema.copyTo(this.schema, compiler);
                    if (compiler.getErrorCount() <= 0) break;
                    ((XSDInclude)nodeInfo).error("The included schema document resulted in conflicting components");
                    break;
                }
                case 597: {
                    PreparedSchema importedSchema = ((XSDImport)nodeInfo).getImportedSchema();
                    if (importedSchema == null) break;
                    importedSchema.copyTo(this.schema, compiler);
                    if (compiler.getErrorCount() <= 0) break;
                    ((XSDImport)nodeInfo).error("The imported schema document resulted in conflicting components");
                    break;
                }
                case 615: {
                    SingleNamespaceSchema redefinedSchema = ((XSDRedefine)nodeInfo).getRedefinedSchema();
                    if (redefinedSchema == null) break;
                    redefinedSchema.copyTo(this.schema, compiler);
                    if (compiler.getErrorCount() <= 0) break;
                    ((XSDRedefine)nodeInfo).error("The redefined schema document resulted in conflicting components");
                }
            }
        }
    }

    public NamespaceUri getTargetNamespace() {
        if (this.targetNamespace == null) {
            String tn = this.getAttributeValue(NamespaceUri.NULL, "targetNamespace");
            this.targetNamespace = tn == null ? NamespaceUri.NULL : NamespaceUri.of(tn);
        }
        return this.targetNamespace;
    }

    public String getAttributeFormDefault() {
        return this.attributeFormDefault;
    }

    public int getBlockDefault() {
        return this.blockDefault;
    }

    public String getElementFormDefault() {
        return this.elementFormDefault;
    }

    public int getFinalDefault() {
        return this.finalDefault;
    }

    public Wildcard getDefaultOpenContentWildcard() {
        return this.openContentWildcard;
    }

    public String getDefaultOpenContentMode() {
        return this.openContentMode;
    }

    public boolean defaultOpenContentAppliesToEmpty() {
        return this.openContentAppliesToEmpty;
    }

    public void setAttributeFormDefault(String attributeFormDefault) {
        this.attributeFormDefault = attributeFormDefault;
    }

    public void setBlockDefault(int value) {
        this.blockDefault = value;
    }

    public void setElementFormDefault(String elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    public void setFinalDefault(int value) {
        this.finalDefault = value;
    }

    public void setDefaultOpenContent(Wildcard wildcard, String mode, boolean appliesToEmpty) {
        this.openContentWildcard = wildcard;
        this.openContentMode = mode;
        this.openContentAppliesToEmpty = appliesToEmpty;
    }

    public String getXPathDefaultNamespace() {
        return this.xpathDefaultNamespace;
    }

    public AttributeGroupReference getDefaultAttributeGroupReference() {
        if (this.defaultAttributeGroupReference != null) {
            return this.defaultAttributeGroupReference;
        }
        if (this.defaultAttributeGroup == null) {
            return null;
        }
        this.defaultAttributeGroupReference = new AttributeGroupReference((EnterpriseConfiguration)this.getConfiguration(), this.defaultAttributeGroup);
        return this.defaultAttributeGroupReference;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void incrementErrorCount() {
        ++this.errorCount;
    }

    public void addGlobalParam(GlobalParam param) throws SchemaException {
        GlobalParam prev = this.params.put(param.getVariableQName(), param);
        if (prev != null) {
            this.error("Duplicate declaration of parameter " + param.getVariableQName().getEQName());
        }
    }

    public GlobalParam getGlobalParam(StructuredQName name) {
        return this.params.get(name);
    }

    public Collection<GlobalParam> getGlobalParams() {
        return this.params.values();
    }
}

