/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import lemming.lemma.BackupLemmatizer;
import lemming.lemma.LemmaInstance;
import lemming.lemma.LemmaOptions;
import lemming.lemma.Lemmatizer;
import lemming.lemma.LemmatizerGenerator;
import lemming.lemma.LemmatizerGeneratorTrainer;
import lemming.lemma.SimpleLemmatizerTrainer;
import lemming.lemma.toutanova.ToutanovaTrainer;

public class BackupLemmatizerTrainer
implements LemmatizerGeneratorTrainer {
    BackupLemmatizerTrainerOptions options_ = new BackupLemmatizerTrainerOptions();
    private LemmatizerGeneratorTrainer standard_trainer_ = null;
    private ToutanovaTrainer backup_trainer_ = null;

    public BackupLemmatizerTrainer() {
    }

    public BackupLemmatizerTrainer(LemmatizerGeneratorTrainer simple_trainer, ToutanovaTrainer trainer) {
        this();
        this.standard_trainer_ = simple_trainer;
        this.backup_trainer_ = trainer;
    }

    @Override
    public LemmatizerGenerator train(List<LemmaInstance> instances, List<LemmaInstance> dev_instances) {
        LemmatizerGeneratorTrainer trainer = this.standard_trainer_ == null ? this.options_.getLemmatizerTrainer() : this.standard_trainer_;
        Lemmatizer lemmatizer = trainer.train((List)instances, (List)dev_instances);
        trainer = this.backup_trainer_ == null ? this.options_.getBackupTrainer() : this.backup_trainer_;
        Lemmatizer backup = trainer.train((List)instances, (List)dev_instances);
        return new BackupLemmatizer((LemmatizerGenerator)lemmatizer, (LemmatizerGenerator)backup);
    }

    @Override
    public LemmaOptions getOptions() {
        return this.options_;
    }

    public static class BackupLemmatizerTrainerOptions
    extends LemmaOptions {
        private static final long serialVersionUID = 1L;
        public static final String LEMMATIZER_TRAINER = "lemmatizer-trainer";
        public static final String BACKUP_TRAINER = "backup-trainer";
        public LemmatizerGeneratorTrainer trainer_;
        public LemmatizerGeneratorTrainer backup_trainer_;
        public static final String TRAINER_PREF = "backup-lemmatizer-model-";
        public static final String BACKUP_PREF = "backup-lemmatizer-backup-";
        private Map<String, Object> model_options_;
        private Map<String, Object> backup_options_;

        public BackupLemmatizerTrainerOptions() {
            this.map_.put(LEMMATIZER_TRAINER, SimpleLemmatizerTrainer.class.getName());
            this.map_.put(BACKUP_TRAINER, ToutanovaTrainer.class.getName());
            this.model_options_ = new HashMap<String, Object>();
            this.backup_options_ = new HashMap<String, Object>();
        }

        @Override
        public LemmaOptions setOption(String name, Object value) {
            if ((name = name.toLowerCase()).startsWith(TRAINER_PREF)) {
                this.model_options_.put(name.substring(TRAINER_PREF.length()), value);
            } else if (name.startsWith(BACKUP_PREF)) {
                this.backup_options_.put(name.substring(BACKUP_PREF.length()), value);
            } else {
                super.setOption(name, value);
            }
            return this;
        }

        public LemmatizerGeneratorTrainer getLemmatizerTrainer(String name, Map<String, Object> map2) {
            LemmatizerGeneratorTrainer trainer;
            String classname = (String)this.getOption(name);
            try {
                trainer = (LemmatizerGeneratorTrainer)Class.forName(classname).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry<String, Object> entry : map2.entrySet()) {
                trainer.getOptions().setOption(entry.getKey(), entry.getValue());
            }
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.info(String.format("%s (%s) options:\n %s", name, classname, trainer.getOptions().report()));
            return trainer;
        }

        public LemmatizerGeneratorTrainer getLemmatizerTrainer() {
            return this.getLemmatizerTrainer(LEMMATIZER_TRAINER, this.model_options_);
        }

        public LemmatizerGeneratorTrainer getBackupTrainer() {
            return this.getLemmatizerTrainer(BACKUP_TRAINER, this.backup_options_);
        }
    }
}

