/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.ComponentReference;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;

public class TypeReference
extends SchemaStructure
implements ComponentReference {
    private final StructuredQName qName;
    private final int fingerprint;
    private boolean dangling;
    private SchemaType target;

    public TypeReference(int fingerprint, EnterpriseConfiguration config, SourceLocator locator) {
        this.fingerprint = fingerprint;
        this.qName = config.getNamePool().getStructuredQName(fingerprint);
        if (locator != null) {
            this.setLocator(locator);
        }
        if (fingerprint < 1024) {
            this.setTarget(BuiltInType.getSchemaType(fingerprint));
        }
        this.setConfiguration(config);
    }

    @Override
    public boolean isResolved() {
        return this.target != null;
    }

    public void setTarget(SchemaType target) {
        this.target = target;
    }

    public int getTargetFingerprint() {
        return this.fingerprint;
    }

    @Override
    public StructuredQName getTargetComponentName() {
        return this.qName;
    }

    @Override
    public boolean isDangling() {
        return this.dangling;
    }

    @Override
    public int getSymbolSpace() {
        return 803;
    }

    public boolean isAnonymousType() {
        return this.getTargetFingerprint() > 1023 && this.getTargetComponentName().hasURI(NamespaceUri.ANONYMOUS);
    }

    @Override
    public SchemaComponent getTarget() {
        UserSimpleType ust;
        if (this.target instanceof SimpleTypeDefinition && (ust = ((SimpleTypeDefinition)this.target).getWorkingType()) != null) {
            this.target = ust;
        }
        return this.target;
    }

    @Override
    public void tryToResolve(SchemaCompiler compiler, boolean fatal) throws SchemaException {
        if (!this.dangling) {
            if (this.target == null) {
                this.target = compiler.getPreparedSchema().getType(this.qName);
            }
            if (this.target == null) {
                this.target = this.getConfiguration().getSuperSchema().getType(this.qName);
            }
            if (this.target == null) {
                if (compiler.isAllowDanglingReferences() && !fatal) {
                    this.dangling = true;
                    compiler.warning("Unknown type " + this.qName.getEQName() + " (substituting xs:error)", "SXSD1008", this);
                    this.target = ErrorType.getInstance();
                } else {
                    this.dangling = true;
                    compiler.error("Unknown type " + this.qName.getEQName(), this);
                }
            }
        }
    }
}

