/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.fsa;

import com.saxonica.ee.schema.fsa.AutomatonState;
import com.saxonica.ee.schema.fsa.FiniteStateMachine;
import java.util.ArrayList;
import java.util.List;

public class NonDeterminizedState
extends AutomatonState {
    private transient List<AutomatonState> lambdaTransitions = null;

    public NonDeterminizedState(FiniteStateMachine machine) {
        super(machine);
    }

    public void addLambdaTransition(AutomatonState newState) {
        if (newState.isFinalState()) {
            this.setFinalState(true);
        }
        if (this.lambdaTransitions == null) {
            this.lambdaTransitions = new ArrayList<AutomatonState>(3);
        }
        if (!this.lambdaTransitions.contains(newState)) {
            this.lambdaTransitions.add(newState);
        }
    }

    public List<AutomatonState> getLambdaTransitions() {
        return this.lambdaTransitions;
    }

    @Override
    public void displayLambdaTransitions() {
        if (this.lambdaTransitions != null) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("   lambda transitions -> ");
            for (int i = 0; i < this.lambdaTransitions.size(); ++i) {
                sb.append(this.lambdaTransitions.get((int)i).stateNumber + (i < this.lambdaTransitions.size() - 1 ? ", " : ""));
            }
            System.err.println(sb);
        }
    }
}

