/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.dom4j;

import java.util.HashMap;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.ActiveSource;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.option.dom4j.DOM4JNodeWrapper;
import net.sf.saxon.trans.XPathException;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class DOM4JDocumentWrapper
extends GenericTreeInfo
implements ActiveSource {
    public DOM4JDocumentWrapper(Document doc, String baseURI, Configuration config) {
        super(config);
        config.requireProfessionalLicense("DOM4J");
        this.setRootNode(this.wrap((Node)doc));
        this.setSystemId(baseURI);
    }

    @Override
    public void deliver(Receiver receiver, ParseOptions options) throws XPathException {
        this.getRootNode().deliver(receiver, options);
    }

    public NodeInfo wrap(Node node) {
        return DOM4JNodeWrapper.makeWrapper(node, this);
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        HashMap idIndex = (HashMap)this.getUserData("saxon-id-index");
        if (idIndex == null) {
            Element e = ((DOM4JNodeWrapper)this.getRootNode()).getUnderlyingNode().getDocument().elementByID(id);
            return e == null ? null : this.wrap((Node)e);
        }
        Element e = (Element)idIndex.get(id);
        return e == null ? null : this.wrap((Node)e);
    }

    public static Branch searchForParent(Branch subtree, Node node) {
        List content = subtree.content();
        for (Node child : content) {
            Branch b;
            if (child == node) {
                return subtree;
            }
            if (!child.hasContent() || (b = DOM4JDocumentWrapper.searchForParent((Branch)child, node)) == null) continue;
            return b;
        }
        return null;
    }
}

