/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.wrap;

import de.ids_mannheim.korap.query.SpanClassQuery;
import de.ids_mannheim.korap.query.SpanFocusQuery;
import de.ids_mannheim.korap.query.SpanWithinQuery;
import de.ids_mannheim.korap.util.QueryException;
import org.apache.lucene.search.spans.SpanQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanQueryWrapper {
    private static Logger log = LoggerFactory.getLogger(SpanQueryWrapper.class);
    protected int min = 1;
    protected int max = 1;
    protected byte number = 0;
    protected boolean hasClass = false;
    protected boolean isNull = true;
    protected boolean isOptional = false;
    protected boolean isNegative = false;
    protected boolean isEmpty = false;
    protected boolean isExtended = false;
    protected boolean isExtendedToTheRight = false;
    protected boolean maybeUnsorted = false;
    protected boolean retrieveNode = false;
    protected boolean isProblematic = false;

    public SpanQuery toFragmentQuery() throws QueryException {
        return null;
    }

    public SpanQuery toQuery() throws QueryException {
        if (this.isNull() || this.isEmpty()) {
            return null;
        }
        if (this.isExtendedToTheRight()) {
            SpanFocusQuery sfc = new SpanFocusQuery((SpanQuery)new SpanWithinQuery("base/s:t", (SpanQuery)new SpanClassQuery(this.toFragmentQuery(), -2)), -2);
            if (this.maybeUnsorted()) {
                sfc.setSorted(false);
            }
            return sfc;
        }
        SpanQuery sq = this.toFragmentQuery();
        return sq;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public SpanQueryWrapper isOptional(boolean opt) {
        this.isOptional = opt;
        return this;
    }

    public boolean isNull() {
        if (this.getMin() == 0 && this.getMax() == 0) {
            return true;
        }
        return this.isNull;
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public SpanQueryWrapper isExtended(boolean extended) {
        this.isExtended = extended;
        return this;
    }

    public boolean isExtendedToTheRight() {
        return this.isExtendedToTheRight;
    }

    public SpanQueryWrapper isExtendedToTheRight(boolean extended) {
        this.isExtendedToTheRight = extended;
        return this;
    }

    public boolean maybeAnchor() {
        if (this.isNegative()) {
            return false;
        }
        if (this.isOptional()) {
            return false;
        }
        return !this.isEmpty();
    }

    public boolean maybeExtension() {
        return !this.maybeAnchor();
    }

    public boolean maybeUnsorted() {
        return this.maybeUnsorted;
    }

    public int getMin() {
        return this.min;
    }

    public SpanQueryWrapper setMin(int min) {
        this.min = min;
        return this;
    }

    public int getMax() {
        return this.max;
    }

    public SpanQueryWrapper setMax(int max) {
        this.max = max;
        return this;
    }

    public SpanQueryWrapper retrieveNode(boolean retrieve) {
        this.retrieveNode = retrieve;
        return this;
    }

    public boolean hasClass() {
        return this.hasClass;
    }

    public byte getClassNumber() {
        return this.number;
    }

    public SpanQueryWrapper setClassNumber(byte number) {
        this.hasClass = true;
        this.number = number;
        return this;
    }

    public SpanQueryWrapper setClassNumber(short number) {
        return this.setClassNumber((byte)number);
    }

    public SpanQueryWrapper setClassNumber(int number) {
        return this.setClassNumber((byte)number);
    }

    public String toString() {
        String string = (this.isNull() ? "isNull" : "notNull") + "-" + (this.isEmpty() ? "isEmpty" : "notEmpty") + "-" + (this.isOptional() ? "isOptional" : "notOptional") + "-" + (this.isExtendedToTheRight() ? "isExtendedToTheRight" : "notExtendedToTheRight") + "-" + (this.maybeUnsorted() ? "maybeUnsorted" : "notUnsorted");
        return string;
    }
}

