/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.StringLength_1;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.StringValue;

public class StringLengthCompiler
extends ToItemCompiler {
    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        StringLength_1 fn = (StringLength_1)fnc.getTargetFunction();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        StringLengthCompiler.visitAnnotation(compiler, "StringLengthCompiler");
        if (fn.getArity() == 0) {
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getContextItem", new Class[0]);
            ga.dup();
            LabelInfo notNull = methodInfo.newLabel("notNullLen");
            ga.ifNonNull(notNull.label());
            compiler.generateDynamicError("The context item for string-length() is absent", "XPDY0002", expression.getLocation(), false);
            methodInfo.placeLabel(notNull);
            ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
        } else {
            compiler.compileToPrimitive(fnc.getArg(0), CharSequence.class, OnEmpty.RETURN_EMPTY_STRING);
        }
        ga.invokeStaticMethod(StringValue.class, "getStringLength", CharSequence.class);
        if (requiredClass == Long.TYPE) {
            ga.cast(Type.INT_TYPE, Type.LONG_TYPE);
        }
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        this.compileItemFromInt(compiler, expression);
    }
}

