/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.util.Iterator;
import opennlp.tools.doccat.BagOfWordsFeatureGenerator;
import opennlp.tools.doccat.DocumentCategorizerContextGenerator;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.doccat.FeatureGenerator;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.ObjectStream;

public class DocumentCategorizerEventStream
extends AbstractEventStream<DocumentSample> {
    private final DocumentCategorizerContextGenerator mContextGenerator;

    public DocumentCategorizerEventStream(ObjectStream<DocumentSample> samples, FeatureGenerator ... featureGenerators) {
        super(samples);
        this.mContextGenerator = new DocumentCategorizerContextGenerator(featureGenerators);
    }

    public DocumentCategorizerEventStream(ObjectStream<DocumentSample> samples) {
        super(samples);
        this.mContextGenerator = new DocumentCategorizerContextGenerator(new BagOfWordsFeatureGenerator());
    }

    @Override
    protected Iterator<Event> createEvents(final DocumentSample sample2) {
        return new Iterator<Event>(){
            private boolean isVirgin = true;

            @Override
            public boolean hasNext() {
                return this.isVirgin;
            }

            @Override
            public Event next() {
                this.isVirgin = false;
                return new Event(sample2.getCategory(), DocumentCategorizerEventStream.this.mContextGenerator.getContext(sample2.getText(), sample2.getExtraInformation()));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

