/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.ManualGroupIterator;
import com.saxonica.ee.stream.adjunct.ForkAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FilteringFeed;
import com.saxonica.ee.stream.feed.NoCloseFeed;
import com.saxonica.ee.stream.feed.NoOpenOrCloseFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.ForEachAction;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.Watch;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.saxon.event.EventBuffer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TeeOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AncestorQualifiedPattern;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.value.AtomicValue;

public class ForEachGroupParallelAction
extends ForEachAction {
    private HashMap<List<AtomicMatchKey>, GroupInfo> groups = new HashMap();
    private List<GroupInfo> groupList = new ArrayList<GroupInfo>();
    private int groupSequence = 1;
    private XPathContext populationContext;
    private StringCollator collator;
    private int implicitTimezone;
    private Feed currentItemFeed;
    private boolean compositeKeys;
    private NodeInfo anchorNode;

    public ForEachGroupParallelAction(WatchManager watchManager, ForEachGroup expression, Feed result, XPathContext context) {
        super(watchManager, expression, result, context);
        this.populationContext = context.newMinorContext();
        this.collator = expression.getCollation();
        this.implicitTimezone = context.getImplicitTimezone();
        this.compositeKeys = expression.isComposite();
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        this.populationContext.setCurrentIterator(new ManualIterator());
    }

    private AtomicArray getGroupingKey(Item node, List<AtomicMatchKey> comparisonKey) throws XPathException {
        if (this.currentItemFeed != null) {
            throw new XPathException("xsl:for-each-group can't handle overlapping (crawling) nodes");
        }
        ManualIterator popIter = (ManualIterator)this.populationContext.getCurrentIterator();
        popIter.setContextItem(node);
        popIter.incrementPosition();
        Expression groupingKey = ((ForEachGroup)this.getExpression()).getGroupingKey();
        SequenceIterator<?> iter = groupingKey.iterate(this.populationContext);
        AtomicArray key = new AtomicArray(iter);
        for (AtomicValue val : key) {
            comparisonKey.add(val.getXPathComparable(false, this.collator, this.implicitTimezone));
        }
        return key;
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        ArrayList separateKeys;
        ArrayList<AtomicMatchKey> comparisonKey = new ArrayList<AtomicMatchKey>();
        AtomicArray key = this.getGroupingKey(node, comparisonKey);
        this.anchorNode = node;
        ArrayList<AtomicValue> distinctKeys = null;
        if (this.compositeKeys) {
            separateKeys = new ArrayList(1);
            separateKeys.add(comparisonKey);
        } else {
            separateKeys = new ArrayList(comparisonKey.size());
            distinctKeys = new ArrayList<AtomicValue>();
            HashSet<AtomicMatchKey> duplicates = new HashSet<AtomicMatchKey>(separateKeys.size());
            int k = 0;
            for (AtomicMatchKey oneKey : comparisonKey) {
                if (duplicates.add(oneKey)) {
                    ArrayList<AtomicMatchKey> arrayList = new ArrayList<AtomicMatchKey>(1);
                    arrayList.add(oneKey);
                    separateKeys.add(arrayList);
                    distinctKeys.add(key.itemAt(k));
                }
                ++k;
            }
        }
        Receiver result = null;
        ArrayList<Feed> groupFeeds = new ArrayList<Feed>();
        int k = 0;
        for (List list : separateKeys) {
            WatchManager.GroupingScope scope;
            boolean newGroup;
            GroupInfo gp;
            block18: {
                block14: {
                    block17: {
                        block15: {
                            Feed actionFeed;
                            Pattern pattern;
                            Trigger watch;
                            block16: {
                                AtomicArray actualKey = this.compositeKeys ? key : (AtomicSequence)distinctKeys.get(k++);
                                gp = this.groups.get(list);
                                newGroup = gp == null;
                                scope = this.getWatchManager().startGroupingScope();
                                this.getWatchManager().startCapturingGroupingWatches(scope);
                                if (newGroup) {
                                    gp = this.makeNewGroup(node, list, actualKey);
                                } else {
                                    ((ManualGroupIterator)gp.bodyContext.getCurrentGroupIterator()).appendToCurrentGroup(node);
                                }
                                gp.scope = scope;
                                if (!this.isActionConsuming()) break block14;
                                if (!newGroup) break block15;
                                ForkAdjunct.FeedToEventBuffer toOutputter = new ForkAdjunct.FeedToEventBuffer(gp.outputter, this.getResult(), this.getContext());
                                NoOpenOrCloseFeed thisFeed = new NoOpenOrCloseFeed(toOutputter, gp.bodyContext);
                                watch = this.getInversion().getWatch(this.getWatchManager(), thisFeed, gp.bodyContext);
                                pattern = watch.getSelection();
                                actionFeed = watch.getAction();
                                if (!(pattern instanceof AnchorPattern)) break block16;
                                gp.feed = actionFeed;
                                gp.feed.open(this.getTerminator());
                                break block17;
                            }
                            FilteringFeed.Filter filter = new FilteringFeed.Filter(){

                                @Override
                                public int matches(Item item, int position) throws XPathException {
                                    return pattern.matchesBeneathAnchor((NodeInfo)item, ForEachGroupParallelAction.this.anchorNode, ForEachGroupParallelAction.this.bodyContext) ? 1 : 0;
                                }
                            };
                            gp.feed = new FilteringFeed(actionFeed, this.getContext(), filter);
                            if (!(pattern instanceof AncestorQualifiedPattern)) break block17;
                            this.getWatchManager().addWatch(watch, true);
                            gp.feed = new NoCloseFeed(gp.feed, this.getContext());
                            break block17;
                        }
                        if (gp.watchList != null) {
                            for (Watch w : gp.watchList) {
                                w.setAnchorNode(node);
                            }
                        }
                    }
                    groupFeeds.add(gp.feed);
                    break block18;
                }
                if (newGroup) {
                    Expression action = ((ForEachGroup)this.getExpression()).getActionExpression();
                    EventBuffer out = gp.outputter;
                    action.process(gp.bodyContext);
                }
            }
            if (newGroup) {
                gp.watchList = gp.scope.watches;
            }
            this.getWatchManager().stopCapturingGroupingWatches(scope);
        }
        if (!groupFeeds.isEmpty()) {
            if (groupFeeds.size() == 1) {
                this.currentItemFeed = (Feed)groupFeeds.get(0);
                result = this.currentItemFeed.startSelectedParentNode(node, locationId);
            } else {
                this.currentItemFeed = new ForkingFeed(groupFeeds, this.getResult());
                result = this.currentItemFeed.startSelectedParentNode(node, locationId);
            }
        }
        return result;
    }

    private GroupInfo makeNewGroup(Item node, List<AtomicMatchKey> comparisonKey, AtomicSequence key) {
        GroupInfo gp = new GroupInfo();
        gp.outputter = new EventBuffer(this.getPipelineConfiguration());
        XPathContextMajor bodyContext = XPathContextMajor.newThreadContext((XPathContextMinor)this.getContext());
        ManualGroupIterator mgi = new ManualGroupIterator(node, this.groupSequence++);
        mgi.setCurrentGroupingKey(key);
        mgi.startNewCurrentGroup(node);
        bodyContext.setCurrentIterator(mgi);
        bodyContext.setCurrentGroupIterator(mgi);
        bodyContext.setReceiver(gp.outputter);
        gp.bodyContext = bodyContext;
        this.groups.put(comparisonKey, gp);
        this.groupList.add(gp);
        return gp;
    }

    @Override
    public void processItem(Item<?> node) throws XPathException {
        ArrayList separateKeys;
        ArrayList<AtomicMatchKey> comparisonKey = new ArrayList<AtomicMatchKey>();
        AtomicArray key = this.getGroupingKey(node, comparisonKey);
        if (this.compositeKeys) {
            separateKeys = new ArrayList(1);
            separateKeys.add(comparisonKey);
        } else {
            separateKeys = new ArrayList(comparisonKey.size());
            HashSet<AtomicMatchKey> duplicates = new HashSet<AtomicMatchKey>(separateKeys.size());
            for (AtomicMatchKey atomicMatchKey : comparisonKey) {
                if (!duplicates.add(atomicMatchKey)) continue;
                ArrayList<AtomicMatchKey> singleKey = new ArrayList<AtomicMatchKey>(1);
                singleKey.add(atomicMatchKey);
                separateKeys.add(singleKey);
            }
        }
        int k = 0;
        for (List list : separateKeys) {
            boolean newGroup;
            AtomicArray actualKey = this.compositeKeys ? key : key.itemAt(k++);
            GroupInfo gp = this.groups.get(list);
            boolean bl = newGroup = gp == null;
            if (newGroup) {
                gp = this.makeNewGroup(node, list, actualKey);
            }
            if (this.isActionConsuming()) {
                if (newGroup) {
                    NoOpenOrCloseFeed thisFeed = new NoOpenOrCloseFeed(this.getResult(), this.getBodyContext());
                    Trigger watch = this.getInversion().getWatch(this.getWatchManager(), thisFeed, gp.bodyContext);
                    gp.feed = watch.getAction();
                    gp.feed.open(this.getTerminator());
                }
                gp.feed.processItem(node);
                continue;
            }
            if (!newGroup) continue;
            Expression action = ((ForEachGroup)this.getExpression()).getActionExpression();
            action.iterate(gp.bodyContext).forEachOrFail(this.getResult()::processItem);
        }
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (this.isActionConsuming()) {
            this.currentItemFeed.endSelectedParentNode(locationId);
            this.currentItemFeed = null;
        }
    }

    @Override
    public void close() throws XPathException {
        for (GroupInfo gp : this.groupList) {
            if (gp.watchList != null) {
                for (Watch w : gp.watchList) {
                    w.close();
                }
            }
            if (gp.feed != null) {
                gp.feed.close();
            }
            EventBuffer out = gp.outputter;
            out.replay(this.getResult().getReceiver());
        }
        super.close();
    }

    private static class ForkingFeed
    implements Feed {
        private List<Feed> prongs;
        private Feed result;

        public ForkingFeed(List<Feed> prongs, Feed result) {
            this.prongs = prongs;
        }

        @Override
        public void close() throws XPathException {
            for (Feed prong : this.prongs) {
                prong.close();
            }
        }

        @Override
        public PipelineConfiguration getPipelineConfiguration() {
            return null;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            for (Feed prong : this.prongs) {
                prong.open(terminator);
            }
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            Receiver result = null;
            for (Feed prong : this.prongs) {
                Receiver r = prong.startSelectedParentNode(node, locationId);
                if (r == null) continue;
                result = result == null ? r : new TeeOutputter(result, r);
            }
            return result;
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            for (Feed prong : this.prongs) {
                prong.endSelectedParentNode(locationId);
            }
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            for (Feed prong : this.prongs) {
                prong.processItem(item);
            }
        }

        @Override
        public Receiver getReceiver() {
            return this.result.getReceiver();
        }
    }

    private static class GroupInfo {
        public XPathContext bodyContext;
        public Feed feed;
        public EventBuffer outputter;
        public List<Watch> watchList;
        public WatchManager.GroupingScope scope;

        private GroupInfo() {
        }
    }
}

