/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.ids_mannheim.korap.Krill;
import de.ids_mannheim.korap.response.Match;
import de.ids_mannheim.korap.response.SearchContext;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class Result
extends Krill {
    ObjectMapper mapper = new ObjectMapper();
    @JsonIgnore
    public static final short ITEMS_PER_PAGE = 25;
    public static final short ITEMS_PER_PAGE_MAX = 100;
    private int startIndex = 0;
    private String serialQuery;
    private List<Match> matches;
    private SearchContext context;
    private short itemsPerPage = (short)25;
    private short itemsPerResource = 0;
    private JsonNode request;
    private static final Logger log = LoggerFactory.getLogger(Match.class);

    public Result() {
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public Result(String query, int startIndex, short itemsPerPage, SearchContext context) {
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.matches = new ArrayList<Match>(itemsPerPage);
        this.serialQuery = query;
        this.startIndex = startIndex;
        this.itemsPerPage = (short)(itemsPerPage > 100 || itemsPerPage < 0 ? 25 : (int)itemsPerPage);
        this.context = context;
    }

    public void add(Match km) {
        this.matches.add(km);
    }

    public short getItemsPerPage() {
        return this.itemsPerPage;
    }

    public Result setItemsPerPage(short count) {
        this.itemsPerPage = count;
        return this;
    }

    public JsonNode getRequest() {
        return this.request;
    }

    public Result setRequest(JsonNode request) {
        this.request = request;
        return this;
    }

    public short getItemsPerResource() {
        return this.itemsPerResource;
    }

    public Result setItemsPerResource(short value) {
        this.itemsPerResource = value;
        return this;
    }

    public Result setItemsPerResource(int value) {
        this.itemsPerResource = (short)value;
        return this;
    }

    public String getSerialQuery() {
        return this.serialQuery;
    }

    @JsonIgnore
    public Match getMatch(int index) {
        return this.matches.get(index);
    }

    public List<Match> getMatches() {
        return this.matches;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public SearchContext getContext() {
        return this.context;
    }

    public Result setContext(SearchContext context) {
        this.context = context;
        return this;
    }

    @Override
    public JsonNode toJsonNode() {
        ObjectNode json = (ObjectNode)this.mapper.valueToTree(super.toJsonNode());
        this._addMeta(json);
        if (this.matches != null) {
            ArrayNode matches = json.putArray("matches");
            for (Match km : this.getMatches()) {
                matches.add(km.toJsonNode());
            }
        }
        return json;
    }

    public String getOverview() {
        StringBuilder sb = new StringBuilder();
        sb.append("Search for: ").append(this.serialQuery).append("\n");
        int i = 1;
        for (Match km : this.getMatches()) {
            sb.append(i++).append(": ").append(km.getSnippetBrackets()).append(" (Doc ").append(km.getLocalDocID()).append(")\n");
        }
        return sb.toString();
    }

    @Deprecated
    public String toTokenListJsonString() {
        ObjectNode meta;
        ObjectNode json = (ObjectNode)this.mapper.valueToTree(super.toJsonNode());
        ObjectNode objectNode = meta = json.has("meta") ? (ObjectNode)json.get("meta") : json.putObject("meta");
        if (this.context != null) {
            meta.put("context", this.getContext().toJsonNode());
        }
        meta.put("itemsPerPage", this.itemsPerPage);
        meta.put("startIndex", this.startIndex);
        if (this.itemsPerResource > 0) {
            meta.put("itemsPerResource", this.itemsPerResource);
        }
        if (this.serialQuery != null) {
            meta.put("serialQuery", this.serialQuery);
        }
        ArrayNode array = json.putArray("matches");
        for (Match km : this.getMatches()) {
            array.add(km.toTokenList());
        }
        try {
            return this.mapper.writeValueAsString(json);
        }
        catch (Exception e) {
            log.warn(e.getLocalizedMessage());
            return "{}";
        }
    }

    private void _addMeta(ObjectNode json) {
        ObjectNode meta = (ObjectNode)this.getMeta().toJsonNode();
        if (this.serialQuery != null) {
            meta.put("serialQuery", this.serialQuery);
        }
        meta.put("itemsPerPage", this.itemsPerPage);
        if (json.has("meta")) {
            ((ObjectNode)json.get("meta")).setAll(meta);
        } else {
            json.set("meta", meta);
        }
    }
}

