/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;

public class KeyValueOptions {
    private Map<String, String> map_ = new HashMap<String, String>();
    private String default_option_;

    public KeyValueOptions(String format) {
        this.parse(format);
    }

    private void parse(String format) {
        String[] args;
        for (String arg : args = format.split(",")) {
            if (arg.length() == 0) continue;
            int index = arg.indexOf(61);
            if (index < 0) {
                if (this.default_option_ != null) {
                    throw new RuntimeException("Default option already set: %s" + args);
                }
                this.default_option_ = arg;
                continue;
            }
            String key = arg.substring(0, index);
            String value = arg.substring(index + 1, arg.length());
            if (this.map_.containsKey(key)) {
                throw new RuntimeException("Key already definded: %s" + args);
            }
            this.map_.put(key, value);
        }
    }

    public Integer getValueAsInteger(String option) {
        String value = this.map_.get(option);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return Integer.valueOf(value);
    }

    public Collection<String> getKeys() {
        return this.map_.keySet();
    }

    public Collection<String> getSortedKeys() {
        LinkedList<String> keys2 = new LinkedList<String>();
        for (String key : this.getKeys()) {
            keys2.add(key);
        }
        Collections.sort(keys2);
        return keys2;
    }

    public String getDefaultOption() {
        return this.default_option_;
    }
}

